/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import pal.distance.DistanceMatrix;
import pal.misc.Identifier;
import pal.tree.Node;
import pal.tree.NodeFactory;
import pal.tree.SimpleTree;

public class ClusterTree
extends SimpleTree {
    public static final ClusteringMethod UPGMA = new UPGMAClusterer();
    public static final ClusteringMethod WPGMA = new WPGMAClusterer();
    public static final ClusteringMethod SINGLE_LINKAGE = new SingleLinkageClusterer();
    public static final ClusteringMethod COMPLETE_LINKAGE = new CompleteLinkageClusterer();
    static final long serialVersionUID = 677888847384253321L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
    }

    public ClusterTree(DistanceMatrix dm, ClusteringMethod cm) {
        if (dm.getIdCount() < 2) {
            new IllegalArgumentException("LESS THAN 2 TAXA IN DISTANCE MATRIX");
        }
        if (!dm.isSymmetric()) {
            new IllegalArgumentException("UNSYMMETRIC DISTANCE MATRIX");
        }
        BuildNode[] nodes = ClusterTree.generateInitialNodes(dm);
        Node root = ClusterTree.generateTree(nodes, cm);
        this.setRoot(root);
    }

    private static final BuildNode[] generateInitialNodes(DistanceMatrix dm) {
        double[][] distances = dm.getClonedDistances();
        BuildNode[] nodes = new BuildNode[distances.length];
        int i = 0;
        while (i < nodes.length) {
            nodes[i] = new BuildNode(distances[i], dm.getIdentifier(i), i);
            ++i;
        }
        return nodes;
    }

    private static final Node generateTree(BuildNode[] nodes, ClusteringMethod cm) {
        int numberOfClusters = nodes.length;
        while (numberOfClusters != 1) {
            BuildNode newCluster;
            double closestPairDistance = nodes[0].getClosestDistance();
            int closestPairStart = 0;
            int i = 1;
            while (i < numberOfClusters) {
                double clusterClosest = nodes[i].getClosestDistance();
                if (clusterClosest < closestPairDistance) {
                    closestPairStart = i;
                    closestPairDistance = clusterClosest;
                }
                ++i;
            }
            int closestPairEnd = nodes[closestPairStart].getClosestIndex();
            if (closestPairStart == numberOfClusters - 1) {
                throw new RuntimeException("Closest pair start is last node!");
            }
            BuildNode closestPairStartNode = nodes[closestPairStart];
            BuildNode closestPairEndNode = nodes[closestPairEnd];
            nodes[closestPairEnd] = nodes[--numberOfClusters];
            double[] newDistances = new double[numberOfClusters];
            int closestPairStartClusterSize = closestPairStartNode.getClusterSize();
            int closestPairEndClusterSize = closestPairEndNode.getClusterSize();
            int i2 = 0;
            while (i2 < numberOfClusters) {
                if (i2 != closestPairStart) {
                    BuildNode n = nodes[i2];
                    double distance = cm.computeDistance(n.getClusterSize(), closestPairStartClusterSize, n.getDistanceTo(closestPairStart), closestPairEndClusterSize, n.getDistanceTo(closestPairEnd));
                    int itsOldIndex = i2 != closestPairEnd ? i2 : numberOfClusters;
                    n.substituteAndRemoveDistance(closestPairStart, distance, closestPairEnd, itsOldIndex);
                    newDistances[i2] = distance;
                }
                ++i2;
            }
            nodes[closestPairStart] = newCluster = new BuildNode(newDistances, closestPairStartNode, closestPairEndNode, cm.computeHeight(closestPairStartClusterSize, closestPairEndClusterSize, closestPairDistance), closestPairStart);
        }
        return nodes[0].generateNode();
    }

    private static final class BuildNode {
        double[] distanceStore_;
        int numberOfDistances_;
        final BuildNode leftChild_;
        final BuildNode rightChild_;
        final Identifier id_;
        int closestIndex_;
        double closestDistance_;
        int clusterSize_;
        final double height_;

        public BuildNode(double[] initialDistances, Identifier id, int myIndex) {
            this.clusterSize_ = 1;
            this.setDistances(initialDistances, myIndex);
            this.id_ = id;
            this.height_ = 0.0;
            this.rightChild_ = null;
            this.leftChild_ = null;
        }

        public BuildNode(double[] initialDistances, BuildNode left, BuildNode right, double relativeHeight, int myIndex) {
            this.clusterSize_ = left.clusterSize_ + right.clusterSize_;
            this.leftChild_ = left;
            this.rightChild_ = right;
            this.height_ = relativeHeight;
            this.setDistances(initialDistances, myIndex);
            this.id_ = null;
        }

        private final void setDistances(double[] distances, int myIndex) {
            this.distanceStore_ = distances;
            this.numberOfDistances_ = distances.length;
            this.updateClosest(myIndex);
        }

        private void updateClosest(int myIndex) {
            int closestIndex = -1;
            double closestDistance = Double.POSITIVE_INFINITY;
            int i = 0;
            while (i < this.numberOfDistances_) {
                if (i != myIndex && this.distanceStore_[i] < closestDistance) {
                    closestDistance = this.distanceStore_[i];
                    closestIndex = i;
                }
                ++i;
            }
            this.closestIndex_ = closestIndex;
            this.closestDistance_ = closestDistance;
        }

        public final double getNodeHeight() {
            return this.height_;
        }

        public final int getClusterSize() {
            return this.clusterSize_;
        }

        public final void removeDistance(int distanceIndex, int myIndex) {
            this.distanceStore_[distanceIndex] = this.distanceStore_[--this.numberOfDistances_];
            if (this.closestIndex_ == distanceIndex) {
                this.updateClosest(myIndex == this.numberOfDistances_ ? distanceIndex : myIndex);
            }
        }

        public final void substituteAndRemoveDistance(int toSubtituteIndex, double newDistance, int toRemoveIndex, int myIndex) {
            this.distanceStore_[toSubtituteIndex] = newDistance;
            if (toSubtituteIndex == toRemoveIndex) {
                throw new IllegalArgumentException("To substitute = to remove!");
            }
            if (toSubtituteIndex >= this.numberOfDistances_) {
                throw new IllegalArgumentException("To substitute invalid!");
            }
            if (toRemoveIndex >= this.numberOfDistances_) {
                throw new IllegalArgumentException("To remove invalid!");
            }
            this.distanceStore_[toRemoveIndex] = this.distanceStore_[--this.numberOfDistances_];
            if (newDistance < this.closestDistance_) {
                this.closestDistance_ = newDistance;
                this.closestIndex_ = toSubtituteIndex;
            } else if (this.closestIndex_ == toRemoveIndex || this.closestIndex_ == toSubtituteIndex) {
                this.updateClosest(myIndex == this.numberOfDistances_ ? toRemoveIndex : myIndex);
            } else if (this.closestIndex_ == this.numberOfDistances_) {
                this.closestIndex_ = toRemoveIndex;
            }
        }

        public final double getClosestDistance() {
            return this.closestDistance_;
        }

        public final int getClosestIndex() {
            return this.closestIndex_;
        }

        public final double getDistanceTo(int distanceIndex) {
            return this.distanceStore_[distanceIndex];
        }

        public final boolean isChild() {
            return this.leftChild_ == null;
        }

        public Node generateNode() {
            if (this.isChild()) {
                return NodeFactory.createNode(this.id_, 0.0);
            }
            Node[] children = new Node[]{this.leftChild_.generateNode(), this.rightChild_.generateNode()};
            children[0].setBranchLength(this.height_ - this.leftChild_.height_);
            children[1].setBranchLength(this.height_ - this.rightChild_.height_);
            Node n = NodeFactory.createNode(children);
            n.setNodeHeight(this.height_);
            return n;
        }

        public boolean checkIntegrity() {
            return this.closestIndex_ < this.numberOfDistances_;
        }

        public static final double getMaxHeight(BuildNode[] nodes) {
            double maxHeight = nodes[0].height_;
            int i = 1;
            while (i < nodes.length) {
                double nodeHeight = nodes[i].height_;
                if (nodeHeight > maxHeight) {
                    maxHeight = nodeHeight;
                }
                ++i;
            }
            return maxHeight;
        }
    }

    private static final class CompleteLinkageClusterer
    extends BaseClusterer {
        private CompleteLinkageClusterer() {
        }

        public double computeDistance(int separateClusterSize, int firstToCombineClusterSize, double firstToCombineClusterToSeparateClusterDistance, int secondToCombineClusterSize, double secondToCombineClusterToSeparateClusterDistance) {
            return Math.max(firstToCombineClusterToSeparateClusterDistance, secondToCombineClusterToSeparateClusterDistance);
        }

        public String getMethodName() {
            return "Complete Linkage";
        }
    }

    private static final class SingleLinkageClusterer
    extends BaseClusterer {
        private SingleLinkageClusterer() {
        }

        public double computeDistance(int separateClusterSize, int firstToCombineClusterSize, double firstToCombineClusterToSeparateClusterDistance, int secondToCombineClusterSize, double secondToCombineClusterToSeparateClusterDistance) {
            return Math.min(firstToCombineClusterToSeparateClusterDistance, secondToCombineClusterToSeparateClusterDistance);
        }

        public String getMethodName() {
            return "Single Linkage";
        }
    }

    private static final class WPGMAClusterer
    extends BaseClusterer {
        private WPGMAClusterer() {
        }

        public double computeDistance(int separateClusterSize, int firstToCombineClusterSize, double firstToCombineClusterToSeparateClusterDistance, int secondToCombineClusterSize, double secondToCombineClusterToSeparateClusterDistance) {
            return (firstToCombineClusterToSeparateClusterDistance + secondToCombineClusterToSeparateClusterDistance) / 2.0;
        }

        public String getMethodName() {
            return "WPGMA";
        }
    }

    private static final class UPGMAClusterer
    extends BaseClusterer {
        private UPGMAClusterer() {
        }

        public double computeDistance(int separateClusterSize, int firstToCombineClusterSize, double firstToCombineClusterToSeparateClusterDistance, int secondToCombineClusterSize, double secondToCombineClusterToSeparateClusterDistance) {
            return ((double)firstToCombineClusterSize * firstToCombineClusterToSeparateClusterDistance + (double)secondToCombineClusterSize * secondToCombineClusterToSeparateClusterDistance) / (double)(firstToCombineClusterSize + secondToCombineClusterSize);
        }

        public String getMethodName() {
            return "UPGMA";
        }
    }

    private static abstract class BaseClusterer
    implements ClusteringMethod {
        private BaseClusterer() {
        }

        public double computeHeight(int firstToCombineClusterSize, int secondToCombineClusterSize, double distance) {
            return distance / 2.0;
        }
    }

    public static interface ClusteringMethod {
        public double computeDistance(int var1, int var2, double var3, int var5, double var6);

        public double computeHeight(int var1, int var2, double var3);

        public String getMethodName();
    }
}

