/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import pal.tree.Node;
import pal.tree.NodeUtils;
import pal.tree.ParameterizedTree;
import pal.tree.Tree;

public class ClockTree
extends ParameterizedTree.ParameterizedTreeBase
implements ParameterizedTree {
    protected double[] parameter;

    public ClockTree() {
    }

    public ClockTree(Tree t) {
        this.setBaseTree(t);
        if (this.getRoot().getChildCount() < 2) {
            throw new IllegalArgumentException("The root node must have at least two childs!");
        }
        this.parameter = new double[this.getNumParameters()];
        int i = 0;
        while (i < this.parameter.length) {
            this.parameter[i] = this.getDefaultValue(i);
            ++i;
        }
        this.parameters2Heights();
        NodeUtils.heights2Lengths(this.getRoot());
    }

    public void update() {
        this.createNodeList();
        NodeUtils.lengths2Heights(this.getRoot());
        this.heights2parameters();
    }

    public int getNumParameters() {
        return this.getInternalNodeCount();
    }

    public void setParameter(double param, int n) {
        this.parameter[n] = param;
        this.parameters2Heights();
        NodeUtils.heights2Lengths(this.getRoot());
    }

    public double getParameter(int n) {
        return this.parameter[n];
    }

    public void setParameterSE(double paramSE, int n) {
    }

    public double getLowerLimit(int n) {
        return 1.0E-9;
    }

    public double getUpperLimit(int n) {
        return 1.0;
    }

    public double getDefaultValue(int n) {
        return 0.04;
    }

    protected void parameters2Heights() {
        int i = 0;
        while (i < this.getExternalNodeCount()) {
            this.getExternalNode(i).setNodeHeight(0.0);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.getInternalNodeCount()) {
            Node node = this.getInternalNode(i2);
            node.setNodeHeight(this.parameter[i2] + NodeUtils.findLargestChild(node));
            ++i2;
        }
    }

    protected void heights2parameters() {
        int i = 0;
        while (i < this.getInternalNodeCount()) {
            Node node = this.getInternalNode(i);
            this.parameter[i] = node.getNodeHeight() - NodeUtils.findLargestChild(node);
            ++i;
        }
    }

    public Tree getCopy() {
        return new ClockTree((Tree)this);
    }

    public String getParameterizationInfo() {
        return "Molecular clock tree";
    }

    public static final ParameterizedTree.Factory getParameterizedTreeFactory() {
        return TreeFactory.DEFAULT_INSTANCE;
    }

    private static class TreeFactory
    implements ParameterizedTree.Factory {
        public static final ParameterizedTree.Factory DEFAULT_INSTANCE = new TreeFactory();

        private TreeFactory() {
        }

        public ParameterizedTree generateNewTree(Tree base) {
            return new ClockTree(base);
        }
    }
}

