/*
 * Decompiled with CFR 0.152.
 */
package pal.supgma;

import pal.distance.DistanceMatrix;
import pal.mep.ConstantMutationRate;
import pal.mep.DeltaModel;
import pal.misc.TimeOrderCharacterData;
import pal.supgma.SUPGMADistanceMatrix;
import pal.tree.ClusterTree;
import pal.tree.Node;
import pal.tree.NodeUtils;

public class SUPGMATree
extends ClusterTree {
    private TimeOrderCharacterData tocd;

    public SUPGMATree(DistanceMatrix m, TimeOrderCharacterData tocd, double rate, ClusterTree.ClusteringMethod cm) {
        this(m, tocd, DeltaModel.Utils.getMutationRateModelBased(ConstantMutationRate.getFixedFactory(rate, tocd.getUnits())), true, cm);
    }

    public SUPGMATree(DistanceMatrix m, TimeOrderCharacterData tocd, DeltaModel deltaModel, boolean allowNegatives, ClusterTree.ClusteringMethod cm) {
        super(new SUPGMADistanceMatrix(m, tocd, deltaModel), cm);
        this.tocd = tocd;
        TimeOrderCharacterData idgroup = tocd;
        this.createNodeList();
        DeltaModel.Instance deltaModelInstance = deltaModel.generateInstance(tocd);
        Node node = null;
        int i = 0;
        while (i < this.getExternalNodeCount()) {
            node = this.getExternalNode(i);
            int index = idgroup.whichIdNumber(node.getIdentifier().getName());
            node.setNodeHeight(deltaModelInstance.getExpectedSubstitutions(index));
            if (!allowNegatives && node.getParent().getNodeHeight() < node.getNodeHeight()) {
                this.fixHeight(node.getParent(), node.getNodeHeight());
            }
            ++i;
        }
        NodeUtils.heights2Lengths(this.getRoot());
    }

    private void fixHeight(Node node, double height) {
        node.setNodeHeight(height);
        if (!node.isRoot() && node.getParent().getNodeHeight() < height) {
            this.fixHeight(node.getParent(), height);
        }
    }
}

