/*
 * Decompiled with CFR 0.152.
 */
package pal.supgma;

import pal.mep.ConstantMutationRate;
import pal.mep.MutationRateModel;
import pal.mep.SteppedMutationRate;
import pal.misc.TimeOrderCharacterData;
import pal.util.HeapSort;

public interface RateHandler {
    public int getNumberOfParameters(TimeOrderCharacterData var1);

    public void adjustDistances(double[][] var1, TimeOrderCharacterData var2);

    public boolean isCICompatible();

    public String getInfo();

    public void fillInLSInfo(double[] var1, int var2, int var3, int var4, double[] var5);

    public MutationRateModel.Factory generateRateModelFactory(double[] var1, TimeOrderCharacterData var2);

    public static final class Utils {
        public static final RateHandler getSingleRateHandler() {
            return SingleRateHandler.INSTANCE;
        }

        public static final int getArbitaryIntervalCount(double[] intervalChangeTimes, double maxSampleTime) {
            int paramCount = 1;
            int i = 0;
            while (i < intervalChangeTimes.length) {
                if (intervalChangeTimes[i] < maxSampleTime) {
                    ++paramCount;
                }
                ++i;
            }
            return paramCount;
        }

        public static final RateHandler getSetRateHandler(double rate, int units) {
            return new SetRateHandler(new ConstantMutationRate(rate, units, rate, rate));
        }

        public static final RateHandler getSetRateHandler(MutationRateModel model) {
            return new SetRateHandler(model);
        }

        public static final RateHandler getOneRatePerIntervalHandler() {
            return OneRatePerIntervalHandler.INSTANCE;
        }

        public static final RateHandler getArbitaryIntervalHandler(double[] times) {
            return new ArbitaryIntervalHandler(times);
        }

        private static final double[] getIntervalChangeTimes(double[] times) {
            if (times[0] < 1.0E-6) {
                return pal.misc.Utils.getCopy(times, 1);
            }
            return pal.misc.Utils.getCopy(times);
        }

        private static final class ArbitaryIntervalHandler
        implements RateHandler {
            private double[] intervalChangeTimes_;

            private ArbitaryIntervalHandler(double[] times) {
                times = pal.misc.Utils.getCopy(times);
                HeapSort.sort(times);
                this.intervalChangeTimes_ = Utils.getIntervalChangeTimes(times);
            }

            public final int getNumberOfParameters(TimeOrderCharacterData tocd) {
                return Utils.getArbitaryIntervalCount(this.intervalChangeTimes_, tocd.getMaximumTime());
            }

            public boolean isCICompatible() {
                return false;
            }

            public void adjustDistances(double[][] matrix, TimeOrderCharacterData tocd) {
            }

            public void fillInLSInfo(double[] mRow, int startingIndex, int minSample, int maxSample, double[] sampleTimes) {
                double startTime = sampleTimes[minSample];
                double endTime = sampleTimes[maxSample];
                double lowerTime = 0.0;
                int interval = 0;
                while (interval < this.intervalChangeTimes_.length) {
                    mRow[startingIndex + interval] = 0.0;
                    ++interval;
                }
                int interval2 = 0;
                while (interval2 < this.intervalChangeTimes_.length) {
                    double higherTime = this.intervalChangeTimes_[interval2];
                    if (startTime >= lowerTime) {
                        if (startTime < higherTime) {
                            mRow[startingIndex + interval2] = endTime <= higherTime ? endTime - startTime : higherTime - startTime;
                        }
                    } else if (endTime >= lowerTime) {
                        mRow[startingIndex + interval2] = endTime <= higherTime ? endTime - lowerTime : higherTime - lowerTime;
                    }
                    lowerTime = higherTime;
                    ++interval2;
                }
                if (endTime > lowerTime) {
                    mRow[startingIndex + this.intervalChangeTimes_.length] = endTime - lowerTime;
                }
            }

            public String getInfo() {
                return "Arbitrary Intervals (Change times:" + pal.misc.Utils.toString(this.intervalChangeTimes_) + ")";
            }

            public MutationRateModel.Factory generateRateModelFactory(double[] deltas, TimeOrderCharacterData tocd) {
                return SteppedMutationRate.getFactory(deltas, this.intervalChangeTimes_, tocd.getUnits(), tocd.getSuggestedMaximumMutationRate());
            }
        }

        private static final class OneRatePerIntervalHandler
        implements RateHandler {
            public static final RateHandler INSTANCE = new OneRatePerIntervalHandler();

            private OneRatePerIntervalHandler() {
            }

            public final int getNumberOfParameters(TimeOrderCharacterData tocd) {
                return tocd.getSampleCount() - 1;
            }

            public boolean isCICompatible() {
                return false;
            }

            public void adjustDistances(double[][] matrix, TimeOrderCharacterData tocd) {
            }

            public void fillInLSInfo(double[] mRow, int startingIndex, int minSample, int maxSample, double[] sampleTimes) {
                int sample = minSample;
                while (sample < maxSample) {
                    mRow[sample + startingIndex] = sampleTimes[sample + 1] - sampleTimes[sample];
                    ++sample;
                }
            }

            public MutationRateModel.Factory generateRateModelFactory(double[] deltas, TimeOrderCharacterData tocd) {
                return SteppedMutationRate.getFactory(deltas, Utils.getIntervalChangeTimes(tocd.getUniqueTimeArray()), tocd.getUnits(), tocd.getSuggestedMaximumMutationRate());
            }

            public String getInfo() {
                return "One Rate Per Interval";
            }
        }

        private static final class SetRateHandler
        implements RateHandler {
            private MutationRateModel rateModel_;

            private SetRateHandler(MutationRateModel rateModel) {
                this.rateModel_ = rateModel;
            }

            public boolean isCICompatible() {
                return false;
            }

            public final int getNumberOfParameters(TimeOrderCharacterData tocd) {
                this.checkTimes(tocd);
                return 0;
            }

            private final void checkTimes(TimeOrderCharacterData tocd) {
                if (!tocd.hasTimes()) {
                    throw new RuntimeException("Assertion error : SetRateHanlder used on untimed data!");
                }
            }

            public String getInfo() {
                return "Set Rate Model (" + this.rateModel_.toSingleLine() + ")";
            }

            public void adjustDistances(double[][] matrix, TimeOrderCharacterData tocd) {
                this.checkTimes(tocd);
                int numberOfTaxa = tocd.getIdCount();
                if (numberOfTaxa != matrix.length) {
                    throw new RuntimeException("Assertion error! Matrix doesn't look compatible with tocd as sizes different (" + matrix.length + ", " + numberOfTaxa + ")");
                }
                int i = 0;
                while (i < numberOfTaxa) {
                    double iTime = tocd.getTime(i);
                    int j = 0;
                    while (j < numberOfTaxa) {
                        if (i != j) {
                            double jTime = tocd.getTime(j);
                            double[] dArray = matrix[i];
                            int n = j;
                            dArray[n] = dArray[n] - this.rateModel_.getExpectedSubstitutions(Math.min(iTime, jTime), Math.max(iTime, jTime));
                        }
                        ++j;
                    }
                    ++i;
                }
            }

            public void fillInLSInfo(double[] mRow, int startingIndex, int minSample, int maxSample, double[] sampleTimes) {
            }

            public MutationRateModel.Factory generateRateModelFactory(double[] deltas, TimeOrderCharacterData tocd) {
                return this.rateModel_.generateFactory();
            }
        }

        private static final class SingleRateHandler
        implements RateHandler {
            public static final RateHandler INSTANCE = new SingleRateHandler();

            private SingleRateHandler() {
            }

            public final int getNumberOfParameters(TimeOrderCharacterData tocd) {
                return 1;
            }

            public boolean isCICompatible() {
                return true;
            }

            public void adjustDistances(double[][] matrix, TimeOrderCharacterData tocd) {
            }

            public void fillInLSInfo(double[] mRow, int startingIndex, int minSample, int maxSample, double[] sampleTimes) {
                mRow[startingIndex] = sampleTimes[maxSample] - sampleTimes[minSample];
            }

            public MutationRateModel.Factory generateRateModelFactory(double[] deltas, TimeOrderCharacterData tocd) {
                return ConstantMutationRate.getFreeFactory(deltas[0], tocd.getUnits(), tocd.getSuggestedMaximumMutationRate());
            }

            public String getInfo() {
                return "Single Rate";
            }
        }
    }
}

