/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import java.io.Serializable;
import pal.misc.TimeOrderCharacterData;

public interface TemporalModelChange
extends Serializable {
    public double getChangeHeight(double[] var1);

    public static final class Utils {
        public static final TemporalModelChange getSampleLinked(int sampleNumber) {
            return new SampleLinked(sampleNumber);
        }

        public static final TemporalModelChange getSpecificTime(double time, TimeOrderCharacterData tocd) {
            return new SpecificTime(time, tocd);
        }

        public static final TemporalModelChange getSpecificHeight(double height) {
            return new SpecificHeight(height);
        }

        private static final class SpecificHeight
        implements TemporalModelChange {
            private final double height_;
            private static final long serialVersionUID = 4783748882221L;

            public SpecificHeight(double height) {
                this.height_ = height;
            }

            public double getChangeHeight(double[] sampleHeights) {
                return this.height_;
            }

            public String toString() {
                return "Height split(" + this.height_ + ")";
            }
        }

        private static final class SpecificTime
        implements TemporalModelChange {
            private final double time_;
            private final double timeDiff_;
            private final int intervalFirstSample_;
            private final double intervalStartTime_;
            private final double intervalWidth_;
            private static final long serialVersionUID = 744728472857724L;

            public SpecificTime(double time, TimeOrderCharacterData tocd) {
                this.time_ = time;
                int numberOfSamples = tocd.getOrdinalCount();
                double[] ordinalTimes = new double[numberOfSamples];
                int i = 0;
                while (i < numberOfSamples) {
                    ordinalTimes[i] = tocd.getOrdinalTime(i);
                    ++i;
                }
                double intervalStart = ordinalTimes[0];
                double intervalEnd = ordinalTimes[1];
                int intervalSample = 0;
                int i2 = 1;
                while (i2 < numberOfSamples - 1) {
                    if (time >= intervalStart && time < intervalEnd) break;
                    intervalSample = i2;
                    intervalStart = ordinalTimes[i2];
                    intervalEnd = ordinalTimes[i2 + 1];
                    ++i2;
                }
                this.intervalFirstSample_ = intervalSample;
                this.intervalStartTime_ = intervalStart;
                this.intervalWidth_ = intervalEnd - intervalStart;
                this.timeDiff_ = time - this.intervalStartTime_;
            }

            public double getChangeHeight(double[] sampleHeights) {
                double startHeight = sampleHeights[this.intervalFirstSample_];
                double heightRange = sampleHeights[this.intervalFirstSample_ + 1] - startHeight;
                double rate = heightRange / this.intervalWidth_;
                double changeHeight = startHeight + this.timeDiff_ * rate;
                return changeHeight;
            }

            public String toString() {
                return "Time split(" + this.time_ + ", " + this.timeDiff_ + ", " + this.intervalFirstSample_ + ", " + this.intervalStartTime_ + ", " + this.intervalWidth_ + ")";
            }
        }

        private static final class SampleLinked
        implements TemporalModelChange {
            private final int sampleNumber_;
            private static final long serialVersionUID = 232554478781247854L;

            public SampleLinked(int sampleNumber) {
                this.sampleNumber_ = sampleNumber;
            }

            public double getChangeHeight(double[] sampleHeights) {
                return sampleHeights[this.sampleNumber_];
            }
        }
    }
}

