/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import pal.datatype.DataType;
import pal.substmodel.MultiRateMatrixHandler;
import pal.substmodel.NeoRateMatrix;
import pal.substmodel.RateMatrixGroup;

public abstract class SimpleRateMatrixGroup
implements RateMatrixGroup {
    private final MultiRateMatrixHandler rateMatrixHandler_;
    private final int numberOfRateMatrixParameters_;
    private final int numberOfSiteClasses_;
    private final int totalNumberOfParameters_;
    private final DataType dataType_;

    public SimpleRateMatrixGroup(NeoRateMatrix[] baseMatrices, double[] equilibriumFrequencies, double[] initialClassProbabilities, DataType dataType) {
        this.rateMatrixHandler_ = new MultiRateMatrixHandler(baseMatrices, equilibriumFrequencies, initialClassProbabilities);
        this.dataType_ = dataType;
        int i = 0;
        while (i < baseMatrices.length) {
            if (baseMatrices[i].getDimension() != dataType.getNumStates()) {
                throw new IllegalArgumentException("Data type incompatible with one or more of the base matrices");
            }
            ++i;
        }
        this.numberOfSiteClasses_ = this.rateMatrixHandler_.getNumberOfSubstitutionClasses();
        this.numberOfRateMatrixParameters_ = this.rateMatrixHandler_.getNumberOfParameters();
        this.totalNumberOfParameters_ = this.numberOfSiteClasses_ + this.numberOfRateMatrixParameters_;
    }

    public int getNumberOfParameters() {
        return this.totalNumberOfParameters_;
    }

    public double getLowerLimit(int n) {
        if (n < this.numberOfSiteClasses_) {
            return this.rateMatrixHandler_.getSubstitutionClassLowerLimit();
        }
        return this.rateMatrixHandler_.getLowerLimit(n - this.numberOfSiteClasses_);
    }

    public double getUpperLimit(int n) {
        if (n < this.numberOfSiteClasses_) {
            return this.rateMatrixHandler_.getSubstitutionClassUpperLimit();
        }
        return this.rateMatrixHandler_.getUpperLimit(n - this.numberOfSiteClasses_);
    }

    public double getDefaultValue(int n) {
        if (n < this.numberOfSiteClasses_) {
            return this.rateMatrixHandler_.getSubstitutionClassDefaultValue();
        }
        return this.rateMatrixHandler_.getDefaultValue(n - this.numberOfSiteClasses_);
    }

    public void setParameters(double[] parameters, double[] categoryProbabilities) {
        this.rateMatrixHandler_.setAllParameters(parameters, categoryProbabilities);
    }

    public double[] getEquilibriumFrequencies() {
        return this.rateMatrixHandler_.getEquilibriumFrequencies();
    }

    public DataType getDataType() {
        return this.dataType_;
    }

    public int getNumberOfTransitionCategories() {
        return this.numberOfSiteClasses_;
    }

    public void getTransitionProbabilities(double branchLength, double[][][] tableStore) {
        this.rateMatrixHandler_.getTransitionProbabilities(branchLength, tableStore);
    }

    public void getTransitionProbabilitiesTranspose(double branchLength, double[][][] tableStore) {
        this.rateMatrixHandler_.getTransitionProbabilitiesTranspose(branchLength, tableStore);
    }

    public void getTransitionProbabilities(double branchLength, int category, double[][] tableStore) {
        this.rateMatrixHandler_.getTransitionProbabilities(branchLength, category, tableStore);
    }

    public void getTransitionProbabilitiesTranspose(double branchLength, int category, double[][] tableStore) {
        this.rateMatrixHandler_.getTransitionProbabilitiesTranspose(branchLength, category, tableStore);
    }

    public String getSummary(double[] parameters, double[] categoryProbabilities) {
        return "?";
    }
}

