/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import pal.io.FormattedOutput;
import pal.misc.PalObjectListener;
import pal.misc.Parameterized;
import pal.misc.Report;

public abstract class RateDistribution
extends PalObjectListener.EventGenerator
implements Parameterized,
Report,
Cloneable,
Serializable {
    public int numRates;
    public double[] rate;
    public double[] probability;
    protected FormattedOutput format = FormattedOutput.getInstance();
    private static final long serialVersionUID = -5584969247361304141L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.rate);
        out.writeObject(this.probability);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.rate = (double[])in.readObject();
        this.probability = (double[])in.readObject();
        this.numRates = this.rate.length;
        this.format = FormattedOutput.getInstance();
    }

    public final int getNumberOfRates() {
        return this.numRates;
    }

    public final double[] getRates() {
        return this.rate;
    }

    public final double getRate(int category) {
        return this.rate[category];
    }

    public RateDistribution(int n) {
        this.numRates = n;
        this.rate = new double[n];
        this.probability = new double[n];
    }

    protected void printRates(PrintWriter out) {
        out.println("Relative rates and their probabilities:\n");
        this.format.displayIntegerWhite(out, this.numRates);
        out.println("   Rate      Probability");
        int i = 0;
        while (i < this.numRates) {
            this.format.displayInteger(out, i + 1, this.numRates);
            out.print("   ");
            this.format.displayDecimal(out, this.rate[i], 5);
            out.print("   ");
            this.format.displayDecimal(out, this.probability[i], 5);
            out.println();
            ++i;
        }
    }

    public final double[] getCategoryProbabilities() {
        return this.probability;
    }

    public final double getCategoryProbability(int category) {
        return this.probability[category];
    }

    public Object clone() {
        try {
            RateDistribution rd = (RateDistribution)super.clone();
            return rd;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

