/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import pal.datatype.CodonTable;
import pal.datatype.Codons;
import pal.datatype.DataType;
import pal.misc.MutableDouble;
import pal.misc.Utils;
import pal.substmodel.RateMatrix;
import pal.substmodel.RateMatrixGroup;
import pal.substmodel.YangCodonModel;

public class NeutralSelectionRateMatrixGroup
implements RateMatrixGroup {
    private final YangCodonModel purifyingModel_;
    private final YangCodonModel neutralModel_;
    private final double[] freqs_;
    private final double[] purifyingParameters_;
    private final double[] neutralParameters_;
    private final MutableDouble kappaStore_;
    private static final long serialVersionUID = 84829859222352L;

    public NeutralSelectionRateMatrixGroup(MutableDouble kappaStore, double[] freqs, CodonTable table) {
        this.freqs_ = Utils.getCopy(freqs);
        this.kappaStore_ = kappaStore;
        this.purifyingModel_ = new YangCodonModel(0.0, kappaStore.getValue(), freqs, table);
        this.neutralModel_ = new YangCodonModel(1.0, kappaStore.getValue(), freqs, table);
        this.purifyingParameters_ = new double[2];
        this.neutralParameters_ = new double[2];
    }

    public void updateParameters(double[] categoryProbabilities) {
        double kappa;
        this.purifyingParameters_[0] = kappa = this.kappaStore_.getValue();
        this.purifyingParameters_[1] = 0.0;
        this.neutralParameters_[0] = kappa;
        this.neutralParameters_[1] = 1.0;
        double scale = categoryProbabilities[0] * this.purifyingModel_.setParametersNoScale(this.purifyingParameters_) + categoryProbabilities[1] * this.neutralModel_.setParametersNoScale(this.neutralParameters_);
        this.neutralModel_.scale(scale);
        this.purifyingModel_.scale(scale);
    }

    public double[] getEquilibriumFrequencies() {
        return this.freqs_;
    }

    public DataType getDataType() {
        return Codons.DEFAULT_INSTANCE;
    }

    public int getNumberOfTransitionCategories() {
        return 2;
    }

    public void getTransitionProbabilities(double branchLength, double[][][] tableStore) {
        this.purifyingModel_.setDistance(branchLength);
        this.neutralModel_.setDistance(branchLength);
        this.purifyingModel_.getTransitionProbabilities(tableStore[0]);
        this.neutralModel_.getTransitionProbabilities(tableStore[1]);
    }

    public void getTransitionProbabilitiesTranspose(double branchLength, double[][][] tableStore) {
        this.purifyingModel_.setDistanceTranspose(branchLength);
        this.neutralModel_.setDistanceTranspose(branchLength);
        this.purifyingModel_.getTransitionProbabilities(tableStore[0]);
        this.neutralModel_.getTransitionProbabilities(tableStore[1]);
    }

    private final RateMatrix getRelatedMatrix(int category) {
        return category == 0 ? this.purifyingModel_ : this.neutralModel_;
    }

    public void getTransitionProbabilities(double branchLength, int category, double[][] tableStore) {
        RateMatrix rm = this.getRelatedMatrix(category);
        rm.setDistance(branchLength);
        rm.getTransitionProbabilities(tableStore);
    }

    public void getTransitionProbabilitiesTranspose(double branchLength, int category, double[][] tableStore) {
        RateMatrix rm = this.getRelatedMatrix(category);
        rm.setDistanceTranspose(branchLength);
        rm.getTransitionProbabilities(tableStore);
    }

    public String getSummary(double[] categoryProbabilities) {
        return "Neutral Selection (kappa = " + this.kappaStore_.getValue() + ", p0 = " + categoryProbabilities[0] + ", p1 =  " + categoryProbabilities[1] + ")";
    }
}

