/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import pal.datatype.DataType;
import pal.misc.Utils;
import pal.substmodel.NeoRateMatrix;

public class GeneralREVRateMatrix
implements NeoRateMatrix {
    private final int dimension_;
    private final int[][] parameterChecks_;
    private final int[] constraints_;
    private final int numberOfParameters_;
    private final int numberOfEffectiveParameters_;
    private final double[] defaultParameters_;

    public GeneralREVRateMatrix(int dimension) {
        this(dimension, GeneralREVRateMatrix.createDefaultConstraints(dimension), null);
    }

    public GeneralREVRateMatrix(int dimension, double[] specifiedDefaultParameters) {
        this(dimension, GeneralREVRateMatrix.createDefaultConstraints(dimension), specifiedDefaultParameters);
    }

    public GeneralREVRateMatrix(int dimension, int[] constraints) {
        this(dimension, constraints, null);
    }

    public GeneralREVRateMatrix(int dimension, int[] constraints, double[] specifiedDefaultParameters) {
        this(dimension, constraints, specifiedDefaultParameters, -1);
    }

    public GeneralREVRateMatrix(int dimension, int[] constraints, double[] specifiedDefaultParameters, int fixedConstraintValue) {
        this.dimension_ = dimension;
        this.constraints_ = Utils.getCopy(constraints);
        int[] parameterContraintMatchup = new int[constraints.length];
        int numberOfParametersFound = 0;
        this.parameterChecks_ = new int[dimension][dimension];
        int constraintIndex = 0;
        int fixedParameter = -1;
        int from = 0;
        while (from < dimension) {
            int to = from + 1;
            while (to < dimension) {
                int constraintValue = constraints == null || constraintIndex >= constraints.length ? constraintIndex++ : constraints[constraintIndex++];
                int parameter = -1;
                int i = 0;
                while (i < numberOfParametersFound) {
                    if (parameterContraintMatchup[i] == constraintValue) {
                        parameter = i;
                    }
                    ++i;
                }
                if (parameter < 0) {
                    parameter = numberOfParametersFound++;
                    if (fixedConstraintValue == constraintValue) {
                        fixedParameter = parameter;
                    }
                    parameterContraintMatchup[parameter] = constraintValue;
                }
                this.parameterChecks_[from][to] = parameter;
                ++to;
            }
            ++from;
        }
        this.numberOfParameters_ = numberOfParametersFound;
        this.numberOfEffectiveParameters_ = numberOfParametersFound - 1;
        System.out.println("Fixed parameter:" + fixedParameter);
        if (fixedParameter >= 0 && fixedParameter != this.numberOfEffectiveParameters_) {
            int from2 = 0;
            while (from2 < dimension) {
                int to = from2 + 1;
                while (to < dimension) {
                    int p = this.parameterChecks_[from2][to];
                    if (p == this.numberOfEffectiveParameters_) {
                        this.parameterChecks_[from2][to] = fixedParameter;
                    } else if (p == fixedParameter) {
                        this.parameterChecks_[from2][to] = this.numberOfEffectiveParameters_;
                    }
                    ++to;
                }
                ++from2;
            }
        }
        System.out.println("Number of effective parameters:" + this.numberOfEffectiveParameters_);
        this.defaultParameters_ = new double[this.numberOfEffectiveParameters_];
        if (specifiedDefaultParameters == null) {
            int i = 0;
            while (i < this.numberOfEffectiveParameters_) {
                this.defaultParameters_[i] = 1.0;
                ++i;
            }
        } else {
            System.arraycopy(specifiedDefaultParameters, 0, this.defaultParameters_, 0, this.numberOfEffectiveParameters_);
        }
        System.out.println("Number of effective parameters:" + this.numberOfEffectiveParameters_);
    }

    private static final int[] createDefaultConstraints(int dimension) {
        int[] result = new int[dimension * (dimension - 1) / 2];
        int i = 0;
        while (i < result.length) {
            result[i] = i;
            ++i;
        }
        return result;
    }

    public String getUniqueName() {
        return "General REV (dimension " + this.dimension_ + ")";
    }

    public boolean isReversible() {
        return true;
    }

    public int getDimension() {
        return this.dimension_;
    }

    public boolean isDataTypeCompatible(DataType dt) {
        return dt.getNumStates() == this.dimension_;
    }

    public void createRelativeRates(double[][] rateStore, double[] rateParameters, int startIndex) {
        int from = 0;
        while (from < this.dimension_) {
            rateStore[from][from] = 0.0;
            int to = from + 1;
            while (to < this.dimension_) {
                int parameterIndex = this.parameterChecks_[from][to];
                double value = parameterIndex == this.numberOfEffectiveParameters_ ? 1.0 : rateParameters[parameterIndex + startIndex];
                double d = value;
                rateStore[to][from] = d;
                rateStore[from][to] = d;
                ++to;
            }
            ++from;
        }
    }

    public int getNumberOfRateParameters() {
        return this.numberOfEffectiveParameters_;
    }

    public double getRateParameterLowerBound(int parameter) {
        return 0.0;
    }

    public double getRateParameterUpperBound(int parameter) {
        return 100000.0;
    }

    public void getDefaultRateParameters(double[] store, int startIndex) {
        System.arraycopy(this.defaultParameters_, 0, store, startIndex, this.defaultParameters_.length);
    }

    public static final GeneralREVRateMatrix createGTR() {
        return new GeneralREVRateMatrix(4);
    }

    public static final GeneralREVRateMatrix createGTR(double[] defaultParameters) {
        return new GeneralREVRateMatrix(4, defaultParameters);
    }

    public static final GeneralREVRateMatrix createGTR(double a, double b, double c, double d, double e) {
        return new GeneralREVRateMatrix(4, new double[]{a, b, c, d, e});
    }

    public static final GeneralREVRateMatrix createHKY() {
        return GeneralREVRateMatrix.createHKY(2.0);
    }

    public static final GeneralREVRateMatrix createHKY(double defaultKappa) {
        return new GeneralREVRateMatrix(4, new int[]{0, 1, 0, 0, 1, 0}, new double[]{defaultKappa}, 0);
    }
}

