/*
 * Decompiled with CFR 0.152.
 */
package pal.statistics;

import pal.eval.SiteDetails;
import pal.math.MersenneTwisterFast;
import pal.misc.Utils;
import pal.statistics.TopologyTestEngine;
import pal.util.AlgorithmCallback;

public class RELLTopologyPool
implements TopologyTestEngine.TopologyPool {
    private final SiteDetails[] baseTopologies_;
    private final double[] logLikelihoods_;
    private final int numberOfSites_;
    private final MersenneTwisterFast random_ = new MersenneTwisterFast();

    public RELLTopologyPool(SiteDetails[] topologies, int numberOfSites) {
        this.numberOfSites_ = numberOfSites;
        this.baseTopologies_ = new SiteDetails[topologies.length];
        System.arraycopy(topologies, 0, this.baseTopologies_, 0, topologies.length);
        this.logLikelihoods_ = new double[topologies.length];
        this.calculateOriginalLogLikelihoods();
    }

    private void calculateOriginalLogLikelihoods() {
        int i = 0;
        while (i < this.baseTopologies_.length) {
            this.logLikelihoods_[i] = Utils.getSum(this.baseTopologies_[i].getSiteLogLikelihoods());
            ++i;
        }
    }

    public int getNumberOfTopologies() {
        return this.baseTopologies_.length;
    }

    public double[] getOriginalOptimisedLogLikelihoods() {
        return this.logLikelihoods_;
    }

    private final double getReplicateLogLikelihood(int[] siteLookup, int topology) {
        double[] siteLogLikelihoods = this.baseTopologies_[topology].getSiteLogLikelihoods();
        double total = 0.0;
        int i = 0;
        while (i < this.numberOfSites_) {
            total += siteLogLikelihoods[siteLookup[i]];
            ++i;
        }
        return total;
    }

    public double[] getNewReplicateLogLikelihoods(AlgorithmCallback callback) {
        double[] replicateLogLikelihoods = new double[this.baseTopologies_.length];
        int[] siteLookup = new int[this.numberOfSites_];
        int i = 0;
        while (i < this.numberOfSites_) {
            siteLookup[i] = this.random_.nextInt(this.numberOfSites_);
            ++i;
        }
        int topology = 0;
        while (topology < this.baseTopologies_.length) {
            callback.updateProgress((double)topology / (double)this.baseTopologies_.length);
            replicateLogLikelihoods[topology] = this.getReplicateLogLikelihood(siteLookup, topology);
            ++topology;
        }
        return replicateLogLikelihoods;
    }
}

