/*
 * Decompiled with CFR 0.152.
 */
package pal.statistics;

import pal.alignment.Alignment;
import pal.substmodel.SubstitutionModel;
import pal.tree.Tree;
import pal.treesearch.UnrootedMLSearcher;
import pal.util.AlgorithmCallback;

public interface LikelihoodEvaluator {
    public MLResult getMLOptimised(Tree var1, Alignment var2, AlgorithmCallback var3);

    public double calculateLikelihood(Tree var1, Alignment var2);

    public static final class Utils {
        public static final LikelihoodEvaluator createSimpleEvaluator(SubstitutionModel model) {
            return new SimpleLikelihoodEvaluator(model, 1.0E-6);
        }

        private static final class SimpleLikelihoodEvaluator
        implements LikelihoodEvaluator {
            private final SubstitutionModel model_;
            private final double likelihoodConvergenceTolerance_;

            public SimpleLikelihoodEvaluator(SubstitutionModel model, double likelihoodConvergenceTolerance) {
                this.model_ = model;
                this.likelihoodConvergenceTolerance_ = likelihoodConvergenceTolerance;
            }

            public MLResult getMLOptimised(Tree tree, Alignment alignment, AlgorithmCallback callback) {
                UnrootedMLSearcher searcher = new UnrootedMLSearcher(tree, alignment, this.model_);
                double logLikelihood = searcher.simpleOptimiseLikelihood(this.likelihoodConvergenceTolerance_, callback);
                return new SimpleMLResult(logLikelihood, searcher.buildPALTree());
            }

            public double calculateLikelihood(Tree tree, Alignment alignment) {
                UnrootedMLSearcher searcher = new UnrootedMLSearcher(tree, alignment, this.model_);
                return searcher.calculateLogLikelihood();
            }
        }
    }

    public static final class SimpleMLResult
    implements MLResult {
        private final double logLikelihood_;
        private final Tree optimisedTree_;

        public SimpleMLResult(double logLikelihood, Tree optimisedTree) {
            this.logLikelihood_ = logLikelihood;
            this.optimisedTree_ = optimisedTree;
        }

        public double getLogLikelihood() {
            return this.logLikelihood_;
        }

        public Tree getOptimisedTree() {
            return this.optimisedTree_;
        }
    }

    public static interface MLResult {
        public double getLogLikelihood();

        public Tree getOptimisedTree();
    }
}

