/*
 * Decompiled with CFR 0.152.
 */
package pal.statistics;

public class FisherExact {
    private double[] f;
    int maxSize;

    public FisherExact(int maxSize) {
        this.maxSize = maxSize;
        double cf = 1.0;
        this.f = new double[maxSize + 1];
        this.f[0] = 0.0;
        int i = 1;
        while (i <= this.maxSize) {
            this.f[i] = this.f[i - 1] + Math.log(i);
            ++i;
        }
    }

    public final double getP(int a, int b, int c, int d) {
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = this.f[a + b] + this.f[c + d] + this.f[a + c] + this.f[b + d] - (this.f[a] + this.f[b] + this.f[c] + this.f[d] + this.f[n]);
        return Math.exp(p);
    }

    public final double getCumlativeP(int a, int b, int c, int d) {
        int i;
        int min;
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = 0.0;
        p += this.getP(a, b, c, d);
        if (a * d >= b * c) {
            min = c < b ? c : b;
            i = 0;
            while (i < min) {
                p += this.getP(++a, --b, --c, ++d);
                ++i;
            }
        }
        if (a * d < b * c) {
            min = a < d ? a : d;
            i = 0;
            while (i < min) {
                p += this.getP(--a, ++b, ++c, --d);
                ++i;
            }
        }
        return p;
    }
}

