/*
 * Decompiled with CFR 0.152.
 */
package pal.statistics;

import pal.statistics.ChiSquareDistribution;

public class ChiSquareTest {
    public static double compare(double[] ef, int[] of) {
        boolean chi2failed = false;
        int samples = 0;
        int i = 0;
        while (i < of.length) {
            samples += of[i];
            ++i;
        }
        double chi2 = 0.0;
        int below1 = 0;
        int below5 = 0;
        int i2 = 0;
        while (i2 < of.length) {
            double efn = ef[i2] * (double)samples;
            if (efn < 1.0) {
                ++below1;
            }
            if (efn < 5.0) {
                ++below5;
            }
            chi2 += ((double)of[i2] - efn) * ((double)of[i2] - efn) / efn;
            ++i2;
        }
        double criticals = ChiSquareTest.chi2prob(of.length - 1, chi2);
        if (below1 > 0) {
            chi2failed = true;
        }
        if (below5 > (int)Math.floor((double)samples / 5.0)) {
            chi2failed = true;
        }
        if (chi2failed) {
            return -criticals;
        }
        return criticals;
    }

    private static double chi2prob(int deg, double chi2) {
        return 1.0 - ChiSquareDistribution.cdf(chi2, deg);
    }
}

