/*
 * Decompiled with CFR 0.152.
 */
package pal.misc;

import pal.misc.Parameterized;

public class MultiParameterized
implements Parameterized {
    private final Parameterized[] bases_;
    private final int[] baseLookup_;
    private final int[] baseParameter_;
    private final ParameterAccessWatcher watcher_;

    public MultiParameterized(Parameterized b1, Parameterized b2) {
        this(new Parameterized[]{b1, b2}, null);
    }

    public MultiParameterized(Parameterized[] bases) {
        this(bases, null);
    }

    public MultiParameterized(Parameterized[] bases, ParameterAccessWatcher watcher) {
        this.watcher_ = watcher;
        int numberOfParameters = MultiParameterized.countParameters(bases);
        this.baseLookup_ = new int[numberOfParameters];
        this.baseParameter_ = new int[numberOfParameters];
        this.bases_ = bases;
        MultiParameterized.setup(this.bases_, this.baseLookup_, this.baseParameter_);
    }

    protected static final int countParameters(Parameterized[] ps) {
        int count = 0;
        int i = 0;
        while (i < ps.length) {
            count += ps[i].getNumParameters();
            ++i;
        }
        return count;
    }

    protected final int getIndex(Parameterized base) {
        int i = 0;
        while (i < this.bases_.length) {
            if (this.bases_[i] == base) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Unknown parameterized base:" + base);
    }

    public final double[] getBaseParameters(Parameterized base) {
        return this.getBaseParameters(this.getIndex(base));
    }

    public final double[] getBaseParameters(int baseIndex) {
        return Parameterized.Utils.getParameters(this.bases_[baseIndex]);
    }

    protected static final void setup(Parameterized[] ps, int[] baseLookup, int[] baseParameter) {
        int index = 0;
        int pIndex = 0;
        while (pIndex < ps.length) {
            Parameterized p = ps[pIndex];
            int numberOfParameters = p.getNumParameters();
            int i = 0;
            while (i < numberOfParameters) {
                baseLookup[index] = pIndex;
                baseParameter[index] = i++;
                ++index;
            }
            ++pIndex;
        }
    }

    public final int getNumParameters() {
        return this.baseLookup_.length;
    }

    public void setParameterSE(double paramSE, int n) {
        this.bases_[this.baseLookup_[n]].setParameterSE(paramSE, this.baseParameter_[n]);
    }

    public void setParameter(double param, int n) {
        this.bases_[this.baseLookup_[n]].setParameter(param, this.baseParameter_[n]);
        if (this.watcher_ != null) {
            this.watcher_.parameterSet(this.bases_[this.baseLookup_[n]], param, this.baseParameter_[n]);
        }
    }

    public double getParameter(int n) {
        return this.bases_[this.baseLookup_[n]].getParameter(this.baseParameter_[n]);
    }

    public double getUpperLimit(int n) {
        return this.bases_[this.baseLookup_[n]].getUpperLimit(this.baseParameter_[n]);
    }

    public double getLowerLimit(int n) {
        return this.bases_[this.baseLookup_[n]].getLowerLimit(this.baseParameter_[n]);
    }

    public double getDefaultValue(int n) {
        return this.bases_[this.baseLookup_[n]].getDefaultValue(this.baseParameter_[n]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Multi\n");
        int i = 0;
        while (i < this.bases_.length) {
            sb.append(i + ":" + this.bases_[i] + "\n");
            ++i;
        }
        return sb.toString();
    }

    public static interface ParameterAccessWatcher {
        public void parameterSet(Parameterized var1, double var2, int var4);
    }
}

