/*
 * Decompiled with CFR 0.152.
 */
package pal.misc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import pal.misc.IdGroup;
import pal.misc.Identifier;
import pal.misc.SimpleIdGroup;

public class LabelMapping
implements Serializable {
    Hashtable mappings_ = new Hashtable();
    private static final long serialVersionUID = -9217142171228146380L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.mappings_);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.mappings_ = (Hashtable)in.readObject();
    }

    private LabelMapping(Hashtable mapping) {
        this.mappings_ = mapping;
    }

    private LabelMapping(LabelMapping toCopy) {
        this.mappings_ = (Hashtable)toCopy.mappings_.clone();
    }

    public LabelMapping() {
    }

    public void addMapping(String id, String label) {
        this.mappings_.put(id, label);
    }

    public void addMapping(Identifier id, String label) {
        if (id != null && id.getName() != null) {
            this.mappings_.put(id.getName(), label);
        }
    }

    public void addMappings(String[] ids, String[] labels) {
        int i = 0;
        while (i < ids.length) {
            this.mappings_.put(ids[i], labels[i]);
            ++i;
        }
    }

    public String getLabel(String id, String defaultLabel) {
        if (id == null || !this.mappings_.containsKey(id)) {
            return defaultLabel;
        }
        return this.mappings_.get(id).toString();
    }

    public String getLabel(Identifier id, String defaultLabel) {
        if (id == null) {
            return defaultLabel;
        }
        return this.getLabel(id.getName(), defaultLabel);
    }

    public String getLabel(Identifier id) {
        return this.getLabel(id.getName(), id.getName());
    }

    public Identifier getLabelIdentifier(Identifier id) {
        if (id == null) {
            return null;
        }
        return new Identifier(this.getLabel(id.getName(), id.getName()));
    }

    public LabelMapping getUniquifiedMappings() {
        Hashtable totals = new Hashtable();
        Enumeration e = this.mappings_.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object mapping = this.mappings_.get(key);
            int count = 1;
            if (totals.containsKey(mapping)) {
                count = (Integer)totals.get(mapping) + 1;
            }
            totals.put(mapping, new Integer(count));
        }
        Hashtable counts = new Hashtable();
        Hashtable result = new Hashtable();
        Enumeration e2 = this.mappings_.keys();
        while (e2.hasMoreElements()) {
            Object key = e2.nextElement();
            Object mapping = this.mappings_.get(key);
            int total = (Integer)totals.get(mapping);
            if (total == 1) {
                result.put(key, mapping);
                continue;
            }
            int count = 1;
            if (counts.containsKey(mapping)) {
                count = (Integer)counts.get(mapping) + 1;
            }
            counts.put(mapping, new Integer(count));
            result.put(key, mapping + " " + count);
        }
        return new LabelMapping(result);
    }

    public LabelMapping getRelabeled(Relabeller relabeller) {
        Hashtable newMapping = new Hashtable();
        Enumeration e = this.mappings_.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            String old = this.mappings_.get(key).toString();
            newMapping.put(key, relabeller.getNewLabel(old));
        }
        return new LabelMapping(newMapping);
    }

    public IdGroup getMapped(IdGroup original) {
        String[] oldIDs = Identifier.getNames(original);
        String[] newIDs = new String[oldIDs.length];
        int i = 0;
        while (i < newIDs.length) {
            newIDs[i] = this.getLabel(oldIDs[i], oldIDs[i]);
            ++i;
        }
        return new SimpleIdGroup(newIDs);
    }

    public static interface Relabeller {
        public String getNewLabel(String var1);
    }
}

