/*
 * Decompiled with CFR 0.152.
 */
package pal.misc;

import java.io.Serializable;
import pal.misc.Parameterized;

public interface IndividualParameterHandler
extends Serializable {
    public void setParameter(double var1);

    public void setParameterSE(double var1);

    public double getParameter();

    public double getLowerLimit();

    public double getUpperLimit();

    public double getDefaultValue();

    public static final class Utils {
        public static final IndividualParameterHandler createSimple(Parameterized base, int parameterIndex) {
            return new SimpleParameter(base, parameterIndex);
        }

        public static final IndividualParameterHandler[] createSimple(Parameterized[] bases) {
            int total = 0;
            int i = 0;
            while (i < bases.length) {
                total += bases[i].getNumParameters();
                ++i;
            }
            IndividualParameterHandler[] result = new IndividualParameterHandler[total];
            int count = 0;
            int i2 = 0;
            while (i2 < bases.length) {
                int numberOfParameters = bases[i2].getNumParameters();
                int j = 0;
                while (j < numberOfParameters) {
                    result[count++] = Utils.createSimple(bases[i2], j);
                    ++j;
                }
                ++i2;
            }
            return result;
        }

        public static final IndividualParameterHandler createSimple(Parameterized base, int parameterIndex, Listener listener) {
            return new SimpleParameter(base, parameterIndex);
        }

        private static final class SimpleParameter
        implements IndividualParameterHandler {
            private final Parameterized base_;
            private final int parameterIndex_;
            private final Listener listener_;
            private static final long serialVersionUID = -9932372342424L;

            public SimpleParameter(Parameterized base, int parameterIndex) {
                this(base, parameterIndex, null);
            }

            public SimpleParameter(Parameterized base, int parameterIndex, Listener listener) {
                this.base_ = base;
                this.parameterIndex_ = parameterIndex;
                this.listener_ = listener;
            }

            public void setParameter(double value) {
                this.base_.setParameter(value, this.parameterIndex_);
                if (this.listener_ != null) {
                    this.listener_.parameterChanged(this.base_, this.parameterIndex_, value);
                }
            }

            public void setParameterSE(double value) {
                this.base_.setParameterSE(value, this.parameterIndex_);
            }

            public double getParameter() {
                return this.base_.getParameter(this.parameterIndex_);
            }

            public double getLowerLimit() {
                return this.base_.getLowerLimit(this.parameterIndex_);
            }

            public double getUpperLimit() {
                return this.base_.getUpperLimit(this.parameterIndex_);
            }

            public double getDefaultValue() {
                return this.base_.getDefaultValue(this.parameterIndex_);
            }
        }
    }

    public static interface Listener {
        public void parameterChanged(Parameterized var1, int var2, double var3);
    }
}

