/*
 * Decompiled with CFR 0.152.
 */
package pal.mep;

import java.io.PrintWriter;
import java.io.Serializable;
import pal.eval.MolecularClockLikelihoodModel;
import pal.io.FormattedOutput;
import pal.io.OutputTarget;
import pal.mep.MutationRateModel;
import pal.misc.Parameterized;
import pal.misc.Report;
import pal.misc.SampleInformation;
import pal.misc.Summarizable;
import pal.misc.TimeOrderCharacterData;
import pal.misc.Units;
import pal.misc.Utils;
import pal.treesearch.ConstraintModel;
import pal.treesearch.MRDTGlobalClockModel;
import pal.util.HeapSort;

public class SteppedMutationRate
extends MutationRateModel
implements Report,
Summarizable,
Parameterized,
Serializable {
    private double[] mus;
    private double[] muSEs;
    private double[] muChanges;
    private boolean fixedMus = false;
    String[] summaryTypes = null;
    public static final String REPEATED_TIMES_TEXT = "Repeated times";
    public static final String NEGATIVE_VALUES_TEXT = "Negative values";
    public static final String MAX_TIME_IS_TEXT = "Max time is ";
    public static final String ZERO_TIME_TEXT = "Zero time";
    public static final String INVALID_INTERVALS_TEXT = "Incompatible intervals";

    public SteppedMutationRate(double[] muChanges, int units, double maximumMutationRate) {
        super(units, maximumMutationRate);
        this.muChanges = muChanges;
        this.mus = new double[muChanges.length + 1];
        this.muSEs = new double[muChanges.length + 1];
        int i = 0;
        while (i < this.mus.length) {
            this.mus[i] = this.getDefaultValue(0);
            ++i;
        }
    }

    public SteppedMutationRate(double[] rates, double[] muChanges, int units, double maximumMutationRate) {
        this(rates, muChanges, units, false, maximumMutationRate);
    }

    public SteppedMutationRate(double[] rates, double[] muChanges, int units, boolean fixed, double maximumMutationRate) {
        super(units, maximumMutationRate);
        this.fixedMus = fixed;
        this.mus = rates;
        this.muSEs = new double[rates.length];
        this.muChanges = muChanges;
    }

    public SteppedMutationRate(double[] rates, TimeOrderCharacterData timeInfo) {
        this(rates, timeInfo, false);
    }

    public SteppedMutationRate(double[] rates, TimeOrderCharacterData timeInfo, boolean fixed) {
        super(timeInfo.getUnits(), timeInfo.getSuggestedMaximumMutationRate());
        this.fixedMus = fixed;
        this.mus = rates;
        this.muSEs = new double[rates.length];
        this.muChanges = timeInfo.getUniqueTimeArray();
    }

    private SteppedMutationRate(SteppedMutationRate toCopy) {
        super(toCopy);
        this.mus = Utils.getCopy(toCopy.mus);
        this.muSEs = Utils.getCopy(toCopy.muSEs);
        this.muChanges = Utils.getCopy(toCopy.muChanges);
        this.fixedMus = toCopy.fixedMus;
    }

    public Object clone() {
        return this.getCopy();
    }

    public MutationRateModel getCopy() {
        return new SteppedMutationRate(this);
    }

    public String[] getSummaryTypes() {
        if (this.summaryTypes == null) {
            this.summaryTypes = new String[this.mus.length];
            int i = 0;
            while (i < this.summaryTypes.length) {
                this.summaryTypes[i] = "mu " + i;
                ++i;
            }
        }
        return this.summaryTypes;
    }

    public double getSummaryValue(int summaryType) {
        if (summaryType < this.mus.length) {
            return this.mus[summaryType];
        }
        throw new RuntimeException("Assertion error: unknown summary type :" + summaryType);
    }

    public double getMu() {
        return this.mus[0];
    }

    public void setMu(double m) {
        this.mus[0] = m;
    }

    public void getMus(double[] muStore) {
        System.arraycopy(this.mus, 0, muStore, 0, muStore.length);
    }

    public final double getMutationRate(double t) {
        int muIndex = 0;
        while (muIndex < this.muChanges.length && t > this.muChanges[muIndex]) {
            ++muIndex;
        }
        return this.mus[muIndex];
    }

    public final double getExpectedSubstitutions(double time) {
        double currentTime = 0.0;
        double height = 0.0;
        int muIndex = 0;
        double timeInterval = 0.0;
        while (time > currentTime) {
            if (muIndex >= this.muChanges.length) {
                timeInterval = time - currentTime;
                currentTime = time;
            } else {
                timeInterval = this.muChanges[muIndex] - currentTime;
                if (currentTime + timeInterval > time) {
                    timeInterval = time - currentTime;
                    currentTime = time;
                } else {
                    currentTime = this.muChanges[muIndex];
                }
            }
            height += this.mus[muIndex] * timeInterval;
            ++muIndex;
        }
        return height;
    }

    public final double getEndTime(double expectedSubs, double startTime) {
        expectedSubs += this.getExpectedSubstitutions(startTime);
        int changePoint = 0;
        while (changePoint < this.muChanges.length && expectedSubs < this.getExpectedSubstitutions(this.muChanges[changePoint])) {
            ++changePoint;
        }
        if (changePoint == 0) {
            return expectedSubs / this.mus[changePoint];
        }
        double time = this.muChanges[changePoint - 1];
        double expectedSoFar = this.getExpectedSubstitutions(time);
        return time += (expectedSubs - expectedSoFar) / this.mus[changePoint];
    }

    public final void scale(double scale) {
        int i = 0;
        while (i < this.mus.length) {
            int n = i++;
            this.mus[n] = this.mus[n] * scale;
        }
    }

    public static double[] getTimeIntervals(double[] muChanges, double smallTime, double bigTime) {
        double[] intervals = new double[muChanges.length + 1];
        double currentTime = smallTime;
        double height = 0.0;
        int muIndex = 0;
        while (muIndex < muChanges.length && muChanges[muIndex] < smallTime) {
            ++muIndex;
        }
        double timeInterval = 0.0;
        while (bigTime > currentTime) {
            if (muIndex >= muChanges.length) {
                intervals[muIndex] = bigTime - currentTime;
                currentTime = bigTime;
            } else {
                intervals[muIndex] = muChanges[muIndex] - currentTime;
                if (currentTime + intervals[muIndex] > bigTime) {
                    intervals[muIndex] = bigTime - currentTime;
                    currentTime = bigTime;
                } else {
                    currentTime = muChanges[muIndex];
                }
            }
            ++muIndex;
        }
        return intervals;
    }

    public double[] getDeltas(double[] times) {
        double height = 0.0;
        double[] deltas = new double[times.length - 1];
        int i = 0;
        while (i < deltas.length) {
            deltas[i] = this.getExpectedSubstitutions(times[i + 1]) - height;
            height += deltas[i];
            ++i;
        }
        return deltas;
    }

    public int getNumParameters() {
        if (this.fixedMus) {
            return 0;
        }
        return this.mus.length;
    }

    public double getParameter(int k) {
        return this.mus[k];
    }

    public double getUpperLimit(int k) {
        return this.getMaximumMutationRate();
    }

    public double getLowerLimit(int k) {
        return 0.0;
    }

    public double getDefaultValue(int k) {
        if (this.getUnits() == 1) {
            return 1.0E-6;
        }
        return 1.0E-6;
    }

    public void setParameter(double value, int k) {
        this.mus[k] = value;
    }

    public void setParameterSE(double value, int k) {
        this.muSEs[k] = value;
    }

    public String toString() {
        OutputTarget out = OutputTarget.openString();
        this.report(out);
        out.close();
        return out.getString();
    }

    public void report(PrintWriter out) {
        out.println("Mutation rate model: stepped mutation rate ");
        out.print("Unit of time: ");
        out.println(Units.UNIT_NAMES[this.getUnits()]);
        out.println();
        out.println();
        out.println("Parameters of demographic function:");
        out.println(" mu\tinterval");
        int i = 0;
        while (i < this.mus.length) {
            this.fo.displayDecimal(out, this.mus[i], 6);
            if (i == 0) {
                out.print("\t0.0 to ");
                this.fo.displayDecimal(out, this.muChanges[i], 6);
                out.println();
            } else {
                out.print("\t");
                this.fo.displayDecimal(out, this.muChanges[i - 1], 6);
                out.print(" to ");
                if (i < this.muChanges.length) {
                    this.fo.displayDecimal(out, this.muChanges[i], 6);
                    out.println();
                } else {
                    out.println("infinity");
                }
            }
            ++i;
        }
    }

    public double[] getMus() {
        double[] newMus = new double[this.mus.length];
        int i = 0;
        while (i < newMus.length) {
            newMus[i] = this.mus[i];
            ++i;
        }
        return newMus;
    }

    public final double[] getMuChanges() {
        return Utils.getCopy(this.muChanges);
    }

    public String toSingleLine() {
        return "Stepped rate model. Interval rates:" + FormattedOutput.getInstance().getSFString(this.mus, 4, ", ");
    }

    public MutationRateModel.Factory generateFactory() {
        return new GivenMURateFactory(this.mus, this.muChanges, this.getUnits(), this.getMaximumMutationRate());
    }

    public static final MutationRateModel.Factory getFactory(double[] muChanges, int units, double maximumMutationRate) {
        return new RateFactory(muChanges, units, maximumMutationRate);
    }

    public static final MutationRateModel.Factory getFactory(double[] rates, double[] muChanges, int units, double maximumMutationRate) {
        return new GivenMURateFactory(rates, muChanges, units, maximumMutationRate);
    }

    public static final MutationRateModel.Factory getFactory(double[] muChanges, TimeOrderCharacterData tocd) {
        return new RateFactory(muChanges, tocd.getUnits(), tocd.getSuggestedMaximumMutationRate());
    }

    public static final String checkMuChanges(boolean allowEstimationOutsideSamplingTimes, double[] muChanges, boolean sortMuChanges, double[] sampleTimes, boolean sortSampleTimes) {
        if (sortMuChanges) {
            HeapSort.sort(muChanges);
        } else {
            muChanges = HeapSort.getSorted(muChanges);
        }
        if (sortSampleTimes) {
            HeapSort.sort(sampleTimes);
        } else {
            sampleTimes = HeapSort.getSorted(sampleTimes);
        }
        if (!allowEstimationOutsideSamplingTimes && muChanges[muChanges.length - 1] > sampleTimes[sampleTimes.length - 1]) {
            return MAX_TIME_IS_TEXT + sampleTimes[sampleTimes.length - 1];
        }
        int i = 0;
        while (i < muChanges.length) {
            if (muChanges[i] < 0.0) {
                return NEGATIVE_VALUES_TEXT;
            }
            if (muChanges[0] < 1.0E-5) {
                return ZERO_TIME_TEXT;
            }
            if (i != muChanges.length - 1 && Math.abs(muChanges[i] - muChanges[i + 1]) < 1.0E-5) {
                return REPEATED_TIMES_TEXT;
            }
            ++i;
        }
        int t = 0;
        while (t < sampleTimes.length - 1) {
            double lowerTime = sampleTimes[t];
            double higherTime = sampleTimes[t + 1];
            double timeOne = 0.0;
            int i2 = 0;
            while (i2 < muChanges.length - 1) {
                double timeTwo = muChanges[i2];
                double timeThree = muChanges[i2 + 1];
                if (timeOne >= lowerTime && timeThree <= higherTime) {
                    return INVALID_INTERVALS_TEXT;
                }
                timeOne = timeTwo;
                ++i2;
            }
            ++t;
        }
        return null;
    }

    private static final class GivenMURateFactory
    implements MutationRateModel.Factory {
        private final double[] muChanges_;
        private final double[] rates_;
        private final int units_;
        private final double maximumMutationRate_;

        public GivenMURateFactory(double[] rates, double[] muChanges, int units, double maximumMutationRate) {
            this.muChanges_ = Utils.getCopy(muChanges);
            this.rates_ = Utils.getCopy(rates);
            this.units_ = units;
            this.maximumMutationRate_ = maximumMutationRate;
        }

        public MutationRateModel generateNewModel() {
            return new SteppedMutationRate(Utils.getCopy(this.rates_), Utils.getCopy(this.muChanges_), this.units_, this.maximumMutationRate_);
        }

        public ConstraintModel buildConstraintModel(SampleInformation si, MolecularClockLikelihoodModel.Instance likelihoodModel) {
            throw new RuntimeException("Not implemented yet!");
        }
    }

    private static final class RateFactory
    implements MutationRateModel.Factory {
        private final double[] muChanges_;
        private final int units_;
        private final double maximumMutationRate_;

        public RateFactory(double[] muChanges, int units, double maximumMutationRate) {
            this.muChanges_ = Utils.getCopy(muChanges);
            this.units_ = units;
            this.maximumMutationRate_ = maximumMutationRate;
        }

        public MutationRateModel generateNewModel() {
            return new SteppedMutationRate(Utils.getCopy(this.muChanges_), this.units_, this.maximumMutationRate_);
        }

        public ConstraintModel buildConstraintModel(SampleInformation si, MolecularClockLikelihoodModel.Instance likelihoodModel) {
            return new MRDTGlobalClockModel(si, likelihoodModel, this.muChanges_);
        }
    }
}

