/*
 * Decompiled with CFR 0.152.
 */
package pal.math;

import pal.math.MultivariateFunction;
import pal.math.OrthogonalHints;

public class BoundsCheckedFunction
implements MultivariateFunction {
    private MultivariateFunction f;
    private double veryLarge;

    public BoundsCheckedFunction(MultivariateFunction func) {
        this(func, 1000000.0);
    }

    public BoundsCheckedFunction(MultivariateFunction func, double largeNumber) {
        this.f = func;
        this.veryLarge = largeNumber;
    }

    public double evaluate(double[] x) {
        int len = this.f.getNumArguments();
        int i = 0;
        while (i < len) {
            if (x[i] < this.f.getLowerBound(i) || x[i] > this.f.getUpperBound(i)) {
                return this.veryLarge;
            }
            ++i;
        }
        return this.f.evaluate(x);
    }

    public int getNumArguments() {
        return this.f.getNumArguments();
    }

    public double getLowerBound(int n) {
        return this.f.getLowerBound(n);
    }

    public double getUpperBound(int n) {
        return this.f.getUpperBound(n);
    }

    public OrthogonalHints getOrthogonalHints() {
        return null;
    }
}

