/*
 * Decompiled with CFR 0.152.
 */
package pal.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import pal.gui.NameColouriser;
import pal.gui.TreePainter;
import pal.gui.TreePainterCircular;
import pal.gui.TreePainterNormal;
import pal.misc.LabelMapping;
import pal.misc.TimeOrderCharacterData;
import pal.tree.Tree;

public class TreeComponent
extends Component {
    boolean circular_ = false;
    public static final int NORMAL_BW = 0;
    public static final int CIRCULAR_BW = 1;
    public static final int NORMAL_COLOR = 2;
    public static final int CIRCULAR_COLOR = 3;
    int mode_;
    public static final String[] MODE_NAMES = new String[4];
    TreePainterCircular circlePainter_;
    TreePainter painter_;
    boolean invertCiruclar_;

    public TreeComponent(Tree tree, boolean usingSymbols) {
        this(tree, (TimeOrderCharacterData)null, usingSymbols);
    }

    public TreeComponent(Tree tree, TimeOrderCharacterData tocd, boolean usingSymbols) {
        this(tree);
        if (tocd != null) {
            this.painter_.setTimeOrderCharacterData(tocd);
        }
        this.painter_.setUsingSymbols(usingSymbols);
    }

    public TreeComponent(Tree tree) {
        this(tree, "", false);
    }

    public TreeComponent(Tree tree, String title) {
        this(tree, title, true);
    }

    public TreeComponent(Tree tree, String title, boolean showTitle) {
        this.painter_ = new TreePainterNormal(tree, title, showTitle);
        this.circlePainter_ = new TreePainterCircular(tree, title, showTitle);
        this.setMode(2);
        this.setSize(this.getPreferredSize());
    }

    public final void setLabelMapping(LabelMapping lm) {
        this.painter_.setLabelMapping(lm);
        this.circlePainter_.setLabelMapping(lm);
    }

    public void setColouriser(NameColouriser nc) {
        this.painter_.setColouriser(nc);
        this.circlePainter_.setColouriser(nc);
    }

    public void setAttributeName(String name) {
        this.painter_.setAttributeName(name);
        this.repaint();
    }

    public void setMaxHeight(double maxHeight) {
        this.painter_.setMaxHeight(maxHeight);
    }

    public void setTree(Tree tree) {
        this.painter_.setTree(tree);
        this.circlePainter_.setTree(tree);
    }

    public void setTitle(String title) {
        this.painter_.setTitle(title);
        this.circlePainter_.setTitle(title);
    }

    public Dimension getPreferredSize() {
        return this.painter_.getPreferredSize();
    }

    public void setInvertCircular(boolean invert) {
        this.invertCiruclar_ = invert;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public String getTitle() {
        return this.painter_.getTitle();
    }

    public void setMode(int mode) {
        this.mode_ = mode;
        switch (mode) {
            case 0: {
                this.circular_ = false;
                this.painter_.setUsingColor(false);
                break;
            }
            case 2: {
                this.circular_ = false;
                this.painter_.setUsingColor(true);
                break;
            }
            case 1: {
                this.circular_ = true;
                this.circlePainter_.setUsingColor(false);
                break;
            }
            case 3: {
                this.circular_ = true;
                this.circlePainter_.setUsingColor(true);
            }
        }
    }

    public void paint(Graphics g) {
        if (!this.circular_) {
            this.painter_.paint(g, this.getSize().width, this.getSize().height);
        } else {
            this.circlePainter_.paint(g, this.getSize().width, this.getSize().height, this.invertCiruclar_);
        }
    }

    static {
        TreeComponent.MODE_NAMES[0] = "Normal (bw)";
        TreeComponent.MODE_NAMES[1] = "Circular (bw)";
        TreeComponent.MODE_NAMES[2] = "Normal (color)";
        TreeComponent.MODE_NAMES[3] = "Circular (color)";
    }
}

