/*
 * Decompiled with CFR 0.152.
 */
package pal.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public interface LabelDisplayer {
    public void display(Graphics var1, String var2, int var3, int var4);

    public static final class Utils {
        public static final LabelDisplayer buildDisplay(Color c) {
            return new ColourDisplay(c);
        }

        public static final LabelDisplayer buildDisplay(Color c, int style) {
            return new ColourAndFontStyleDisplay(c, style);
        }

        private static final class ColourAndFontStyleDisplay
        implements LabelDisplayer {
            private final Color c_;
            private final int fontStyle_;

            public ColourAndFontStyleDisplay(Color c, int fontStyle) {
                this.c_ = c;
                this.fontStyle_ = fontStyle;
            }

            public void display(Graphics g, String text, int x, int y) {
                Color old = g.getColor();
                Font oldFont = g.getFont();
                g.setColor(this.c_);
                System.out.println("Making bold:");
                Font newFont = oldFont.deriveFont(this.fontStyle_);
                g.setFont(newFont);
                g.drawString(text, x, y);
                g.setColor(old);
                g.setFont(oldFont);
            }
        }

        private static final class ColourDisplay
        implements LabelDisplayer {
            private final Color c_;

            public ColourDisplay(Color c) {
                this.c_ = c;
            }

            public void display(Graphics g, String text, int x, int y) {
                Color old = g.getColor();
                g.setColor(this.c_);
                g.drawString(text, x, y);
                g.setColor(old);
            }
        }
    }
}

