/*
 * Decompiled with CFR 0.152.
 */
package pal.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class CircularGraphics {
    double worldRadius_;
    double worldAngle_;
    public int screenCentreX;
    public int screenCentreY;
    public int screenRadius;
    static final double TWO_PI = Math.PI * 2;
    Graphics g_;
    FontMetrics fm_;
    Font font_;
    boolean invertY_;

    public CircularGraphics(Graphics g, double worldAngle, double worldRadius, int screenX, int screenY, int screenWidth, int screenHeight) {
        this(g, worldAngle, worldRadius, screenX, screenY, screenWidth, screenHeight, false);
    }

    public CircularGraphics(Graphics g, double worldAngle, double worldRadius, int screenX, int screenY, int screenWidth, int screenHeight, boolean invertY) {
        this.g_ = g;
        this.invertY_ = invertY;
        this.worldAngle_ = worldAngle;
        this.worldRadius_ = worldRadius;
        this.screenRadius = Math.min(screenWidth / 2, screenHeight / 2);
        this.screenCentreX = screenX + screenWidth / 2;
        this.screenCentreY = screenY + screenHeight / 2;
        this.font_ = this.g_.getFont();
        if (this.font_ != null) {
            this.fm_ = this.g_.getFontMetrics(this.font_);
        }
    }

    public void setFont(Font newFont) {
        this.g_.setFont(newFont);
        this.font_ = newFont;
        this.fm_ = this.g_.getFontMetrics(this.font_);
    }

    public void drawLine(double angle1, double radius1, double angle2, double radius2) {
        this.g_.drawLine(this.getScreenX(angle1, radius1), this.getScreenY(angle1, radius1), this.getScreenX(angle2, radius2), this.getScreenY(angle2, radius2));
    }

    public void drawLine(double angle, double radiusStart, double radiusEnd) {
        this.g_.drawLine(this.getScreenX(angle, radiusStart), this.getScreenY(angle, radiusStart), this.getScreenX(angle, radiusEnd), this.getScreenY(angle, radiusEnd));
    }

    public void drawLineDegreeAlign(double angle, double radiusStart, double radiusEnd) {
        angle = (double)((int)(angle * 360.0 / this.worldAngle_)) * this.worldAngle_ / 360.0;
        this.g_.drawLine(this.getScreenX(angle, radiusStart), this.getScreenY(angle, radiusStart), this.getScreenX(angle, radiusEnd), this.getScreenY(angle, radiusEnd));
    }

    private final double convertRadius(double radius) {
        return this.worldRadius_ - radius;
    }

    public void drawArc(double angleStart, double angleEnd, double radius) {
        int actualRadius = (int)((double)this.screenRadius * this.convertRadius(radius) / this.worldRadius_);
        if (actualRadius < 1) {
            return;
        }
        int startAngle = (int)(angleStart * 360.0 / this.worldAngle_);
        int endAngle = (int)(angleEnd * 360.0 / this.worldAngle_);
        this.g_.drawArc(this.screenCentreX - actualRadius, this.screenCentreY - actualRadius, actualRadius * 2, actualRadius * 2, startAngle, endAngle - startAngle);
    }

    public void setColor(Color c) {
        this.g_.setColor(c);
    }

    public void drawString(String s, double angle, double radius) {
        int sX = this.getScreenX(angle, radius);
        int sY = this.getScreenY(angle, radius);
        FontMetrics fm = this.g_.getFontMetrics(this.g_.getFont());
        int stringWidth = fm.stringWidth(s);
        int stringHeight = fm.getHeight();
        this.g_.drawString(s, sX - stringWidth / 2, sY + stringHeight / 2);
    }

    public void drawString(String s, double angle, double radius, int outdent) {
        int sX = this.getScreenX(angle, radius, outdent);
        int sY = this.getScreenY(angle, radius, outdent);
        FontMetrics fm = this.g_.getFontMetrics(this.g_.getFont());
        int stringWidth = fm.stringWidth(s);
        int stringHeight = fm.getHeight();
        this.g_.drawString(s, sX - stringWidth / 2, sY + stringHeight / 2);
    }

    public void circleString(String s, double angle, double radius, int outdent) {
        int sX = this.getScreenX(angle, radius, outdent);
        int sY = this.getScreenY(angle, radius, outdent);
        FontMetrics fm = this.g_.getFontMetrics(this.g_.getFont());
        int stringWidth = fm.stringWidth(s);
        int stringHeight = fm.getHeight();
        this.g_.drawString(s, sX - stringWidth / 2, sY + stringHeight / 2);
        this.g_.drawOval(sX - stringWidth / 2 - 5, sY - stringHeight / 2 - 2, stringWidth + 10, stringHeight + 10);
    }

    public int getScreenX(double angle, double radius) {
        return this.screenCentreX + (int)(this.convertRadius(radius) * (double)this.screenRadius * Math.cos(angle * (Math.PI * 2) / this.worldAngle_) / this.worldRadius_);
    }

    public int getScreenX(double angle, double radius, int outdent) {
        double trigBit = Math.cos(angle * (Math.PI * 2) / this.worldAngle_);
        return this.screenCentreX + (int)((double)outdent * trigBit + this.convertRadius(radius) * (double)this.screenRadius * trigBit / this.worldRadius_);
    }

    public int getScreenDeltaX(double angle, double radius) {
        return (int)(this.convertRadius(radius) * (double)this.screenRadius * Math.cos(angle * (Math.PI * 2) / this.worldAngle_) / this.worldRadius_);
    }

    public int getScreenY(double angle, double radius) {
        int offset = (int)(this.convertRadius(radius) * (double)this.screenRadius * Math.sin(angle * (Math.PI * 2) / this.worldAngle_) / this.worldRadius_);
        return this.invertY_ ? this.screenCentreY + offset : this.screenCentreY - offset;
    }

    public int getScreenY(double angle, double radius, int outdent) {
        double trigBit = Math.sin(angle * (Math.PI * 2) / this.worldAngle_);
        int offset = (int)((double)outdent * trigBit + this.convertRadius(radius) * (double)this.screenRadius * trigBit / this.worldRadius_);
        return this.invertY_ ? this.screenCentreY + offset : this.screenCentreY - offset;
    }

    public int getScreenDeltaY(double angle, double radius) {
        return (this.invertY_ ? 1 : -1) * (int)(this.convertRadius(radius) * (double)this.screenRadius * Math.sin(angle * (Math.PI * 2) / this.worldAngle_) / this.worldRadius_);
    }

    public void fillPoint(double angle, double radius, int size) {
        int x = this.getScreenX(angle, radius);
        int y = this.getScreenY(angle, radius);
        this.g_.fillOval(x - size, y - size, 2 * size, 2 * size);
    }

    public void drawPoint(double angle, double radius, int size) {
        int x = this.getScreenX(angle, radius);
        int y = this.getScreenY(angle, radius);
        this.g_.drawOval(x - size, y - size, 2 * size, 2 * size);
    }

    public void drawSymbol(double angle, double radius, int outdent, int width, int symbol) {
        int halfWidth = width / 2;
        int x = this.getScreenX(angle, radius, outdent);
        int y = this.getScreenY(angle, radius, outdent);
        switch (symbol % 6) {
            case 0: {
                this.g_.fillRect(x, y, width, width);
                break;
            }
            case 1: {
                this.g_.drawRect(x, y, width, width);
                break;
            }
            case 2: {
                this.g_.fillOval(x, y, width, width);
                break;
            }
            case 3: {
                this.g_.drawOval(x, y, width, width);
                break;
            }
            case 4: {
                this.g_.drawLine(x, y + width, x + halfWidth, y);
                this.g_.drawLine(x + halfWidth, y, x + width, y + width);
                this.g_.drawLine(x, y + width, x + width, y + width);
                break;
            }
            case 5: {
                this.g_.drawLine(x, y, x + width, y + width);
                this.g_.drawLine(x, y + width, x + width, y);
            }
        }
    }
}

