/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import java.io.PrintWriter;
import java.io.Serializable;
import pal.datatype.DataType;
import pal.eval.ConditionalProbabilityStore;
import pal.eval.LHCalculator;
import pal.eval.MolecularClockLikelihoodModel;
import pal.eval.PatternInfo;
import pal.eval.SimpleLHCalculator;
import pal.eval.SiteDetails;
import pal.math.OrthogonalHints;
import pal.misc.NeoParameterized;
import pal.misc.PalObjectListener;
import pal.misc.Utils;
import pal.substmodel.RateMatrixGroup;
import pal.substmodel.SaturatedSingleSplitDistribution;
import pal.substmodel.SingleSplitDistribution;
import pal.substmodel.SubstitutionModel;

public class SingleSplitMolecularClockLikelihoodModel
implements MolecularClockLikelihoodModel {
    private static final boolean isUseLowerModelOnly(double changeHeight, double beforeSplitHeight, double lowerHeight) {
        return changeHeight >= beforeSplitHeight;
    }

    private static final boolean isUseUpperSampleOnly(double changeHeight, double beforeSplitHeight, double afterSplitHeight) {
        return changeHeight <= afterSplitHeight;
    }

    public static final MolecularClockLikelihoodModel.Instance createInstance(RateMatrixGroup beforeSplitMatrices, RateMatrixGroup afterSplitMatrics, NeoParameterized acrossSplitParameters, SingleSplitDistribution probabilityModel, LHCalculator.Factory baseFactory, double splitTime) {
        int numberOfBaseCategories = beforeSplitMatrices.getNumberOfTransitionCategories();
        DataType dt = beforeSplitMatrices.getDataType();
        return new SimpleInstance(beforeSplitMatrices, afterSplitMatrics, acrossSplitParameters, probabilityModel, splitTime, baseFactory.createSeries(numberOfBaseCategories * numberOfBaseCategories, dt));
    }

    public static final MolecularClockLikelihoodModel.Instance createInstance(RateMatrixGroup beforeSplitMatrices, RateMatrixGroup afterSplitMatrics, NeoParameterized acrossSplitParameters, SingleSplitDistribution probabilityModel, double splitTime) {
        return SingleSplitMolecularClockLikelihoodModel.createInstance(beforeSplitMatrices, afterSplitMatrics, acrossSplitParameters, probabilityModel, SimpleLHCalculator.getFactory(), splitTime);
    }

    public static final MolecularClockLikelihoodModel.Instance createInstance(RateMatrixGroup beforeSplitMatrices, RateMatrixGroup afterSplitMatrics, NeoParameterized acrossSplitParameters, double splitTime) {
        return SingleSplitMolecularClockLikelihoodModel.createInstance(beforeSplitMatrices, afterSplitMatrics, acrossSplitParameters, new SaturatedSingleSplitDistribution(beforeSplitMatrices.getNumberOfTransitionCategories()), SimpleLHCalculator.getFactory(), splitTime);
    }

    public static final MolecularClockLikelihoodModel.Instance createInstance(RateMatrixGroup beforeSplitMatrices, RateMatrixGroup afterSplitMatrics, NeoParameterized acrossSplitParameters, double[] classProbabilities, double splitTime) {
        SaturatedSingleSplitDistribution pm;
        int numberOfClasses = beforeSplitMatrices.getNumberOfTransitionCategories();
        if (classProbabilities.length == numberOfClasses) {
            double[] result = new double[numberOfClasses * numberOfClasses];
            int i = 0;
            while (i < numberOfClasses) {
                result[i * numberOfClasses + i] = classProbabilities[i];
                ++i;
            }
            pm = new SaturatedSingleSplitDistribution(beforeSplitMatrices.getNumberOfTransitionCategories(), result);
        } else {
            pm = new SaturatedSingleSplitDistribution(beforeSplitMatrices.getNumberOfTransitionCategories(), classProbabilities);
        }
        return SingleSplitMolecularClockLikelihoodModel.createInstance(beforeSplitMatrices, afterSplitMatrics, acrossSplitParameters, pm, SimpleLHCalculator.getFactory(), splitTime);
    }

    private static final void transpose(double[][] matrix, int numberOfStates) {
        int from = 0;
        while (from < numberOfStates) {
            int to = from;
            while (to < numberOfStates) {
                double temp = matrix[from][to];
                matrix[from][to] = matrix[to][from];
                matrix[to][from] = temp;
                ++to;
            }
            ++from;
        }
    }

    public static final void main(String[] args) {
        double[][] m = new double[][]{{1.0, 8.0, 1.0, 1.0}, {2.0, 7.0, 2.0, 2.0}, {3.0, 6.0, 3.0, 3.0}, {4.0, 4.0, 5.0, 4.0}};
        System.out.println("Base");
        System.out.println(Utils.toString(m));
        SingleSplitMolecularClockLikelihoodModel.transpose(m, 4);
        System.out.println("Transpose");
        System.out.println(Utils.toString(m));
    }

    private static final class CombineModel
    implements SubstitutionModel,
    Serializable,
    NeoParameterized {
        private final RateMatrixGroup beforeSplitMatrices_;
        private final RateMatrixGroup afterSplitMatrices_;
        private final NeoParameterized parameters_;
        private final LHCalculator.External externalCalculator_;
        private final int numberOfStates_;
        private final DataType dataType_;
        private final int numberOfTransitionCategories_;
        private final int numberOfBaseTransitionCategories_;
        private final double[][][] beforeSplitTransitionStore_;
        private final double[][][] afterSplitTransitionStore_;
        private final double[][] singleBeforeSplitTransitionStore_;
        private final double[][] singleAfterSplitTransitionStore_;
        private final double[] equilibriumFrequencies_;
        private final double[] overallCategoryProbabilities_;
        private final double[] afterSplitCategoryProbabilities_;
        private final double[] beforeSplitCategoryProbabilities_;
        private double afterSplitBaseHeight_;
        private final double splitHeight_;
        private boolean isAscendent_;
        private MolecularClockLikelihoodModel.HeightConverter currentHeightConverter_;
        private final TotalModel parent_;
        private boolean needsRebuild_;
        private static final long serialVersionUID = -9348239481572L;

        public CombineModel(TotalModel parent, RateMatrixGroup beforeSplitMatrices, RateMatrixGroup afterSplitMatrices, NeoParameterized parameters, int numberOfBaseTransitionCategories, double splitHeight, LHCalculator.External externalCalculator) {
            this.parameters_ = parameters;
            this.parent_ = parent;
            this.numberOfBaseTransitionCategories_ = numberOfBaseTransitionCategories;
            if (numberOfBaseTransitionCategories != beforeSplitMatrices.getNumberOfTransitionCategories() || numberOfBaseTransitionCategories != afterSplitMatrices.getNumberOfTransitionCategories()) {
                throw new IllegalArgumentException("Invalid matrix array: wrong length (expecting " + numberOfBaseTransitionCategories + ")");
            }
            this.splitHeight_ = splitHeight;
            this.equilibriumFrequencies_ = beforeSplitMatrices.getEquilibriumFrequencies();
            this.numberOfTransitionCategories_ = numberOfBaseTransitionCategories * numberOfBaseTransitionCategories;
            this.beforeSplitMatrices_ = beforeSplitMatrices;
            this.afterSplitMatrices_ = afterSplitMatrices;
            this.externalCalculator_ = externalCalculator;
            this.overallCategoryProbabilities_ = new double[this.numberOfTransitionCategories_];
            this.afterSplitCategoryProbabilities_ = new double[numberOfBaseTransitionCategories];
            this.beforeSplitCategoryProbabilities_ = new double[numberOfBaseTransitionCategories];
            this.dataType_ = beforeSplitMatrices.getDataType();
            this.numberOfStates_ = this.dataType_.getNumStates();
            this.beforeSplitTransitionStore_ = new double[numberOfBaseTransitionCategories][this.numberOfStates_][this.numberOfStates_];
            this.afterSplitTransitionStore_ = new double[numberOfBaseTransitionCategories][this.numberOfStates_][this.numberOfStates_];
            this.singleAfterSplitTransitionStore_ = new double[this.numberOfStates_][this.numberOfStates_];
            this.singleBeforeSplitTransitionStore_ = new double[this.numberOfStates_][this.numberOfStates_];
            boolean index = false;
            this.scheduleRebuild();
        }

        public final void scheduleRebuild() {
            this.needsRebuild_ = true;
        }

        private final void checkRebuild() {
            if (this.needsRebuild_) {
                this.rebuildCategoryProbabilities();
                this.afterSplitMatrices_.updateParameters(this.afterSplitCategoryProbabilities_);
                this.beforeSplitMatrices_.updateParameters(this.beforeSplitCategoryProbabilities_);
                this.needsRebuild_ = false;
            }
        }

        private final void rebuildCategoryProbabilities() {
            double[][] baseProbabilities = this.parent_.getBaseCategoryProbabilities();
            int index = 0;
            int beforeSplit = 0;
            while (beforeSplit < this.numberOfBaseTransitionCategories_) {
                double total = 0.0;
                int afterSplit = 0;
                while (afterSplit < this.numberOfBaseTransitionCategories_) {
                    total += baseProbabilities[beforeSplit][afterSplit];
                    this.overallCategoryProbabilities_[index++] = baseProbabilities[beforeSplit][afterSplit];
                    ++afterSplit;
                }
                this.beforeSplitCategoryProbabilities_[beforeSplit] = total;
                ++beforeSplit;
            }
            int afterSplit = 0;
            while (afterSplit < this.numberOfBaseTransitionCategories_) {
                double total = 0.0;
                int beforeSplit2 = 0;
                while (beforeSplit2 < this.numberOfBaseTransitionCategories_) {
                    total += baseProbabilities[beforeSplit2][afterSplit];
                    ++beforeSplit2;
                }
                this.afterSplitCategoryProbabilities_[afterSplit] = total;
                ++afterSplit;
            }
        }

        public final int getNumberOfStates() {
            return this.numberOfStates_;
        }

        public final void setup(double afterSplitBaseHeight, MolecularClockLikelihoodModel.HeightConverter converter, boolean isAscendent) {
            this.afterSplitBaseHeight_ = afterSplitBaseHeight;
            this.currentHeightConverter_ = converter;
            this.isAscendent_ = isAscendent;
        }

        public final double getAdjustedDistance(double beforeSplitBaseHeight) {
            return beforeSplitBaseHeight - this.afterSplitBaseHeight_;
        }

        public int getNumberOfParameters() {
            return this.parameters_.getNumberOfParameters();
        }

        public void setParameters(double[] parameters, int startIndex) {
            this.parameters_.setParameters(parameters, startIndex);
            this.scheduleRebuild();
        }

        public void getParameters(double[] store, int startIndex) {
            this.parameters_.getParameters(store, startIndex);
        }

        public void getDefaultValues(double[] store, int startIndex) {
            this.parameters_.getDefaultValues(store, startIndex);
        }

        public double getLowerLimit(int n) {
            return this.parameters_.getLowerLimit(n);
        }

        public double getUpperLimit(int n) {
            return this.parameters_.getUpperLimit(n);
        }

        public int getNumParameters() {
            throw new RuntimeException("Assertion error : not expecting use of legacy code!");
        }

        public double getDefaultValue(int n) {
            throw new RuntimeException("Assertion error : not expecting use of legacy code!");
        }

        public void setParameter(double param, int n) {
            throw new RuntimeException("Assertion error : not expecting use of legacy code!");
        }

        public double getParameter(int n) {
            throw new RuntimeException("Assertion error : not expecting use of legacy code!");
        }

        public void setParameterSE(double paramSE, int n) {
            throw new RuntimeException("Assertion error : not expecting use of legacy code!");
        }

        public DataType getDataType() {
            return this.dataType_;
        }

        public int getNumberOfTransitionCategories() {
            return this.numberOfTransitionCategories_;
        }

        public double getTransitionCategoryProbability(int category) {
            this.checkRebuild();
            return this.overallCategoryProbabilities_[category];
        }

        public double[] getTransitionCategoryProbabilities() {
            this.checkRebuild();
            return this.overallCategoryProbabilities_;
        }

        private final void copy(double[][] source, double[][] destination) {
            int i = 0;
            while (i < this.numberOfStates_) {
                System.arraycopy(source[i], 0, destination[i], 0, this.numberOfStates_);
                ++i;
            }
        }

        private final void combine(double[][] beforeSplit, double[][] afterSplit, double[][] result) {
            int from = 0;
            while (from < this.numberOfStates_) {
                int to = 0;
                while (to < this.numberOfStates_) {
                    double total = 0.0;
                    int intermediate = 0;
                    while (intermediate < this.numberOfStates_) {
                        total += beforeSplit[from][intermediate] * afterSplit[intermediate][to];
                        ++intermediate;
                    }
                    result[from][to] = total;
                    ++to;
                }
                ++from;
            }
        }

        private final void combineTranspose(double[][] beforeSplit, double[][] afterSplit, double[][] result) {
            int from = 0;
            while (from < this.numberOfStates_) {
                int to = 0;
                while (to < this.numberOfStates_) {
                    double total = 0.0;
                    int intermediate = 0;
                    while (intermediate < this.numberOfStates_) {
                        total += beforeSplit[intermediate][from] * afterSplit[to][intermediate];
                        ++intermediate;
                    }
                    result[to][from] = total;
                    ++to;
                }
                ++from;
            }
        }

        private final int resultIndex(int beforeSplit, int afterSplit) {
            return beforeSplit * this.numberOfBaseTransitionCategories_ + afterSplit;
        }

        private final void getTransitionProbabilities(double branchLength, double[][][] transitionStore, RateMatrixGroup group, boolean transpose) {
            if (transpose) {
                group.getTransitionProbabilitiesTranspose(branchLength, transitionStore);
            } else {
                group.getTransitionProbabilities(branchLength, transitionStore);
            }
        }

        private final void getTransitionProbabilities(double branchLength, int category, double[][] transitionStore, RateMatrixGroup group, boolean transpose) {
            if (transpose) {
                group.getTransitionProbabilitiesTranspose(branchLength, category, transitionStore);
            } else {
                group.getTransitionProbabilities(branchLength, category, transitionStore);
            }
        }

        private final double sum(double[][] tableStore) {
            double total = 0.0;
            int j = 0;
            while (j < this.numberOfStates_) {
                int i = 0;
                while (i < this.numberOfStates_) {
                    total += tableStore[j][i];
                    ++i;
                }
                ++j;
            }
            return total;
        }

        public boolean isSplit(double beforeSplitBaseHeight) {
            return !(this.splitHeight_ >= beforeSplitBaseHeight) && !(this.splitHeight_ <= this.afterSplitBaseHeight_);
        }

        private final void getSplitTransitionProbabilitiesDescendentImpl(boolean isTranspose, double[][][] tableStore) {
            if (isTranspose) {
                int first = 0;
                while (first < this.numberOfBaseTransitionCategories_) {
                    int second = 0;
                    while (second < this.numberOfBaseTransitionCategories_) {
                        this.combineTranspose(this.beforeSplitTransitionStore_[first], this.afterSplitTransitionStore_[second], tableStore[this.resultIndex(first, second)]);
                        ++second;
                    }
                    ++first;
                }
            } else {
                int first = 0;
                while (first < this.numberOfBaseTransitionCategories_) {
                    int second = 0;
                    while (second < this.numberOfBaseTransitionCategories_) {
                        this.combine(this.beforeSplitTransitionStore_[first], this.afterSplitTransitionStore_[second], tableStore[this.resultIndex(first, second)]);
                        ++second;
                    }
                    ++first;
                }
            }
        }

        private final void getSplitTransitionProbabilitiesAscendentImpl(boolean isTranspose, double[][][] tableStore) {
            if (isTranspose) {
                int first = 0;
                while (first < this.numberOfBaseTransitionCategories_) {
                    int second = 0;
                    while (second < this.numberOfBaseTransitionCategories_) {
                        this.combineTranspose(this.afterSplitTransitionStore_[second], this.beforeSplitTransitionStore_[first], tableStore[this.resultIndex(first, second)]);
                        ++second;
                    }
                    ++first;
                }
            } else {
                int first = 0;
                while (first < this.numberOfBaseTransitionCategories_) {
                    int second = 0;
                    while (second < this.numberOfBaseTransitionCategories_) {
                        this.combine(this.afterSplitTransitionStore_[second], this.beforeSplitTransitionStore_[first], tableStore[this.resultIndex(first, second)]);
                        ++second;
                    }
                    ++first;
                }
            }
        }

        private final void getTransitionProbabilitiesImpl(double branchLength, double[][][] tableStore, boolean isTranspose) {
            double beforeSplitBaseHeight = this.afterSplitBaseHeight_ + branchLength;
            if (this.splitHeight_ >= beforeSplitBaseHeight) {
                this.getTransitionProbabilities(this.currentHeightConverter_.getExpectedSubstitutionDistance(this.afterSplitBaseHeight_, beforeSplitBaseHeight), this.afterSplitTransitionStore_, this.afterSplitMatrices_, isTranspose);
                int beforeSplit = 0;
                while (beforeSplit < this.numberOfBaseTransitionCategories_) {
                    int afterSplit = 0;
                    while (afterSplit < this.numberOfBaseTransitionCategories_) {
                        this.copy(this.afterSplitTransitionStore_[afterSplit], tableStore[this.resultIndex(beforeSplit, afterSplit)]);
                        ++afterSplit;
                    }
                    ++beforeSplit;
                }
            } else if (this.splitHeight_ <= this.afterSplitBaseHeight_) {
                this.getTransitionProbabilities(this.currentHeightConverter_.getExpectedSubstitutionDistance(this.afterSplitBaseHeight_, beforeSplitBaseHeight), this.beforeSplitTransitionStore_, this.beforeSplitMatrices_, isTranspose);
                int beforeSplit = 0;
                while (beforeSplit < this.numberOfBaseTransitionCategories_) {
                    int afterSplit = 0;
                    while (afterSplit < this.numberOfBaseTransitionCategories_) {
                        this.copy(this.beforeSplitTransitionStore_[beforeSplit], tableStore[this.resultIndex(beforeSplit, afterSplit)]);
                        ++afterSplit;
                    }
                    ++beforeSplit;
                }
            } else {
                this.getTransitionProbabilities(this.currentHeightConverter_.getExpectedSubstitutionDistance(this.afterSplitBaseHeight_, this.splitHeight_), this.afterSplitTransitionStore_, this.afterSplitMatrices_, isTranspose);
                this.getTransitionProbabilities(this.currentHeightConverter_.getExpectedSubstitutionDistance(this.splitHeight_, beforeSplitBaseHeight), this.beforeSplitTransitionStore_, this.beforeSplitMatrices_, isTranspose);
                if (this.isAscendent_) {
                    this.getSplitTransitionProbabilitiesAscendentImpl(isTranspose, tableStore);
                } else {
                    this.getSplitTransitionProbabilitiesDescendentImpl(isTranspose, tableStore);
                }
            }
        }

        private final void getTransitionProbabilitiesImpl(double branchLength, int category, double[][] tableStore, boolean isTranspose) {
            double beforeSplitBaseHeight = this.afterSplitBaseHeight_ + branchLength;
            int beforeSplit = category / this.numberOfBaseTransitionCategories_;
            int afterSplit = category % this.numberOfBaseTransitionCategories_;
            if (this.splitHeight_ >= beforeSplitBaseHeight) {
                this.getTransitionProbabilities(this.currentHeightConverter_.getExpectedSubstitutionDistance(this.afterSplitBaseHeight_, beforeSplitBaseHeight), afterSplit, tableStore, this.afterSplitMatrices_, isTranspose);
            } else if (this.splitHeight_ <= this.afterSplitBaseHeight_) {
                this.getTransitionProbabilities(this.currentHeightConverter_.getExpectedSubstitutionDistance(this.afterSplitBaseHeight_, beforeSplitBaseHeight), beforeSplit, tableStore, this.beforeSplitMatrices_, isTranspose);
            } else {
                this.getTransitionProbabilities(this.currentHeightConverter_.getExpectedSubstitutionDistance(this.afterSplitBaseHeight_, this.splitHeight_), afterSplit, this.afterSplitTransitionStore_[0], this.afterSplitMatrices_, isTranspose);
                this.getTransitionProbabilities(this.currentHeightConverter_.getExpectedSubstitutionDistance(this.splitHeight_, beforeSplitBaseHeight), beforeSplit, this.beforeSplitTransitionStore_[0], this.beforeSplitMatrices_, isTranspose);
                if (this.isAscendent_) {
                    if (isTranspose) {
                        this.combineTranspose(this.afterSplitTransitionStore_[0], this.beforeSplitTransitionStore_[0], tableStore);
                    } else {
                        this.combine(this.afterSplitTransitionStore_[0], this.beforeSplitTransitionStore_[0], tableStore);
                    }
                } else if (isTranspose) {
                    this.combineTranspose(this.beforeSplitTransitionStore_[0], this.afterSplitTransitionStore_[0], tableStore);
                } else {
                    this.combine(this.beforeSplitTransitionStore_[0], this.afterSplitTransitionStore_[0], tableStore);
                }
            }
        }

        public void getTransitionProbabilities(double branchLength, double[][][] tableStore) {
            this.checkRebuild();
            this.getTransitionProbabilitiesImpl(branchLength, tableStore, false);
        }

        public void getTransitionProbabilities(double branchLength, int category, double[][] tableStore) {
            this.checkRebuild();
            this.getTransitionProbabilitiesImpl(branchLength, category, tableStore, false);
        }

        public void getTransitionProbabilitiesTranspose(double branchLength, double[][][] tableStore) {
            this.checkRebuild();
            this.getTransitionProbabilitiesImpl(branchLength, tableStore, true);
        }

        public void getTransitionProbabilitiesTranspose(double branchLength, int category, double[][] tableStore) {
            this.checkRebuild();
            this.getTransitionProbabilitiesImpl(branchLength, category, tableStore, true);
        }

        public double[] getEquilibriumFrequencies() {
            return this.equilibriumFrequencies_;
        }

        public void addPalObjectListener(PalObjectListener l) {
            throw new RuntimeException("Not implemented yet!");
        }

        public void removePalObjectListener(PalObjectListener l) {
            throw new RuntimeException("Not implemented yet!");
        }

        public OrthogonalHints getOrthogonalHints() {
            return null;
        }

        public void report(PrintWriter out) {
        }

        public String getSummary() {
            this.checkRebuild();
            double[] afterSplitProbs = new double[this.numberOfBaseTransitionCategories_];
            double[] beforeSplitProbs = new double[this.numberOfBaseTransitionCategories_];
            int i = 0;
            while (i < this.numberOfTransitionCategories_) {
                int afterSplit;
                int beforeSplit = i / this.numberOfBaseTransitionCategories_;
                int n = afterSplit = i % this.numberOfBaseTransitionCategories_;
                afterSplitProbs[n] = afterSplitProbs[n] + this.overallCategoryProbabilities_[i];
                int n2 = beforeSplit;
                beforeSplitProbs[n2] = beforeSplitProbs[n2] + this.overallCategoryProbabilities_[i];
                ++i;
            }
            return "Split height:" + this.splitHeight_ + "\n" + "Category probs:" + Utils.toString(this.overallCategoryProbabilities_) + "\n" + "Before Split probs:" + Utils.toString(this.beforeSplitCategoryProbabilities_) + "\n" + "Before Split probs (check):" + Utils.toString(beforeSplitProbs) + "\n" + "After Split probs:" + Utils.toString(this.afterSplitCategoryProbabilities_) + "\n" + "After Split probs (check):" + Utils.toString(afterSplitProbs) + "\n" + "Parameters:" + this.parameters_.toString();
        }

        public final Object clone() {
            throw new RuntimeException("Not implemented yet!");
        }
    }

    private static final class TotalModel
    implements Serializable,
    NeoParameterized {
        private final SingleSplitDistribution probabilityModel_;
        private final CombineModel combineModel_;
        private final int numberOfProbabilityParameters_;
        private final int numberOfParameters_;

        public TotalModel(RateMatrixGroup beforeSplitMatrices, RateMatrixGroup afterSplitMatrices, NeoParameterized acrossSplitParameters, SingleSplitDistribution probabilityModel, double splitHeight, LHCalculator.External externalCalculator) {
            this.probabilityModel_ = probabilityModel;
            this.numberOfProbabilityParameters_ = probabilityModel.getNumberOfParameters();
            this.combineModel_ = new CombineModel(this, beforeSplitMatrices, afterSplitMatrices, acrossSplitParameters, probabilityModel.getNumberOfBaseTransitionCategories(), splitHeight, externalCalculator);
            this.numberOfParameters_ = probabilityModel.getNumberOfParameters() + this.combineModel_.getNumberOfParameters();
        }

        public final int getNumberOfTransitionCategories() {
            return this.combineModel_.getNumberOfTransitionCategories();
        }

        public final double[][] getBaseCategoryProbabilities() {
            return this.probabilityModel_.getDistributionInfo();
        }

        public final CombineModel getCombineModel() {
            return this.combineModel_;
        }

        public String getSummary() {
            return "Distribution:" + this.probabilityModel_ + "\nModel:" + this.combineModel_.getSummary();
        }

        public int getNumberOfParameters() {
            return this.numberOfParameters_;
        }

        public void setParameters(double[] parameters, int startIndex) {
            this.probabilityModel_.setParameters(parameters, startIndex);
            this.combineModel_.setParameters(parameters, startIndex + this.numberOfProbabilityParameters_);
        }

        public void getParameters(double[] parameterStore, int startIndex) {
            this.probabilityModel_.getParameters(parameterStore, startIndex);
            this.combineModel_.getParameters(parameterStore, startIndex + this.numberOfProbabilityParameters_);
        }

        public double getLowerLimit(int n) {
            if (n < this.numberOfProbabilityParameters_) {
                return this.probabilityModel_.getLowerLimit(n);
            }
            return this.combineModel_.getLowerLimit(n - this.numberOfProbabilityParameters_);
        }

        public double getUpperLimit(int n) {
            if (n < this.numberOfProbabilityParameters_) {
                return this.probabilityModel_.getUpperLimit(n);
            }
            return this.combineModel_.getUpperLimit(n - this.numberOfProbabilityParameters_);
        }

        public void getDefaultValues(double[] store, int startIndex) {
            this.probabilityModel_.getDefaultValues(store, startIndex);
            this.combineModel_.getDefaultValues(store, startIndex + this.numberOfProbabilityParameters_);
        }
    }

    private static final class SimpleInstance
    implements MolecularClockLikelihoodModel.Instance,
    Serializable {
        private final LHCalculator.Generator baseGenerator_;
        private final TotalModel totalModel_;

        public SimpleInstance(RateMatrixGroup beforeSplitModel, RateMatrixGroup afterSplitModel, NeoParameterized acrossSplitParameters, SingleSplitDistribution probabilityModel, double splitTime, LHCalculator.Generator baseGenerator) {
            this.totalModel_ = new TotalModel(beforeSplitModel, afterSplitModel, acrossSplitParameters, probabilityModel, splitTime, baseGenerator.createNewExternal());
            this.baseGenerator_ = baseGenerator;
        }

        public NeoParameterized getSubstitutionModelParameterAccess() {
            return this.totalModel_;
        }

        public boolean hasSubstitutionModelParameters() {
            return true;
        }

        public MolecularClockLikelihoodModel.Leaf createNewLeaf(MolecularClockLikelihoodModel.HeightConverter heightConverter, PatternInfo pattern, int[] patternStateMatchup) {
            return new LeafImpl(this.baseGenerator_.createNewLeaf(patternStateMatchup, pattern.getNumberOfPatterns()), this.totalModel_.getCombineModel(), pattern.getNumberOfPatterns(), heightConverter);
        }

        public MolecularClockLikelihoodModel.External createNewExternal(MolecularClockLikelihoodModel.HeightConverter heightConverter) {
            return new ExternalImpl(this.baseGenerator_.createNewExternal(), this.totalModel_.getCombineModel(), heightConverter);
        }

        public MolecularClockLikelihoodModel.Internal createNewInternal(MolecularClockLikelihoodModel.HeightConverter heightConverter) {
            return new InternalImpl(this.baseGenerator_, this.totalModel_.getCombineModel(), heightConverter);
        }

        public ConditionalProbabilityStore createAppropriateConditionalProbabilityStore(boolean isForLeaf) {
            return this.baseGenerator_.createAppropriateConditionalProbabilityStore(isForLeaf);
        }

        public String getSubstitutionModelSummary() {
            return "Model:" + this.totalModel_.getSummary();
        }

        public NeoParameterized getParameterAccess() {
            return this.totalModel_;
        }
    }

    private static final class InternalImpl
    implements MolecularClockLikelihoodModel.Internal {
        private final LHCalculator.Internal base_;
        private final CombineModel model_;
        private final MolecularClockLikelihoodModel.HeightConverter heightConverter_;

        public InternalImpl(LHCalculator.Generator generator, CombineModel model, MolecularClockLikelihoodModel.HeightConverter heightConverter) {
            this.base_ = generator.createNewInternal();
            this.model_ = model;
            this.heightConverter_ = heightConverter;
        }

        public ConditionalProbabilityStore calculatePostExtendedFlatConditionals(double topBaseHeight, double bottomBaseHeight, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties) {
            this.model_.setup(bottomBaseHeight, this.heightConverter_, false);
            return this.base_.calculatePostExtendedFlat(this.model_.getAdjustedDistance(topBaseHeight), this.model_, centerPattern, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties, true);
        }

        public ConditionalProbabilityStore calculateExtendedConditionals(double topBaseHeight, double bottomBaseHeight, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties) {
            this.model_.setup(bottomBaseHeight, this.heightConverter_, false);
            return this.base_.calculateExtended(this.model_.getAdjustedDistance(topBaseHeight), this.model_, centerPattern, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties, true);
        }

        public ConditionalProbabilityStore calculateAscendentExtendedConditionals(double topBaseHeight, double bottomBaseHeight, PatternInfo centerPattern, ConditionalProbabilityStore ascenedentConditionalProbabilityProbabilties, ConditionalProbabilityStore otherConditionalProbabilityProbabilties) {
            this.model_.setup(bottomBaseHeight, this.heightConverter_, true);
            return this.base_.calculateExtended(this.model_.getAdjustedDistance(topBaseHeight), this.model_, centerPattern, ascenedentConditionalProbabilityProbabilties, otherConditionalProbabilityProbabilties, true);
        }

        public ConditionalProbabilityStore calculateAscendentFlatConditionals(PatternInfo centerPattern, ConditionalProbabilityStore ascenedentConditionalProbabilityProbabilties, ConditionalProbabilityStore otherConditionalProbabilityProbabilties) {
            return this.base_.calculateFlat(centerPattern, ascenedentConditionalProbabilityProbabilties, otherConditionalProbabilityProbabilties);
        }

        public ConditionalProbabilityStore calculateFlatConditionals(PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties) {
            return this.base_.calculateFlat(centerPattern, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties);
        }
    }

    private static final class LeafImpl
    implements MolecularClockLikelihoodModel.Leaf {
        private final LHCalculator.Leaf base_;
        private final CombineModel model_;
        private final int numberOfPatterns_;
        private final MolecularClockLikelihoodModel.HeightConverter heightConverter_;

        public LeafImpl(LHCalculator.Leaf base, CombineModel model, int numberOfPatterns, MolecularClockLikelihoodModel.HeightConverter heightConverter) {
            this.base_ = base;
            this.model_ = model;
            this.numberOfPatterns_ = numberOfPatterns;
            this.heightConverter_ = heightConverter;
        }

        public ConditionalProbabilityStore calculateExtendedConditionals(double topBaseHeight, double bottomBaseHeight) {
            this.model_.setup(bottomBaseHeight, this.heightConverter_, false);
            return this.base_.getExtendedConditionalProbabilities(this.model_.getAdjustedDistance(topBaseHeight), this.model_, true);
        }

        public ConditionalProbabilityStore calculateFlatConditionals(double relatedHeight) {
            return this.base_.getFlatConditionalProbabilities();
        }
    }

    private static final class ExternalImpl
    implements MolecularClockLikelihoodModel.External {
        private final LHCalculator.External base_;
        private final CombineModel model_;
        private final MolecularClockLikelihoodModel.HeightConverter heightConverter_;

        public ExternalImpl(LHCalculator.External base, CombineModel model, MolecularClockLikelihoodModel.HeightConverter heightConverter) {
            this.base_ = base;
            this.model_ = model;
            this.heightConverter_ = heightConverter;
        }

        public void calculateSingleExtendedConditionals(double topBaseHeight, double bottomBaseHeight, int numberOfPatterns, ConditionalProbabilityStore baseConditionalProbabilities, ConditionalProbabilityStore resultConditionalProbabilities) {
            this.model_.setup(bottomBaseHeight, this.heightConverter_, false);
            this.base_.calculateSingleExtendedIndirect(this.model_.getAdjustedDistance(topBaseHeight), this.model_, numberOfPatterns, baseConditionalProbabilities, resultConditionalProbabilities);
        }

        public void calculateSingleDescendentExtendedConditionals(double topBaseHeight, double bottomBaseHeight, PatternInfo centerPattern, ConditionalProbabilityStore descendentConditionalProbabilities) {
            this.model_.setup(bottomBaseHeight, this.heightConverter_, false);
            this.base_.calculateSingleExtendedDirect(this.model_.getAdjustedDistance(topBaseHeight), this.model_, centerPattern.getNumberOfPatterns(), descendentConditionalProbabilities);
        }

        public void calculateSingleAscendentExtendedConditionalsDirect(double topBaseHeight, double bottomBaseHeight, PatternInfo centerPattern, ConditionalProbabilityStore ascendentConditionalProbabilityProbabilties) {
            this.model_.setup(bottomBaseHeight, this.heightConverter_, true);
            this.base_.calculateSingleExtendedDirect(this.model_.getAdjustedDistance(topBaseHeight), this.model_, centerPattern.getNumberOfPatterns(), ascendentConditionalProbabilityProbabilties);
        }

        public void calculateSingleAscendentExtendedConditionalsIndirect(double topBaseHeight, double bottomBaseHeight, PatternInfo centerPattern, ConditionalProbabilityStore baseAscendentConditionalProbabilityProbabilties, ConditionalProbabilityStore resultConditionalProbabilityProbabilties) {
            this.model_.setup(bottomBaseHeight, this.heightConverter_, true);
            this.base_.calculateSingleExtendedIndirect(this.model_.getAdjustedDistance(topBaseHeight), this.model_, centerPattern.getNumberOfPatterns(), baseAscendentConditionalProbabilityProbabilties, resultConditionalProbabilityProbabilties);
        }

        public void calculateExtendedConditionals(double topBaseHeight, double bottomBaseHeight, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilities, ConditionalProbabilityStore rightConditionalProbabilities, ConditionalProbabilityStore resultStore) {
            this.model_.setup(bottomBaseHeight, this.heightConverter_, false);
            this.base_.calculateExtended(this.model_.getAdjustedDistance(topBaseHeight), this.model_, centerPattern, leftConditionalProbabilities, rightConditionalProbabilities, resultStore);
        }

        public double calculateLogLikelihoodNonRoot(double nodeHeight, PatternInfo centerPattern, ConditionalProbabilityStore ascendentConditionalProbabilitiesStore, ConditionalProbabilityStore descendentConditionalProbabilitiesStore) {
            this.model_.setup(nodeHeight, this.heightConverter_, false);
            return this.base_.calculateLogLikelihood(this.model_, centerPattern, ascendentConditionalProbabilitiesStore, descendentConditionalProbabilitiesStore);
        }

        public double calculateLogLikelihood(double rootHeight, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilitiesStore, ConditionalProbabilityStore rightConditionalProbabilitiesStore) {
            this.model_.setup(rootHeight, this.heightConverter_, false);
            return this.base_.calculateLogLikelihood(this.model_, centerPattern, leftConditionalProbabilitiesStore, rightConditionalProbabilitiesStore);
        }

        public double calculateLogLikelihoodSingle(double rootHeight, PatternInfo centerPattern, ConditionalProbabilityStore conditionalProbabilitiesStore) {
            this.model_.setup(rootHeight, this.heightConverter_, false);
            return this.base_.calculateLogLikelihoodSingle(this.model_, centerPattern.getPatternWeights(), centerPattern.getNumberOfPatterns(), conditionalProbabilitiesStore);
        }

        public void calculateFlatConditionals(double rootHeight, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilitiesStore, ConditionalProbabilityStore rightConditionalProbabilitiesStore, ConditionalProbabilityStore resultConditionalProbabilitiesStore) {
            this.model_.setup(rootHeight, this.heightConverter_, false);
            this.base_.calculateFlat(centerPattern, leftConditionalProbabilitiesStore, rightConditionalProbabilitiesStore, resultConditionalProbabilitiesStore);
        }

        public SiteDetails calculateSiteDetails(double rootHeight, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilitiesStore, ConditionalProbabilityStore rightConditionalProbabilitiesStore) {
            this.model_.setup(rootHeight, this.heightConverter_, false);
            return this.base_.calculateSiteDetailsRooted(this.model_, centerPattern, leftConditionalProbabilitiesStore, rightConditionalProbabilitiesStore);
        }

        public void calculateFlatConditionals(double rootHeight, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilitiesStore, ConditionalProbabilityStore rightConditionalProbabilitiesStore, ConditionalProbabilityStore resultConditionalProbabilitiesStore, double[] sampleHeights) {
            this.model_.setup(rootHeight, this.heightConverter_, false);
            this.base_.calculateFlat(centerPattern, leftConditionalProbabilitiesStore, rightConditionalProbabilitiesStore, resultConditionalProbabilitiesStore);
        }
    }
}

