/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import pal.eval.ConditionalProbabilityStore;
import pal.eval.LHCalculator;
import pal.eval.PatternInfo;
import pal.eval.SiteDetails;
import pal.eval.UnconstrainedLikelihoodModel;
import pal.misc.NeoParameterized;
import pal.misc.ParameterizedNeoWrapper;
import pal.substmodel.SubstitutionModel;

public class SimpleUnconstrainedLikelihoodModel
implements UnconstrainedLikelihoodModel {
    public static final UnconstrainedLikelihoodModel.Instance createInstance(LHCalculator.Generator base, SubstitutionModel model) {
        return new InstanceImpl(base, model);
    }

    public static final UnconstrainedLikelihoodModel.Instance createInstance(LHCalculator.Factory base, SubstitutionModel model) {
        return new InstanceImpl(base.createSeries(model.getNumberOfTransitionCategories(), model.getDataType()), model);
    }

    private static final class InstanceImpl
    implements UnconstrainedLikelihoodModel.Instance {
        private final LHCalculator.Generator base_;
        private final SubstitutionModel model_;
        private final NeoParameterized parameterAccess_;

        public InstanceImpl(LHCalculator.Generator base, SubstitutionModel model) {
            this.base_ = base;
            this.model_ = model;
            this.parameterAccess_ = new ParameterizedNeoWrapper(model);
        }

        public UnconstrainedLikelihoodModel.Leaf createNewLeaf(int[] patternStateMatchup, int numberOfPatterns) {
            return new LeafImpl(this.base_.createNewLeaf(patternStateMatchup, numberOfPatterns), this.model_);
        }

        public UnconstrainedLikelihoodModel.External createNewExternal() {
            return new ExternalImpl(this.base_.createNewExternal(), this.model_);
        }

        public UnconstrainedLikelihoodModel.Internal createNewInternal() {
            return new InternalImpl(this.base_.createNewInternal(), this.model_);
        }

        public boolean isAllowCaching() {
            return this.base_.isAllowCaching();
        }

        public ConditionalProbabilityStore createAppropriateConditionalProbabilityStore(boolean isForLeaf) {
            return this.base_.createAppropriateConditionalProbabilityStore(isForLeaf);
        }

        public String getSubstitutionModelSummary() {
            return this.model_.toString();
        }

        public NeoParameterized getParameterAccess() {
            return this.parameterAccess_;
        }
    }

    public static final class LeafImpl
    implements UnconstrainedLikelihoodModel.Leaf {
        private final LHCalculator.Leaf base_;
        private final SubstitutionModel model_;

        public LeafImpl(LHCalculator.Leaf base, SubstitutionModel model) {
            this.base_ = base;
            this.model_ = model;
        }

        public ConditionalProbabilityStore getFlatConditionalProbabilities() {
            return this.base_.getFlatConditionalProbabilities();
        }

        public ConditionalProbabilityStore getExtendedConditionalProbabilities(double distance) {
            return this.base_.getExtendedConditionalProbabilities(distance, this.model_, true);
        }

        public UnconstrainedLikelihoodModel.Leaf getCopy() {
            return new LeafImpl(this.base_.getCopy(), this.model_);
        }
    }

    public static final class InternalImpl
    implements UnconstrainedLikelihoodModel.Internal {
        private final LHCalculator.Internal base_;
        private final SubstitutionModel model_;

        public InternalImpl(LHCalculator.Internal base, SubstitutionModel model) {
            this.base_ = base;
            this.model_ = model;
        }

        public ConditionalProbabilityStore calculateFlat(PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilities, ConditionalProbabilityStore rightConditionalProbabilities) {
            return this.base_.calculateFlat(centerPattern, leftConditionalProbabilities, rightConditionalProbabilities);
        }

        public ConditionalProbabilityStore calculateExtended(double distance, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilities, ConditionalProbabilityStore rightConditionalProbabilities) {
            return this.base_.calculateExtended(distance, this.model_, centerPattern, leftConditionalProbabilities, rightConditionalProbabilities, true);
        }
    }

    private static final class ExternalImpl
    implements UnconstrainedLikelihoodModel.External {
        private final LHCalculator.External base_;
        private final SubstitutionModel model_;

        public ExternalImpl(LHCalculator.External base, SubstitutionModel model) {
            this.base_ = base;
            this.model_ = model;
        }

        public void calculateFlat(PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilities, ConditionalProbabilityStore rightConditionalProbabilities, ConditionalProbabilityStore resultStore) {
            this.base_.calculateFlat(centerPattern, leftConditionalProbabilities, rightConditionalProbabilities, resultStore);
        }

        public void calculateExtended(double distance, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilities, ConditionalProbabilityStore rightConditionalProbabilities, ConditionalProbabilityStore resultStore) {
            this.base_.calculateExtended(distance, this.model_, centerPattern, leftConditionalProbabilities, rightConditionalProbabilities, resultStore);
        }

        public void calculateSingleExtendedDirect(double distance, int numberOfPatterns, ConditionalProbabilityStore conditionalProbabilities) {
            this.base_.calculateSingleExtendedDirect(distance, this.model_, numberOfPatterns, conditionalProbabilities);
        }

        public void calculateSingleExtendedIndirect(double distance, int numberOfPatterns, ConditionalProbabilityStore baseConditionalProbabilities, ConditionalProbabilityStore resultConditionalProbabilities) {
            this.base_.calculateSingleExtendedIndirect(distance, this.model_, numberOfPatterns, baseConditionalProbabilities, resultConditionalProbabilities);
        }

        public double calculateLogLikelihood(double distance, PatternInfo centerPattern, ConditionalProbabilityStore leftFlatConditionalProbabilities, ConditionalProbabilityStore rightFlatConditionalProbabilities, ConditionalProbabilityStore tempStore) {
            return this.base_.calculateLogLikelihood(distance, this.model_, centerPattern, leftFlatConditionalProbabilities, rightFlatConditionalProbabilities, tempStore);
        }

        public double calculateLogLikelihood(PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilities, ConditionalProbabilityStore rightConditionalProbabilities) {
            return this.base_.calculateLogLikelihood(this.model_, centerPattern, leftConditionalProbabilities, rightConditionalProbabilities);
        }

        public double calculateLogLikelihoodSingle(int[] patternWeights, int numberOfPatterns, ConditionalProbabilityStore conditionalProbabilityStore) {
            return this.base_.calculateLogLikelihoodSingle(this.model_, patternWeights, numberOfPatterns, conditionalProbabilityStore);
        }

        public SiteDetails calculateSiteDetailsRooted(PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilitiesStore, ConditionalProbabilityStore rightConditionalProbabilitiesStore) {
            return this.base_.calculateSiteDetailsRooted(this.model_, centerPattern, leftConditionalProbabilitiesStore, rightConditionalProbabilitiesStore);
        }

        public SiteDetails calculateSiteDetailsUnrooted(double distance, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilitiesStore, ConditionalProbabilityStore rightConditionalProbabilitiesStore, ConditionalProbabilityStore tempStore) {
            return this.base_.calculateSiteDetailsUnrooted(distance, this.model_, centerPattern, leftConditionalProbabilitiesStore, rightConditionalProbabilitiesStore, tempStore);
        }
    }
}

