/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import pal.eval.ConditionalProbabilityStore;
import pal.eval.LHCalculator;
import pal.misc.Utils;
import pal.substmodel.SubstitutionModel;

public class SimpleLeafCalculator
implements LHCalculator.Leaf {
    private final int numberOfStates_;
    private final int[] patternStateMatchup_;
    private final int numberOfPatterns_;
    private final int numberOfCategories_;
    private final LHCalculator.Generator parent_;
    private final double[][][] transitionProbabilitiyStore_;
    private final ConditionalProbabilityStore conditionalProbabilities_;
    private final ConditionalProbabilityStore flatConditionalProbabilities_;
    private double lastDistance_ = -1.0;

    private SimpleLeafCalculator(SimpleLeafCalculator toCopy) {
        this.numberOfStates_ = toCopy.numberOfStates_;
        this.patternStateMatchup_ = toCopy.patternStateMatchup_;
        this.numberOfPatterns_ = toCopy.numberOfPatterns_;
        this.numberOfCategories_ = toCopy.numberOfCategories_;
        this.parent_ = toCopy.parent_;
        this.transitionProbabilitiyStore_ = Utils.getCopy(toCopy.transitionProbabilitiyStore_);
        this.flatConditionalProbabilities_ = SimpleLeafCalculator.createFlat(this.patternStateMatchup_, this.numberOfPatterns_, this.numberOfCategories_, this.numberOfStates_, this.parent_);
        this.conditionalProbabilities_ = SimpleLeafCalculator.createExtended(this.transitionProbabilitiyStore_, this.patternStateMatchup_, this.numberOfPatterns_, this.numberOfCategories_, this.numberOfStates_, this.parent_);
        this.lastDistance_ = toCopy.lastDistance_;
    }

    public SimpleLeafCalculator(int[] patternStateMatchup, int numberOfPatterns, int numberOfStates, int numberOfCategories, LHCalculator.Generator parent) {
        this.numberOfStates_ = numberOfStates;
        this.numberOfCategories_ = numberOfCategories;
        this.numberOfPatterns_ = numberOfPatterns;
        this.parent_ = parent;
        this.patternStateMatchup_ = Utils.getCopy(patternStateMatchup);
        this.transitionProbabilitiyStore_ = new double[numberOfCategories][numberOfStates][numberOfStates];
        this.conditionalProbabilities_ = SimpleLeafCalculator.createExtended(this.transitionProbabilitiyStore_, patternStateMatchup, numberOfPatterns, numberOfCategories, numberOfStates, parent);
        this.flatConditionalProbabilities_ = SimpleLeafCalculator.createFlat(patternStateMatchup, numberOfPatterns, numberOfCategories, numberOfStates, parent);
    }

    private static final ConditionalProbabilityStore createFlat(int[] patternStateMatchup, int numberOfPatterns, int numberOfCategories, int numberOfStates, LHCalculator.Generator parent) {
        ConditionalProbabilityStore flatConditionalProbabilities = parent.createAppropriateConditionalProbabilityStore(true);
        double[] gapStore = new double[numberOfStates];
        int i = 0;
        while (i < gapStore.length) {
            gapStore[i] = 1.0;
            ++i;
        }
        double[][] stateStuff = new double[numberOfStates][numberOfStates];
        int i2 = 0;
        while (i2 < numberOfStates) {
            stateStuff[i2][i2] = 1.0;
            ++i2;
        }
        double[][][] flatStore = flatConditionalProbabilities.getIncompleteConditionalProbabilityAccess(numberOfPatterns, true, true);
        int pattern = 0;
        while (pattern < numberOfPatterns) {
            int cat;
            int state = patternStateMatchup[pattern];
            if (state == numberOfStates) {
                cat = 0;
                while (cat < numberOfCategories) {
                    flatStore[cat][pattern] = gapStore;
                    ++cat;
                }
            } else {
                cat = 0;
                while (cat < numberOfCategories) {
                    flatStore[cat][pattern] = stateStuff[state];
                    ++cat;
                }
            }
            ++pattern;
        }
        return flatConditionalProbabilities;
    }

    private static final ConditionalProbabilityStore createExtended(double[][][] transitionProbabilityStore, int[] patternStateMatchup, int numberOfPatterns, int numberOfCategories, int numberOfStates, LHCalculator.Generator parent) {
        ConditionalProbabilityStore extendedConditionalProbabilities = parent.createAppropriateConditionalProbabilityStore(true);
        double[] gapStore = new double[numberOfStates];
        int i = 0;
        while (i < gapStore.length) {
            gapStore[i] = 1.0;
            ++i;
        }
        double[][] stateStuff = new double[numberOfStates][numberOfStates];
        int i2 = 0;
        while (i2 < numberOfStates) {
            stateStuff[i2][i2] = 1.0;
            ++i2;
        }
        double[][][] extendedStore = extendedConditionalProbabilities.getIncompleteConditionalProbabilityAccess(numberOfPatterns, true, true);
        int pattern = 0;
        while (pattern < numberOfPatterns) {
            int cat;
            int state = patternStateMatchup[pattern];
            if (state == numberOfStates) {
                cat = 0;
                while (cat < numberOfCategories) {
                    extendedStore[cat][pattern] = gapStore;
                    ++cat;
                }
            } else {
                cat = 0;
                while (cat < numberOfCategories) {
                    extendedStore[cat][pattern] = transitionProbabilityStore[cat][state];
                    ++cat;
                }
            }
            ++pattern;
        }
        return extendedConditionalProbabilities;
    }

    public LHCalculator.Leaf getCopy() {
        return new SimpleLeafCalculator(this);
    }

    public ConditionalProbabilityStore getFlatConditionalProbabilities() {
        return this.flatConditionalProbabilities_;
    }

    public ConditionalProbabilityStore getExtendedConditionalProbabilities(double distance, SubstitutionModel model, boolean modelChanged) {
        if (distance != this.lastDistance_ || this.lastDistance_ < 0.0 || modelChanged) {
            model.getTransitionProbabilitiesTranspose(distance, this.transitionProbabilitiyStore_);
            this.lastDistance_ = distance;
            this.conditionalProbabilities_.setBasedOnCachedData(false);
        } else {
            this.conditionalProbabilities_.setBasedOnCachedData(true);
        }
        return this.conditionalProbabilities_;
    }
}

