/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import pal.alignment.Alignment;
import pal.alignment.DataTranslator;
import pal.datatype.MolecularDataType;
import pal.eval.GeneralLikelihoodCalculator;
import pal.eval.LikelihoodOptimiser;
import pal.math.OrthogonalSearch;
import pal.mep.ConstantMutationRate;
import pal.mep.SteppedMutationRate;
import pal.misc.TimeOrderCharacterData;
import pal.misc.Utils;
import pal.substmodel.SubstitutionModel;
import pal.tree.ClockTree;
import pal.tree.MutationRateModelTree;
import pal.tree.SimpleTree;
import pal.tree.Tree;
import pal.tree.TreeTool;
import pal.tree.UnconstrainedTree;

public final class LikelihoodTool {
    public static final double calculateLogLikelihood(Tree tree, Alignment alignment, SubstitutionModel model) {
        GeneralLikelihoodCalculator lc = new GeneralLikelihoodCalculator(alignment, tree, model);
        return lc.calculateLogLikelihood();
    }

    public static final Tree optimiseUnrooted(Tree tree, Alignment alignment, SubstitutionModel model, boolean optimiseModel) {
        UnconstrainedTree ut = new UnconstrainedTree(TreeTool.getUnrooted(tree));
        DataTranslator dt = new DataTranslator(alignment);
        alignment = dt.toAlignment(MolecularDataType.Utils.getMolecularDataType(model.getDataType()), 0);
        if (optimiseModel) {
            LikelihoodOptimiser.optimiseCombined(ut, alignment, model, new OrthogonalSearch(), 6, 6);
        } else {
            LikelihoodOptimiser.optimiseTree(ut, alignment, model, new OrthogonalSearch(), 6, 6);
        }
        return new SimpleTree(ut);
    }

    public static final Tree optimiseClockConstrained(Tree tree, Alignment alignment, SubstitutionModel model, boolean optimiseModel) {
        ClockTree ut = new ClockTree(tree);
        DataTranslator dt = new DataTranslator(alignment);
        alignment = dt.toAlignment(MolecularDataType.Utils.getMolecularDataType(model.getDataType()), 0);
        if (optimiseModel) {
            LikelihoodOptimiser.optimiseCombined(ut, alignment, model, new OrthogonalSearch(), 6, 6);
        } else {
            LikelihoodOptimiser.optimiseTree(ut, alignment, model, new OrthogonalSearch(), 6, 6);
        }
        return new SimpleTree(ut);
    }

    public static final Tree optimiseSRDT(Tree tree, Alignment alignment, SubstitutionModel model, TimeOrderCharacterData tocd, boolean optimiseModel, double[] rateStore) {
        ConstantMutationRate cm = new ConstantMutationRate(rateStore[0], tocd.getUnits(), 1.0);
        DataTranslator dt = new DataTranslator(alignment);
        alignment = dt.toAlignment(MolecularDataType.Utils.getMolecularDataType(model.getDataType()), 0);
        MutationRateModelTree mt = new MutationRateModelTree(tree, tocd, cm);
        if (optimiseModel) {
            LikelihoodOptimiser.optimiseCombined(mt, alignment, model, new OrthogonalSearch(), 6, 6);
        } else {
            LikelihoodOptimiser.optimiseTree(mt, alignment, model, new OrthogonalSearch(), 6, 6);
        }
        rateStore[0] = cm.getMu();
        return new SimpleTree(mt);
    }

    public static final Tree optimiseMRDT(Tree tree, Alignment alignment, SubstitutionModel model, TimeOrderCharacterData tocd, boolean optimiseModel, double[] rateStore) {
        SteppedMutationRate smr = new SteppedMutationRate(Utils.getCopy(rateStore), tocd);
        DataTranslator dt = new DataTranslator(alignment);
        alignment = dt.toAlignment(MolecularDataType.Utils.getMolecularDataType(model.getDataType()), 0);
        MutationRateModelTree mt = new MutationRateModelTree(tree, tocd, smr);
        if (optimiseModel) {
            LikelihoodOptimiser.optimiseCombined(mt, alignment, model, new OrthogonalSearch(), 6, 6);
        } else {
            LikelihoodOptimiser.optimiseTree(mt, alignment, model, new OrthogonalSearch(), 6, 6);
        }
        smr.getMus(rateStore);
        return new SimpleTree(mt);
    }

    public static final Tree optimiseMRDT(Tree tree, Alignment alignment, SubstitutionModel model, TimeOrderCharacterData tocd, boolean optimiseModel, double[] rateChangeTimes, double[] rateStore) {
        DataTranslator dt = new DataTranslator(alignment);
        alignment = dt.toAlignment(MolecularDataType.Utils.getMolecularDataType(model.getDataType()), 0);
        SteppedMutationRate smr = new SteppedMutationRate(Utils.getCopy(rateStore), Utils.getCopy(rateChangeTimes), tocd.getUnits(), false, tocd.getSuggestedMaximumMutationRate() * 2.0);
        MutationRateModelTree mt = new MutationRateModelTree(tree, tocd, smr);
        if (optimiseModel) {
            LikelihoodOptimiser.optimiseCombined(mt, alignment, model, new OrthogonalSearch(), 6, 6);
        } else {
            LikelihoodOptimiser.optimiseTree(mt, alignment, model, new OrthogonalSearch(), 6, 6);
        }
        smr.getMus(rateStore);
        return new SimpleTree(mt);
    }

    public static final Alignment getMatchingDataType(Alignment alignment, SubstitutionModel model) {
        DataTranslator dt = new DataTranslator(alignment);
        return dt.toAlignment(MolecularDataType.Utils.getMolecularDataType(model.getDataType()), 0);
    }
}

