/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import pal.alignment.Alignment;
import pal.eval.GeneralLikelihoodCalculator;
import pal.math.MinimiserMonitor;
import pal.math.MultivariateFunction;
import pal.math.MultivariateMinimum;
import pal.math.OrthogonalHints;
import pal.misc.Parameterized;
import pal.substmodel.SubstitutionModel;
import pal.tree.ParameterizedTree;
import pal.tree.Tree;

public class LikelihoodOptimiser {
    private final Function function_;
    private final Tree tree_;
    private final Alignment alignment_;
    private final SubstitutionModel model_;
    private double[] argumentStore_ = null;

    public LikelihoodOptimiser(Tree tree, Alignment alignment, SubstitutionModel model) {
        this.function_ = new Function(tree, alignment, model);
        this.tree_ = tree;
        this.alignment_ = alignment;
        this.model_ = model;
    }

    private final double[] setup(Parameterized parameters) {
        this.function_.setParameters(parameters);
        this.argumentStore_ = this.function_.getCurrentArgumentStore(this.argumentStore_);
        return this.argumentStore_;
    }

    public double optimiseLogLikelihood(Parameterized parameters, MultivariateMinimum minimiser, int fxFracDigits, int xFracDigits, MinimiserMonitor monitor) {
        double result = -minimiser.findMinimum(this.function_, this.setup(parameters), fxFracDigits, xFracDigits, monitor);
        return result;
    }

    public double optimiseLogLikelihood(Parameterized parameters, MultivariateMinimum minimiser, int fxFracDigits, int xFracDigits) {
        double result = -minimiser.findMinimum(this.function_, this.setup(parameters), fxFracDigits, xFracDigits);
        return result;
    }

    public static final double optimiseCombined(ParameterizedTree tree, Alignment alignment, SubstitutionModel model, MultivariateMinimum minimiser, int fxFracDigits, int xFracDigits, MinimiserMonitor monitor) {
        LikelihoodOptimiser lo = new LikelihoodOptimiser(tree, alignment, model);
        return lo.optimiseLogLikelihood(Parameterized.Utils.combine(tree, model), minimiser, fxFracDigits, xFracDigits, monitor);
    }

    public static final double optimiseCombined(ParameterizedTree tree, Alignment alignment, SubstitutionModel model, MultivariateMinimum minimiser, int fxFracDigits, int xFracDigits) {
        LikelihoodOptimiser lo = new LikelihoodOptimiser(tree, alignment, model);
        return lo.optimiseLogLikelihood(Parameterized.Utils.combine(tree, model), minimiser, fxFracDigits, xFracDigits);
    }

    public static final double optimiseAlternate(ParameterizedTree tree, Alignment alignment, SubstitutionModel model, MultivariateMinimum minimiser, int fxFracDigits, int xFracDigits) {
        return LikelihoodOptimiser.optimiseAlternate(tree, alignment, model, minimiser, fxFracDigits, xFracDigits, null);
    }

    public static final double optimiseAlternate(ParameterizedTree tree, Alignment alignment, SubstitutionModel model, MultivariateMinimum minimiser, int fxFracDigits, int xFracDigits, MinimiserMonitor monitor) {
        LikelihoodOptimiser lo = new LikelihoodOptimiser(tree, alignment, model);
        double epsilon = LikelihoodOptimiser.generateEpsilon(fxFracDigits);
        double lastResult = 0.0;
        double result = 0.0;
        int round = 0;
        while (true) {
            result = LikelihoodOptimiser.optimise(lo, model, minimiser, fxFracDigits, xFracDigits, monitor);
            result = LikelihoodOptimiser.optimise(lo, tree, minimiser, fxFracDigits, xFracDigits, monitor);
            if (round > 0 && (lastResult > result || result - lastResult < epsilon)) break;
            ++round;
            lastResult = result;
        }
        return lastResult;
    }

    private static final double optimise(LikelihoodOptimiser lo, Parameterized parameters, MultivariateMinimum minimiser, int fxFracDigits, int xFracDigits, MinimiserMonitor monitor) {
        if (monitor == null) {
            return lo.optimiseLogLikelihood(parameters, minimiser, fxFracDigits, xFracDigits);
        }
        return lo.optimiseLogLikelihood(parameters, minimiser, fxFracDigits, xFracDigits, monitor);
    }

    public static final double optimiseTree(ParameterizedTree tree, Alignment alignment, SubstitutionModel model, MultivariateMinimum minimiser, int fxFracDigits, int xFracDigits) {
        LikelihoodOptimiser lo = new LikelihoodOptimiser(tree, alignment, model);
        return lo.optimiseLogLikelihood(tree, minimiser, fxFracDigits, xFracDigits);
    }

    public static final double optimiseTree(ParameterizedTree tree, Alignment alignment, SubstitutionModel model, MultivariateMinimum minimiser, int fxFracDigits, int xFracDigits, MinimiserMonitor monitor) {
        LikelihoodOptimiser lo = new LikelihoodOptimiser(tree, alignment, model);
        return lo.optimiseLogLikelihood(tree, minimiser, fxFracDigits, xFracDigits, monitor);
    }

    public static final double optimiseModel(Tree tree, Alignment alignment, SubstitutionModel model, MultivariateMinimum minimiser, int fxFracDigits, int xFracDigits, MinimiserMonitor monitor) {
        LikelihoodOptimiser lo = new LikelihoodOptimiser(tree, alignment, model);
        return lo.optimiseLogLikelihood(model, minimiser, fxFracDigits, xFracDigits, monitor);
    }

    private static final double generateEpsilon(int fracDigits) {
        double x = 1.0;
        int i = 0;
        while (i < fracDigits) {
            x /= 10.0;
            ++i;
        }
        return x;
    }

    private static final class Function
    implements MultivariateFunction {
        private final GeneralLikelihoodCalculator likelihoodFunction_;
        private Parameterized parameters_;
        private OrthogonalHints hints_;
        private int numberOfParameters_;
        private double[] lowerLimits_ = null;
        private double[] upperLimits_ = null;

        public Function(Tree tree, Alignment alignment, SubstitutionModel model) {
            this.likelihoodFunction_ = new GeneralLikelihoodCalculator(alignment, tree, model);
        }

        public final void setParameters(Parameterized p) {
            this.setParameters(p, null);
        }

        public final void setParameters(Parameterized p, OrthogonalHints hints) {
            this.parameters_ = p;
            this.hints_ = hints;
            this.numberOfParameters_ = p.getNumParameters();
            this.lowerLimits_ = this.check(this.lowerLimits_, this.numberOfParameters_);
            this.upperLimits_ = this.check(this.upperLimits_, this.numberOfParameters_);
            int i = 0;
            while (i < this.numberOfParameters_) {
                this.lowerLimits_[i] = p.getLowerLimit(i);
                this.upperLimits_[i] = p.getUpperLimit(i);
                ++i;
            }
        }

        public final double[] getCurrentArgumentStore(double[] current) {
            current = this.check(current, this.numberOfParameters_);
            int i = 0;
            while (i < this.numberOfParameters_) {
                current[i] = this.parameters_.getParameter(i);
                ++i;
            }
            return current;
        }

        public final double[] getDefaultArgumentStore(double[] current) {
            current = this.check(current, this.numberOfParameters_);
            int i = 0;
            while (i < this.numberOfParameters_) {
                current[i] = this.parameters_.getDefaultValue(i);
                ++i;
            }
            return current;
        }

        private final double[] check(double[] array, int size) {
            if (array == null || array.length < size) {
                return new double[size];
            }
            return array;
        }

        public double evaluate(double[] argument) {
            int i = 0;
            while (i < this.numberOfParameters_) {
                this.parameters_.setParameter(argument[i], i);
                ++i;
            }
            return -this.likelihoodFunction_.calculateLogLikelihood();
        }

        public final int getNumArguments() {
            return this.numberOfParameters_;
        }

        public final double getLowerBound(int n) {
            return this.lowerLimits_[n];
        }

        public final double getUpperBound(int n) {
            return this.upperLimits_[n];
        }

        public final OrthogonalHints getOrthogonalHints() {
            return this.hints_;
        }
    }
}

