/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import java.io.Serializable;
import pal.datatype.DataType;
import pal.eval.ConditionalProbabilityStore;
import pal.eval.PatternInfo;
import pal.eval.SiteDetails;
import pal.substmodel.SubstitutionModel;

public interface LHCalculator {

    public static abstract class AbstractExternal {
        public final SiteDetails calculateSiteDetailsUnrooted(double distance, SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftFlatConditionalProbabilities, ConditionalProbabilityStore rightFlatConditionalProbabilities, ConditionalProbabilityStore tempStore) {
            double[][] store = new double[model.getNumberOfTransitionCategories()][centerPattern.getNumberOfPatterns()];
            this.calculateCategoryPatternProbabilities(distance, model, centerPattern, leftFlatConditionalProbabilities, rightFlatConditionalProbabilities, tempStore, store);
            double[] siteLikelihoods = this.calculateSiteLikelihoods(store, model.getTransitionCategoryProbabilities(), model.getNumberOfTransitionCategories(), centerPattern.getSitePatternMatchup(), centerPattern.getNumberOfSites());
            return SiteDetails.Utils.create(store, false, model, centerPattern.getNumberOfPatterns(), centerPattern.getSitePatternMatchup(), centerPattern.getNumberOfSites(), siteLikelihoods);
        }

        private final double[] calculateSiteLikelihoods(double[][] conditionals, double[] catProbabilities, int numberOfCategories, int[] sitePatternMatchup, int numberOfSites) {
            double[] siteLikeihoods = new double[numberOfSites];
            int site = 0;
            while (site < numberOfSites) {
                double total = 0.0;
                int pattern = sitePatternMatchup[site];
                int cat = 0;
                while (cat < numberOfCategories) {
                    total += catProbabilities[cat] * conditionals[cat][pattern];
                    ++cat;
                }
                siteLikeihoods[site] = total;
                ++site;
            }
            return siteLikeihoods;
        }

        public final SiteDetails calculateSiteDetailsRooted(SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilitiesStore, ConditionalProbabilityStore rightConditionalProbabilitiesStore) {
            double[][] store = new double[model.getNumberOfTransitionCategories()][centerPattern.getNumberOfPatterns()];
            this.calculateCategoryPatternProbabilities(model, centerPattern, leftConditionalProbabilitiesStore, rightConditionalProbabilitiesStore, store);
            double[] siteLikelihoods = this.calculateSiteLikelihoods(store, model.getTransitionCategoryProbabilities(), model.getNumberOfTransitionCategories(), centerPattern.getSitePatternMatchup(), centerPattern.getNumberOfSites());
            return SiteDetails.Utils.create(store, false, model, centerPattern.getNumberOfPatterns(), centerPattern.getSitePatternMatchup(), centerPattern.getNumberOfSites(), siteLikelihoods);
        }

        protected abstract void calculateCategoryPatternProbabilities(double var1, SubstitutionModel var3, PatternInfo var4, ConditionalProbabilityStore var5, ConditionalProbabilityStore var6, ConditionalProbabilityStore var7, double[][] var8);

        protected abstract void calculateCategoryPatternProbabilities(SubstitutionModel var1, PatternInfo var2, ConditionalProbabilityStore var3, ConditionalProbabilityStore var4, double[][] var5);
    }

    public static interface Generator
    extends Serializable {
        public Leaf createNewLeaf(int[] var1, int var2);

        public Leaf createNewLeaf(int[] var1, int var2, Generator var3);

        public External createNewExternal();

        public Internal createNewInternal();

        public boolean isAllowCaching();

        public External createNewExternal(Generator var1) throws IllegalArgumentException;

        public Internal createNewInternal(Generator var1) throws IllegalArgumentException;

        public ConditionalProbabilityStore createAppropriateConditionalProbabilityStore(boolean var1);
    }

    public static interface Factory
    extends Serializable {
        public Generator createSeries(int var1, DataType var2);
    }

    public static interface Leaf {
        public ConditionalProbabilityStore getFlatConditionalProbabilities();

        public ConditionalProbabilityStore getExtendedConditionalProbabilities(double var1, SubstitutionModel var3, boolean var4);

        public Leaf getCopy();
    }

    public static interface Internal {
        public ConditionalProbabilityStore calculateFlat(PatternInfo var1, ConditionalProbabilityStore var2, ConditionalProbabilityStore var3);

        public ConditionalProbabilityStore calculateExtended(double var1, SubstitutionModel var3, PatternInfo var4, ConditionalProbabilityStore var5, ConditionalProbabilityStore var6, boolean var7);

        public ConditionalProbabilityStore calculatePostExtendedFlat(double var1, SubstitutionModel var3, PatternInfo var4, ConditionalProbabilityStore var5, ConditionalProbabilityStore var6, boolean var7);
    }

    public static interface External
    extends Serializable {
        public void calculateFlat(PatternInfo var1, ConditionalProbabilityStore var2, ConditionalProbabilityStore var3, ConditionalProbabilityStore var4);

        public void calculateExtended(double var1, SubstitutionModel var3, PatternInfo var4, ConditionalProbabilityStore var5, ConditionalProbabilityStore var6, ConditionalProbabilityStore var7);

        public void calculateSingleExtendedDirect(double var1, SubstitutionModel var3, int var4, ConditionalProbabilityStore var5);

        public void calculateSingleExtendedIndirect(double var1, SubstitutionModel var3, int var4, ConditionalProbabilityStore var5, ConditionalProbabilityStore var6);

        public double calculateLogLikelihood(double var1, SubstitutionModel var3, PatternInfo var4, ConditionalProbabilityStore var5, ConditionalProbabilityStore var6, ConditionalProbabilityStore var7);

        public double calculateLogLikelihood(SubstitutionModel var1, PatternInfo var2, ConditionalProbabilityStore var3, ConditionalProbabilityStore var4);

        public double calculateLogLikelihoodSingle(SubstitutionModel var1, int[] var2, int var3, ConditionalProbabilityStore var4);

        public SiteDetails calculateSiteDetailsRooted(SubstitutionModel var1, PatternInfo var2, ConditionalProbabilityStore var3, ConditionalProbabilityStore var4);

        public SiteDetails calculateSiteDetailsUnrooted(double var1, SubstitutionModel var3, PatternInfo var4, ConditionalProbabilityStore var5, ConditionalProbabilityStore var6, ConditionalProbabilityStore var7);
    }
}

