/*
 * Decompiled with CFR 0.152.
 */
package pal.distance;

import java.io.Serializable;
import pal.alignment.SitePattern;
import pal.datatype.AmbiguousDataType;
import pal.datatype.DataType;
import pal.math.UnivariateFunction;
import pal.substmodel.SubstitutionModel;

public class SequencePairLikelihood
implements UnivariateFunction,
Serializable {
    private SubstitutionModel model;
    private SitePattern sitePattern;
    private DataType patternDataType_;
    private int numPatterns;
    private int numSites;
    private int numStates;
    private int numberOfTransitionCategories_;
    private int[] weight;
    private double[] logEquilibriumFrequencies_;
    private double[][][] transitionProbabilityStores_;
    private double[] transitionCategoryProbabilities_;
    private int[][] fastMatchCount_;
    private byte[] seqPat1;
    private byte[] seqPat2;
    boolean isAmbiguous_;

    public SequencePairLikelihood(SitePattern sp, SubstitutionModel m) {
        this.updateSitePattern(sp);
        this.updateModel(m);
    }

    public void updateModel(SubstitutionModel m) {
        this.model = m;
        double[] equlibriumFrequencies = m.getEquilibriumFrequencies();
        this.numberOfTransitionCategories_ = this.model.getNumberOfTransitionCategories();
        this.transitionCategoryProbabilities_ = this.model.getTransitionCategoryProbabilities();
        int dimension = this.model.getDataType().getNumStates();
        this.transitionProbabilityStores_ = new double[this.numberOfTransitionCategories_][dimension][dimension];
        this.fastMatchCount_ = new int[dimension][dimension];
        this.logEquilibriumFrequencies_ = new double[equlibriumFrequencies.length];
        int i = 0;
        while (i < equlibriumFrequencies.length) {
            this.logEquilibriumFrequencies_[i] = Math.log(equlibriumFrequencies[i]);
            ++i;
        }
    }

    public void updateSitePattern(SitePattern sp) {
        this.sitePattern = sp;
        this.numPatterns = sp.numPatterns;
        this.numSites = sp.getSiteCount();
        this.patternDataType_ = sp.getDataType();
        this.isAmbiguous_ = this.patternDataType_.isAmbiguous();
        this.numStates = this.patternDataType_.getNumStates();
        this.weight = sp.weight;
    }

    public void setSequences(int s1, int s2) {
        this.setSequences(this.sitePattern.pattern[s1], this.sitePattern.pattern[s2]);
    }

    public void setSequences(byte[] s1, byte[] s2) {
        this.seqPat1 = s1;
        this.seqPat2 = s2;
    }

    private final void clearFastMatchCount(int numStates) {
        int i = 0;
        while (i < numStates) {
            int j = 0;
            while (j < numStates) {
                this.fastMatchCount_[i][j] = 0;
                ++j;
            }
            ++i;
        }
    }

    private final double evaluateAmbiguous(double arc) {
        int sequenceTwoState;
        int sequenceOneState;
        AmbiguousDataType adt = this.patternDataType_.getAmbiguousVersion();
        DataType specificDataType = adt.getSpecificDataType();
        int numberOfSpecficStates = specificDataType.getNumStates();
        this.model.getTransitionProbabilities(arc, this.transitionProbabilityStores_);
        double loglkl = 0.0;
        this.clearFastMatchCount(numberOfSpecficStates);
        int pattern = 0;
        while (pattern < this.numPatterns) {
            sequenceOneState = this.seqPat1[pattern];
            sequenceTwoState = this.seqPat2[pattern];
            boolean sequenceOneIsGap = this.patternDataType_.isUnknownState(sequenceOneState);
            boolean sequenceTwoIsGap = this.patternDataType_.isUnknownState(sequenceTwoState);
            if (!sequenceOneIsGap && !sequenceTwoIsGap) {
                int[] firstStates = adt.getSpecificStates(sequenceOneState);
                int[] secondStates = adt.getSpecificStates(sequenceTwoState);
                int f = 0;
                while (f < firstStates.length) {
                    int s = 0;
                    while (s < secondStates.length) {
                        int[] nArray = this.fastMatchCount_[firstStates[f]];
                        int n = secondStates[s];
                        nArray[n] = nArray[n] + this.weight[pattern];
                        ++s;
                    }
                    ++f;
                }
            }
            ++pattern;
        }
        sequenceOneState = 0;
        while (sequenceOneState < numberOfSpecficStates) {
            sequenceTwoState = 0;
            while (sequenceTwoState < numberOfSpecficStates) {
                int count = this.fastMatchCount_[sequenceOneState][sequenceTwoState];
                if (count > 0) {
                    double total = 0.0;
                    int category = 0;
                    while (category < this.numberOfTransitionCategories_) {
                        total += this.transitionProbabilityStores_[category][sequenceOneState][sequenceTwoState] * this.transitionCategoryProbabilities_[category];
                        ++category;
                    }
                    loglkl += (double)count * (this.logEquilibriumFrequencies_[sequenceOneState] + Math.log(total));
                }
                ++sequenceTwoState;
            }
            ++sequenceOneState;
        }
        return -loglkl;
    }

    public final double evaluate(double arc) {
        int sequenceTwoState;
        int sequenceOneState;
        if (this.isAmbiguous_) {
            return this.evaluateAmbiguous(arc);
        }
        this.model.getTransitionProbabilities(arc, this.transitionProbabilityStores_);
        double loglkl = 0.0;
        this.clearFastMatchCount(this.numStates);
        int pattern = 0;
        while (pattern < this.numPatterns) {
            sequenceOneState = this.seqPat1[pattern];
            sequenceTwoState = this.seqPat2[pattern];
            boolean sequenceOneIsGap = this.patternDataType_.isUnknownState(sequenceOneState);
            boolean sequenceTwoIsGap = this.patternDataType_.isUnknownState(sequenceTwoState);
            if (!sequenceOneIsGap && !sequenceTwoIsGap) {
                int[] nArray = this.fastMatchCount_[sequenceOneState];
                int n = sequenceTwoState;
                nArray[n] = nArray[n] + this.weight[pattern];
            }
            ++pattern;
        }
        sequenceOneState = 0;
        while (sequenceOneState < this.numStates) {
            sequenceTwoState = 0;
            while (sequenceTwoState < this.numStates) {
                int count = this.fastMatchCount_[sequenceOneState][sequenceTwoState];
                if (count > 0) {
                    double total = 0.0;
                    int category = 0;
                    while (category < this.numberOfTransitionCategories_) {
                        total += this.transitionProbabilityStores_[category][sequenceOneState][sequenceTwoState] * this.transitionCategoryProbabilities_[category];
                        ++category;
                    }
                    loglkl += (double)count * (this.logEquilibriumFrequencies_[sequenceOneState] + Math.log(total));
                }
                ++sequenceTwoState;
            }
            ++sequenceOneState;
        }
        return -loglkl;
    }

    public double getLowerBound() {
        return 1.0E-9;
    }

    public double getUpperBound() {
        return 1.0;
    }
}

