/*
 * Decompiled with CFR 0.152.
 */
package pal.distance;

import pal.alignment.Alignment;
import pal.alignment.SitePattern;
import pal.distance.AlignmentDistanceMatrix;
import pal.distance.DistanceMatrix;
import pal.misc.IdGroup;

public class JukesCantorDistanceMatrix
extends DistanceMatrix {
    public JukesCantorDistanceMatrix(DistanceMatrix dist) {
        this(dist, 4);
    }

    public JukesCantorDistanceMatrix(DistanceMatrix dist, int numStates) {
        super(JukesCantorDistanceMatrix.computeDistances(dist, numStates), (IdGroup)dist);
    }

    public JukesCantorDistanceMatrix(Alignment alignment) {
        this(new SitePattern(alignment));
    }

    public JukesCantorDistanceMatrix(SitePattern sitePattern) {
        this((DistanceMatrix)new AlignmentDistanceMatrix(sitePattern), sitePattern.getDataType().getNumStates());
    }

    private static final double[][] computeDistances(DistanceMatrix dist, int numberOfStates) {
        int numSeqs = dist.getSize();
        double[][] distance = new double[numSeqs][numSeqs];
        double[][] obsDistance = dist.getDistances();
        double const1 = (double)(numSeqs - 1) / (double)numSeqs;
        double const2 = (double)numSeqs / (double)(numSeqs - 1);
        int i = 0;
        while (i < numSeqs - 1) {
            distance[i][i] = 0.0;
            int j = i + 1;
            while (j < numSeqs) {
                double d = JukesCantorDistanceMatrix.jccorrection(const1, const2, obsDistance[i][j]);
                distance[j][i] = d;
                distance[i][j] = d;
                ++j;
            }
            ++i;
        }
        return distance;
    }

    private static final double jccorrection(double const1, double const2, double obsdist) {
        if (obsdist == 0.0) {
            return 0.0;
        }
        if (obsdist >= const1) {
            return 1.0;
        }
        double expDist = -const1 * Math.log(1.0 - const2 * obsdist);
        if (expDist < 1.0) {
            return expDist;
        }
        return 1.0;
    }
}

