/*
 * Decompiled with CFR 0.152.
 */
package pal.distance;

import java.io.Serializable;
import pal.alignment.SitePattern;
import pal.distance.DistanceMatrix;
import pal.distance.PairwiseDistance;
import pal.misc.IdGroup;
import pal.substmodel.SubstitutionModel;
import pal.util.AlgorithmCallback;

public class AlignmentDistanceMatrix
extends DistanceMatrix
implements Serializable {
    public AlignmentDistanceMatrix(SitePattern sp) {
        this(sp, null, null);
    }

    public AlignmentDistanceMatrix(SitePattern sp, AlgorithmCallback callback) {
        this(sp, null, callback);
    }

    public AlignmentDistanceMatrix(SitePattern sp, SubstitutionModel m) {
        this(sp, m, null);
    }

    public AlignmentDistanceMatrix(SitePattern sp, SubstitutionModel m, AlgorithmCallback callback) {
        super(AlignmentDistanceMatrix.computeDistances(sp, m, callback), (IdGroup)sp);
    }

    public void recompute(SitePattern sp, AlgorithmCallback callback) {
        this.recompute(sp, null, callback);
    }

    public void recompute(SitePattern sp, SubstitutionModel model) {
        this.recompute(sp, model, null);
    }

    public void recompute(SitePattern sp, SubstitutionModel model, AlgorithmCallback callback) {
        this.setIdGroup(sp);
        this.setDistances(AlignmentDistanceMatrix.computeDistances(sp, model, callback));
    }

    private static final double[][] computeDistances(SitePattern sp, SubstitutionModel m, AlgorithmCallback callback) {
        int numSeqs = sp.getSequenceCount();
        double[][] distance = new double[numSeqs][numSeqs];
        PairwiseDistance pwd = m != null ? new PairwiseDistance(sp, m) : new PairwiseDistance(sp);
        int i = 0;
        while (i < numSeqs) {
            distance[i][i] = 0.0;
            int j = i + 1;
            while (j < numSeqs) {
                if (callback != null) {
                    if (callback.isPleaseStop()) {
                        return null;
                    }
                    callback.updateProgress((double)(2 * (i * numSeqs + j)) / (double)(2 * numSeqs * numSeqs));
                }
                distance[i][j] = pwd.getDistance(i, j);
                distance[j][i] = distance[i][j];
                ++j;
            }
            ++i;
        }
        if (callback != null) {
            callback.clearProgress();
        }
        return distance;
    }
}

