/*
 * Decompiled with CFR 0.152.
 */
package pal.datatype;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import pal.datatype.AmbiguousDataType;
import pal.datatype.DataType;

public abstract class SimpleDataType
implements DataType {
    private static final long serialVersionUID = 7902613264354545217L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
    }

    public final int getState(char c) {
        if (DataType.Utils.isSuggestedGap(c)) {
            return -2;
        }
        return this.getStateImpl(c);
    }

    public final char getChar(int state) {
        if (state == -2) {
            return '-';
        }
        if (state < 0) {
            return '?';
        }
        return this.getCharImpl(state);
    }

    protected abstract int getStateImpl(char var1);

    protected abstract char getCharImpl(int var1);

    public final char getPreferredChar(char c) {
        if (this.isGapChar(c)) {
            return '-';
        }
        return this.getPreferredCharImpl(c);
    }

    protected char getPreferredCharImpl(char c) {
        return this.getChar(this.getState(c));
    }

    public final boolean isUnknownChar(char c) {
        return this.isUnknownState(this.getState(c));
    }

    public final boolean isUnknownState(int state) {
        return state == -2 || this.isUnknownStateImpl(state);
    }

    protected abstract boolean isUnknownStateImpl(int var1);

    public String toString() {
        return this.getDescription();
    }

    public int getRecommendedUnknownState() {
        return -1;
    }

    public boolean isAmbiguous() {
        return false;
    }

    public AmbiguousDataType getAmbiguousVersion() {
        return null;
    }

    public final boolean hasGap() {
        return true;
    }

    public final boolean isGapChar(char c) {
        return DataType.Utils.isSuggestedGap(c);
    }

    public final boolean isGapState(int state) {
        return state == -2;
    }

    public final int getRecommendedGapState() {
        return -2;
    }
}

