/*
 * Decompiled with CFR 0.152.
 */
package pal.coalescent;

import java.io.PrintWriter;
import java.io.Serializable;
import pal.coalescent.CoalescentIntervals;
import pal.coalescent.IntervalsExtractor;
import pal.io.FormattedOutput;
import pal.io.OutputTarget;
import pal.misc.Report;
import pal.misc.Units;
import pal.statistics.PenalizedLikelihood;
import pal.tree.Tree;

public class SkylinePlot
implements Report,
Units,
Serializable {
    private CoalescentIntervals ci;
    private FormattedOutput fo;
    private int size;
    private double maxTime;
    private double eps;
    private int params;
    private double[] cis;
    private double[] populationSize;

    public SkylinePlot(Tree tree, double epsilon) {
        this(IntervalsExtractor.extractFromClockTree(tree), epsilon);
    }

    public SkylinePlot(CoalescentIntervals ci, double epsilon) {
        if (!ci.isBinaryCoalescent()) {
            throw new IllegalArgumentException("All coalescent intervals must contain only a single coalescent");
        }
        this.fo = FormattedOutput.getInstance();
        this.size = ci.getIntervalCount();
        this.ci = ci;
        this.populationSize = new double[this.size];
        this.cis = new double[this.size];
        this.maxTime = 0.0;
        int i = 0;
        while (i < this.size) {
            this.cis[i] = this.maxTime;
            this.maxTime += ci.getInterval(i);
            ++i;
        }
        if (epsilon == 0.0) {
            this.computeClassic();
        } else if (epsilon > 0.0) {
            this.computeGeneralized(epsilon);
        } else {
            this.optimize();
        }
    }

    public String toString() {
        OutputTarget out = OutputTarget.openString();
        this.report(out);
        out.close();
        return out.getString();
    }

    public void report(PrintWriter out) {
        out.println("Skyline Plot");
        out.println();
        out.print("Smoothing parameter epsilon = " + this.eps + " ");
        if (this.eps == 0.0) {
            out.println("(classic skyline plot)");
        } else {
            out.println("(generalized skyline plot)");
        }
        out.print("Unit of time: ");
        if (this.ci.getUnits() == 1) {
            out.print("generations");
        } else {
            out.print("expected substitutions");
        }
        out.println();
        this.printIntervals(out);
        out.println();
        out.println("For each composite interval the first and the last simple interval is given.");
        out.println();
        out.println("log L = " + this.getLogLikelihood());
        out.println("Number of intervals: " + this.size);
        out.println("Number of composite intervals:" + this.params);
        if (this.params > this.size - 2) {
            out.println("log L(AICC) not available");
        } else {
            out.println("log L(AICC) = " + this.getAICC());
        }
    }

    private void printIntervals(PrintWriter out) {
        out.println("Int.\tTime\tEstimated N(t)");
        double total = 0.0;
        int i = 0;
        while (i < this.size) {
            double m = this.populationSize[i];
            this.printLine(out, i, total, m);
            total += this.ci.getInterval(i);
            int j = i + 1;
            while (j < this.size) {
                if (this.populationSize[j] != m) break;
                ++j;
            }
            i = j - 1;
            this.printLine(out, i, total, m);
            ++i;
        }
    }

    private void printLine(PrintWriter out, int i, double total, double m) {
        out.print(this.size - i + "\t");
        this.fo.displayDecimal(out, total, 4);
        out.print("\t");
        this.fo.displayDecimal(out, m, 4);
        out.println();
    }

    public void computeClassic() {
        int i = 0;
        while (i < this.size) {
            double w = this.ci.getInterval(i);
            double n = this.ci.getNumLineages(i);
            this.populationSize[i] = w * (n * (n - 1.0)) / 2.0;
            ++i;
        }
        this.params = this.size;
        this.eps = 0.0;
    }

    public void computeGeneralized(double epsilon) {
        this.params = 0;
        double cw = 0.0;
        int i = 0;
        while (i < this.size) {
            double n = this.ci.getNumLineages(i);
            double w = this.ci.getInterval(i);
            int start = i;
            int k = 1;
            while (w < epsilon && i < this.size - 1) {
                ++k;
                w += this.ci.getInterval(++i);
            }
            if (this.maxTime - cw - w < epsilon) {
                int j = i + 1;
                while (j < this.size) {
                    ++k;
                    w += this.ci.getInterval(++i);
                    ++j;
                }
            }
            double m = w * (n * (n - (double)k)) / (2.0 * (double)k);
            int j = start;
            while (j < start + k) {
                this.populationSize[j] = m;
                ++j;
            }
            ++this.params;
            cw += w;
            ++i;
        }
        this.eps = epsilon;
    }

    public void optimize() {
        double besteps = this.getMaxTime();
        this.computeGeneralized(besteps);
        double bestaicc = this.getAICC();
        int GRID = 1000;
        double delta = besteps / (double)GRID;
        double MINEPS = 1.0E-6;
        this.eps -= delta;
        while (this.eps > MINEPS) {
            this.computeGeneralized(this.eps);
            double aicc = this.getAICC();
            if (aicc > bestaicc && this.params < this.size - 1) {
                besteps = this.eps;
                bestaicc = aicc;
            }
            this.eps -= delta;
        }
        this.computeGeneralized(besteps);
    }

    public double getLogLikelihood() {
        double logL = 0.0;
        int i = 0;
        while (i < this.size) {
            double w = this.ci.getInterval(i);
            double m = this.populationSize[i];
            double n = this.ci.getNumLineages(i);
            double nc2 = n * (n - 1.0) / 2.0;
            logL += Math.log(nc2 / m) - w * nc2 / m;
            ++i;
        }
        return logL;
    }

    public double getAICC() {
        double logL = this.getLogLikelihood();
        return PenalizedLikelihood.AICC(logL, this.params, this.size);
    }

    public double findInterval(double time) {
        if (time < 0.0) {
            throw new IllegalArgumentException("Negative values for time are not allowed");
        }
        int i = 0;
        while (i < this.size - 1) {
            if (time >= this.cis[i] && time < this.cis[i + 1]) {
                return i;
            }
            ++i;
        }
        return this.size - 1;
    }

    public double getMaxTime() {
        return this.maxTime;
    }

    public double getMaxPopulationSize() {
        double max = 0.0;
        int i = 0;
        while (i < this.size) {
            if (this.populationSize[i] > max) {
                max = this.populationSize[i];
            }
            ++i;
        }
        return max;
    }

    public CoalescentIntervals getIntervals() {
        return this.ci;
    }

    public int getSize() {
        return this.size;
    }

    public int getParameterCount() {
        return this.params;
    }

    public double getEpsilon() {
        return this.eps;
    }

    public double getPopulationSize(int i) {
        return this.populationSize[i];
    }

    public int getUnits() {
        return this.ci.getUnits();
    }
}

