/*
 * Decompiled with CFR 0.152.
 */
package pal.coalescent;

import java.io.Serializable;
import pal.alignment.Alignment;
import pal.coalescent.DemographicModel;
import pal.coalescent.SerialCoalescentSimulator;
import pal.misc.TimeOrderCharacterData;
import pal.tree.SimulatedAlignment;
import pal.tree.Tree;
import pal.tree.TreeOperation;
import pal.util.AlgorithmCallback;

public class SerialCoalescentGenerator
implements Serializable {
    private TimeOrderCharacterData tocd_;
    private DemographicModel demographicModel_;
    private int numberOfTreesToGenerate_;
    private SimulatedAlignment.Factory alignmentFactory_;
    private final TreeOperation treeFinisher_;

    public SerialCoalescentGenerator(TimeOrderCharacterData tocd, DemographicModel demographicModel, int numberOfTreesToGenerate) {
        this(tocd, demographicModel, numberOfTreesToGenerate, TreeOperation.Utils.getNoOperation(), null);
    }

    public SerialCoalescentGenerator(TimeOrderCharacterData tocd, DemographicModel demographicModel, int numberOfTreesToGenerate, TreeOperation treeFinisher) {
        this(tocd, demographicModel, numberOfTreesToGenerate, treeFinisher, null);
    }

    public SerialCoalescentGenerator(TimeOrderCharacterData tocd, DemographicModel demographicModel, TreeOperation treeFinisher, SimulatedAlignment.Factory alignmentFactory) {
        this(tocd, demographicModel, 1, treeFinisher, alignmentFactory);
    }

    public SerialCoalescentGenerator(TimeOrderCharacterData tocd, DemographicModel demographicModel, int numberOfTreesToGenerate, TreeOperation treeFinisher, SimulatedAlignment.Factory alignmentFactory) {
        this.tocd_ = tocd;
        this.treeFinisher_ = treeFinisher;
        this.demographicModel_ = demographicModel;
        this.numberOfTreesToGenerate_ = numberOfTreesToGenerate;
        this.alignmentFactory_ = alignmentFactory;
    }

    private final Tree generateNewTree() {
        SerialCoalescentSimulator scs = new SerialCoalescentSimulator();
        scs.simulateIntervals(this.tocd_, this.demographicModel_, true);
        return this.treeFinisher_.operateOn(scs.getTree());
    }

    public final Tree generateTree() {
        return this.generateNewTree();
    }

    public final Tree[] generateTrees(AlgorithmCallback callback) {
        Tree[] trees = new Tree[this.numberOfTreesToGenerate_];
        callback.updateStatus("Simulating trees");
        int i = 0;
        while (i < this.numberOfTreesToGenerate_) {
            if (callback.isPleaseStop()) {
                Tree[] toReturn = new Tree[i];
                System.arraycopy(trees, 0, toReturn, 0, i);
                return toReturn;
            }
            trees[i] = this.generateNewTree();
            callback.updateProgress((double)i / (double)this.numberOfTreesToGenerate_);
            ++i;
        }
        callback.clearProgress();
        return trees;
    }

    private final Results generateTreeAndAlignmentResults(AlgorithmCallback callback) {
        Tree[] trees = new Tree[this.numberOfTreesToGenerate_];
        Alignment[] alignments = new Alignment[this.numberOfTreesToGenerate_];
        callback.clearProgress();
        double total = trees.length * 2;
        int i = 0;
        while (i < trees.length) {
            if (callback.isPleaseStop()) {
                Tree[] ts = new Tree[i];
                Alignment[] as = new Alignment[i];
                System.arraycopy(trees, 0, ts, 0, i);
                System.arraycopy(alignments, 0, as, 0, i);
                return new Results(ts, as);
            }
            trees[i] = this.generateNewTree();
            callback.updateProgress((double)(2 * i) / total);
            alignments[i] = this.alignmentFactory_.generateAlignment(trees[i]);
            callback.updateProgress((double)(2 * i + 1) / total);
            ++i;
        }
        callback.clearProgress();
        return new Results(trees, alignments);
    }

    private final Results generateTreeOnlyResults(AlgorithmCallback callback) {
        Tree[] trees = new Tree[this.numberOfTreesToGenerate_];
        callback.clearProgress();
        double total = trees.length;
        int i = 0;
        while (i < trees.length) {
            if (callback.isPleaseStop()) {
                Tree[] ts = new Tree[i];
                System.arraycopy(trees, 0, ts, 0, i);
                return new Results(ts);
            }
            trees[i] = this.generateNewTree();
            callback.updateProgress((double)i / total);
            ++i;
        }
        callback.clearProgress();
        return new Results(trees);
    }

    public final Results generateResults(AlgorithmCallback callback) {
        if (this.alignmentFactory_ != null) {
            return this.generateTreeAndAlignmentResults(callback);
        }
        return this.generateTreeOnlyResults(callback);
    }

    public static final class Results {
        private Tree[] trees_;
        private Alignment[] alignments_;

        public Results(Tree[] trees) {
            this(trees, null);
        }

        public Results(Tree[] trees, Alignment[] alignments) {
            this.trees_ = trees;
            this.alignments_ = alignments;
        }

        public final Tree[] getTrees() {
            return this.trees_;
        }

        public final Alignment[] getAlignments() {
            return this.alignments_;
        }

        public final boolean hasAlignments() {
            return this.alignments_ != null;
        }

        public final int getNumberOfPopulations() {
            return this.trees_.length;
        }
    }
}

