/*
 * Decompiled with CFR 0.152.
 */
package pal.coalescent;

import java.io.Serializable;
import pal.io.FormattedOutput;
import pal.math.Binomial;
import pal.math.MersenneTwisterFast;
import pal.misc.Parameterized;
import pal.misc.Report;
import pal.misc.Summarizable;
import pal.misc.Units;

public abstract class DemographicModel
implements Units,
Parameterized,
Report,
Cloneable,
Serializable,
Summarizable {
    private int units = 1;
    private double logL = 0.0;
    private MersenneTwisterFast rng = new MersenneTwisterFast();
    private Binomial binom = new Binomial();
    protected FormattedOutput fo = FormattedOutput.getInstance();

    public abstract Object clone();

    public abstract double getDemographic(double var1);

    public abstract double getIntensity(double var1);

    public abstract double getInverseIntensity(double var1);

    public double getSimulatedInterval(int numLin, double timeOfLastCoal) {
        double U = this.rng.nextDouble();
        this.binom.setMax(numLin);
        double tmp = -Math.log(U) / this.binom.getNChoose2(numLin) + this.getIntensity(timeOfLastCoal);
        double interval = this.getInverseIntensity(tmp) - timeOfLastCoal;
        return interval;
    }

    public double getIntegral(double start, double finish) {
        return this.getIntensity(finish) - this.getIntensity(start);
    }

    public double computeLogLikelihood(double width, double timeOfPrevCoal, int numLineages) {
        return this.computeLogLikelihood(width, timeOfPrevCoal, numLineages, 0);
    }

    public double computeLogLikelihood(double width, double timeOfPrevCoal, int numLineages, int type) {
        this.binom.setMax(numLineages);
        double timeOfThisCoal = width + timeOfPrevCoal;
        double intervalArea = this.getIntegral(timeOfPrevCoal, timeOfThisCoal);
        double like = 0.0;
        switch (type) {
            case 0: {
                like = -Math.log(this.getDemographic(timeOfThisCoal)) - this.binom.getNChoose2(numLineages) * intervalArea;
                break;
            }
            case 1: {
                like = -(this.binom.getNChoose2(numLineages) * intervalArea);
            }
        }
        return like;
    }

    public void setUnits(int u) {
        this.units = u;
    }

    public int getUnits() {
        return this.units;
    }

    public void setLogL(double l) {
        this.logL = l;
    }

    public double getLogL() {
        return this.logL;
    }

    public void testConsistency(int steps, double maxTime) {
        double delta = maxTime / (double)steps;
        System.out.println("time\tN(time)\tIntensity(time)\tinverse");
        int i = 0;
        while (i <= steps) {
            double time = (double)i * delta;
            double intensity = this.getIntensity(time);
            double newTime = this.getInverseIntensity(intensity);
            System.out.println(time + "\t" + this.getDemographic(time) + "\t" + intensity + "\t" + newTime);
            if (Math.abs(time - newTime) > 1.0E-12) {
                throw new RuntimeException("Demographic model not consistent! error size = " + Math.abs(time - newTime));
            }
            ++i;
        }
        System.out.println("Demographic model is consistent!");
    }
}

