/*
 * Decompiled with CFR 0.152.
 */
package pal.coalescent;

import java.io.PrintWriter;
import java.io.Serializable;
import pal.coalescent.ExponentialGrowth;
import pal.io.OutputTarget;
import pal.misc.Parameterized;
import pal.misc.Report;

public class ConstExpGrowth
extends ExponentialGrowth
implements Report,
Parameterized,
Serializable {
    public static final int ALPHA_PARAMETERIZATION = 0;
    public static final int N1_PARAMETERIZATION = 1;
    public static final int LX_PARAMETERIZATION = 2;
    public int parameterization;
    public double alpha;
    public double alphaSE;
    public double N1;
    public double N1SE;
    double lx;

    public ConstExpGrowth(int units, int parameterization) {
        super(units);
        this.parameterization = parameterization;
        if (this.isN1Parameterized()) {
            this.N1 = this.getDefaultValue(2);
        } else {
            this.alpha = this.getDefaultValue(2);
        }
        if (this.isLxParameterized()) {
            this.lx = this.getDefaultValue(1);
            this.calculateRFromLx();
        } else {
            this.lx = this.getGrowthPhaseDuration();
        }
    }

    public ConstExpGrowth(double size, double growthParam, double ancestral, int units, int parameterization) {
        super(size, growthParam, units);
        this.parameterization = parameterization;
        if (this.isN1Parameterized()) {
            this.N1 = ancestral;
        } else {
            this.alpha = ancestral;
        }
        if (this.isLxParameterized()) {
            this.lx = growthParam;
            this.calculateRFromLx();
        } else {
            this.lx = this.getGrowthPhaseDuration();
        }
    }

    public Object clone() {
        return new ConstExpGrowth(this.getN0(), this.getGrowthParam(), this.getAncestral(), this.getUnits(), this.getParameterization());
    }

    public double getTransitionTime() {
        if (this.isLxParameterized()) {
            return this.lx;
        }
        return -(Math.log(this.getAncestralN0()) - Math.log(this.N0)) / this.r;
    }

    public double getAncestral() {
        if (this.isN1Parameterized()) {
            return this.N1;
        }
        return this.alpha;
    }

    public double getGrowthParam() {
        if (this.isLxParameterized()) {
            return this.lx;
        }
        return this.r;
    }

    public double getGrowthRate() {
        if (this.isLxParameterized()) {
            this.calculateRFromLx();
        }
        return super.getGrowthRate();
    }

    public void setAncestral(double ancestral) {
        if (this.isN1Parameterized()) {
            this.N1 = ancestral;
        } else {
            this.alpha = ancestral;
        }
    }

    public void setGrowthParam(double g) {
        if (this.isLxParameterized()) {
            this.lx = g;
        } else {
            this.r = g;
        }
    }

    public double getAncestralN0() {
        if (this.isN1Parameterized()) {
            return this.N1;
        }
        return this.N0 * this.alpha;
    }

    public double getGrowthPhaseDuration() {
        return this.getTransitionTime();
    }

    public void setGrowthPhaseDuration(double lx) {
        if (!this.isLxParameterized()) {
            throw new RuntimeException("You must use LX_PARAMETERIZATION to use this method!");
        }
        this.lx = lx;
        if (lx == 0.0) {
            throw new IllegalArgumentException("An lx value of zero is illegal!");
        }
    }

    public int getParameterization() {
        return this.parameterization;
    }

    public boolean isLxParameterized() {
        return (this.parameterization & 2) > 0;
    }

    public boolean isN1Parameterized() {
        return (this.parameterization & 1) > 0;
    }

    public void setParameterization(int p) {
        this.parameterization = p;
    }

    protected void calculateRFromLx() {
        this.r = (Math.log(this.getAncestralN0()) - Math.log(this.N0)) / -this.lx;
    }

    public double getDemographic(double t) {
        if (this.isN1Parameterized()) {
            this.alpha = this.N1 / this.N0;
        }
        if (this.isLxParameterized()) {
            this.calculateRFromLx();
        }
        if (this.alpha == 1.0 || this.r == 0.0) {
            return this.N0;
        }
        if (this.alpha == 0.0) {
            return this.N0 * Math.exp(-t * this.r);
        }
        double tc = -Math.log(this.alpha) / this.r;
        if (t < tc) {
            return this.N0 * Math.exp(-t * this.r);
        }
        return this.N0 * this.alpha;
    }

    public double getIntensity(double t) {
        if (this.isN1Parameterized()) {
            this.alpha = this.N1 / this.N0;
        }
        if (this.isLxParameterized()) {
            this.calculateRFromLx();
        }
        if (this.alpha == 1.0 || this.r == 0.0) {
            return t / this.N0;
        }
        if (this.alpha == 0.0) {
            return (Math.exp(t * this.r) - 1.0) / this.N0 / this.r;
        }
        double tc = -Math.log(this.alpha) / this.r;
        if (t < tc) {
            return (Math.exp(this.r * t) - 1.0) / (this.N0 * this.r);
        }
        return (1.0 - this.alpha + this.r * t + Math.log(this.alpha)) / (this.alpha * this.N0 * this.r);
    }

    public double getInverseIntensity(double x) {
        if (this.isN1Parameterized()) {
            this.alpha = this.N1 / this.N0;
        }
        if (this.isLxParameterized()) {
            this.calculateRFromLx();
        }
        if (this.r == 0.0) {
            return this.N0 * x;
        }
        if (this.alpha == 0.0) {
            return Math.log(1.0 + this.N0 * x * this.r) / this.r;
        }
        double xc = (1.0 - this.alpha) / (this.alpha * this.N0 * this.r);
        if (x < xc) {
            return Math.log(1.0 + this.N0 * this.r * x) / this.r;
        }
        return (this.alpha - 1.0 + this.alpha * this.N0 * this.r * x - Math.log(this.alpha)) / this.r;
    }

    public int getNumParameters() {
        return 3;
    }

    public double getParameter(int k) {
        switch (k) {
            case 0: {
                return this.N0;
            }
            case 1: {
                return this.r;
            }
            case 2: {
                if (this.isN1Parameterized()) {
                    return this.N1;
                }
                return this.alpha;
            }
        }
        return 0.0;
    }

    public double getUpperLimit(int k) {
        double max = 0.0;
        switch (k) {
            case 0: {
                max = 1.0E50;
                break;
            }
            case 1: {
                max = 1000.0;
                break;
            }
            case 2: {
                if (this.isN1Parameterized()) {
                    max = 1.0E50;
                    break;
                }
                max = 1.0;
                break;
            }
        }
        return max;
    }

    public double getLowerLimit(int k) {
        double min = 0.0;
        switch (k) {
            case 0: {
                min = 1.0E-12;
                break;
            }
            case 1: {
                min = 0.0;
                break;
            }
            case 2: {
                min = 0.0;
                break;
            }
        }
        return min;
    }

    public double getDefaultValue(int k) {
        if (k == 0) {
            if (this.getUnits() == 1) {
                return 1000.0;
            }
            return 0.2;
        }
        if (k == 1) {
            return 0.0;
        }
        if (this.isN1Parameterized()) {
            return this.getDefaultValue(0);
        }
        return 0.5;
    }

    public void setParameter(double value, int k) {
        switch (k) {
            case 0: {
                this.N0 = value;
                break;
            }
            case 1: {
                this.r = value;
                break;
            }
            case 2: {
                if (this.isN1Parameterized()) {
                    this.N1 = value;
                    break;
                }
                this.alpha = value;
                break;
            }
        }
    }

    public void setParameterSE(double value, int k) {
        switch (k) {
            case 0: {
                this.N0SE = value;
                break;
            }
            case 1: {
                this.rSE = value;
                break;
            }
            case 2: {
                if (this.isN1Parameterized()) {
                    this.N1SE = value;
                    break;
                }
                this.alphaSE = value;
                break;
            }
        }
    }

    public String toString() {
        OutputTarget out = OutputTarget.openString();
        this.report(out);
        out.close();
        return out.getString();
    }

    public void report(PrintWriter out) {
        out.println("Demographic model: const-exp growth");
        if (this.isN1Parameterized()) {
            out.println("Demographic function: N(t) = N0 exp(-r t) for t < -ln(N1/N0)/r");
            out.println("                             N1           otherwise");
        } else {
            out.println("Demographic function: N(t) = N0 exp(-r t) for t < -ln(alpha)/r");
            out.println("                             N0 alpha     otherwise");
        }
        out.print("Unit of time: ");
        if (this.getUnits() == 1) {
            out.print("generations");
        } else {
            out.print("expected substitutions");
        }
        out.println();
        out.println();
        out.println("Parameters of demographic function:");
        out.print(" present-day population size N0: ");
        this.fo.displayDecimal(out, this.N0, 6);
        if (this.N0SE != 0.0) {
            out.print(" (S.E. ");
            this.fo.displayDecimal(out, this.N0SE, 6);
            out.print(")");
        }
        out.println();
        out.print(" growth rate r: ");
        this.fo.displayDecimal(out, this.r, 6);
        if (this.rSE != 0.0) {
            out.print(" (S.E. ");
            this.fo.displayDecimal(out, this.rSE, 6);
            out.print(")");
        }
        out.println();
        if (this.isN1Parameterized()) {
            out.print(" pre-growth population size N1: ");
            this.fo.displayDecimal(out, this.N1, 6);
            if (this.N1SE != 0.0) {
                out.print(" (S.E. ");
                this.fo.displayDecimal(out, this.N1SE, 6);
                out.print(")");
            }
            out.println();
            out.print(" Ratio of poulation sizes alpha: ");
            this.fo.displayDecimal(out, this.N1 / this.N0, 6);
            out.println();
        } else {
            out.print(" ratio of population sizes alpha: ");
            this.fo.displayDecimal(out, this.alpha, 6);
            if (this.alphaSE != 0.0) {
                out.print(" (S.E. ");
                this.fo.displayDecimal(out, this.alphaSE, 6);
                out.print(")");
            }
            out.println();
            out.print(" initial population size alpha N0: ");
            this.fo.displayDecimal(out, this.alpha * this.N0, 6);
            out.println();
        }
        out.println();
        if (this.getLogL() != 0.0) {
            out.println();
            out.print("log L: ");
            this.fo.displayDecimal(out, this.getLogL(), 6);
            out.println();
        }
    }
}

