/*
 * Decompiled with CFR 0.152.
 */
package pal.coalescent;

import java.io.PrintWriter;
import java.io.Serializable;
import pal.coalescent.ConstExpGrowth;
import pal.io.OutputTarget;
import pal.misc.Parameterized;
import pal.misc.Report;

public class ConstExpConst
extends ConstExpGrowth
implements Report,
Parameterized,
Serializable {
    public double tx;
    public double txSE;

    public ConstExpConst(int units, int parameterization) {
        super(units, parameterization);
        this.parameterization = parameterization;
        this.tx = this.getDefaultValue(3);
    }

    public ConstExpConst(double size, double growth, double ancestral, double timeX, int units, int parameterization) {
        super(size, growth, ancestral, units, parameterization);
        this.tx = timeX;
    }

    public Object clone() {
        return new ConstExpConst(this.getN0(), this.getGrowthParam(), this.getAncestral(), this.getTimeX(), this.getUnits(), this.getParameterization());
    }

    public double getTransitionTime() {
        if (this.isLxParameterized()) {
            return this.lx + this.tx;
        }
        return this.tx - (Math.log(this.getAncestralN0()) - Math.log(this.N0)) / this.r;
    }

    public double getGrowthPhaseDuration() {
        if (this.isLxParameterized()) {
            return this.lx;
        }
        return this.getTransitionTime() - this.getTimeX();
    }

    public double getTimeX() {
        return this.tx;
    }

    public void setTimeX(double timeX) {
        this.tx = timeX;
    }

    public double getDemographic(double t) {
        if (this.isN1Parameterized()) {
            this.alpha = this.N1 / this.N0;
        }
        if (this.isLxParameterized()) {
            this.calculateRFromLx();
        }
        if (this.alpha == 1.0 || this.r == 0.0) {
            return this.N0;
        }
        if (this.alpha == 0.0 && this.tx == 0.0) {
            return this.N0 * Math.exp(-t * this.r);
        }
        double tc = this.tx - Math.log(this.alpha) / this.r;
        if (t < this.tx) {
            return this.N0;
        }
        if (t < tc) {
            return this.N0 * Math.exp(-(t - this.tx) * this.r);
        }
        return this.N0 * this.alpha;
    }

    public double getIntensity(double t) {
        if (this.isN1Parameterized()) {
            this.alpha = this.N1 / this.N0;
        }
        if (this.isLxParameterized()) {
            this.calculateRFromLx();
        }
        if (this.alpha == 1.0 || this.r == 0.0) {
            return t / this.N0;
        }
        if (this.alpha == 0.0 && this.tx == 0.0) {
            return (Math.exp(t * this.r) - 1.0) / this.N0 / this.r;
        }
        double tc = -Math.log(this.alpha) / this.r + this.tx;
        if (t < this.tx) {
            return t / this.N0;
        }
        if (t < tc) {
            return this.tx / this.N0 + (Math.exp(this.r * (t - this.tx)) - 1.0) / this.N0 / this.r;
        }
        return this.tx / this.N0 + (Math.exp(this.r * (tc - this.tx)) - 1.0) / this.N0 / this.r + (t - tc) / (this.alpha * this.N0);
    }

    public double getInverseIntensity(double x) {
        if (this.isN1Parameterized()) {
            this.alpha = this.N1 / this.N0;
        }
        if (this.isLxParameterized()) {
            this.calculateRFromLx();
        }
        if (this.r == 0.0) {
            return this.N0 * x;
        }
        if (this.alpha == 0.0) {
            return Math.log(1.0 + this.N0 * x * this.r) / this.r;
        }
        double xx = this.tx / this.N0;
        double xc = (1.0 - this.alpha) / (this.alpha * this.N0 * this.r) + xx;
        if (x < xx) {
            return this.N0 * x;
        }
        if (x < xc) {
            return this.tx + Math.log(1.0 + this.N0 * this.r * (x - xx)) / this.r;
        }
        return this.tx + Math.log(1.0 + this.N0 * this.r * (xc - xx)) / this.r + this.N0 * this.alpha * (x - xc);
    }

    public int getNumParameters() {
        return 4;
    }

    public double getParameter(int k) {
        switch (k) {
            case 0: {
                return this.N0;
            }
            case 1: {
                return this.r;
            }
            case 2: {
                if (this.isN1Parameterized()) {
                    return this.N1;
                }
                return this.alpha;
            }
            case 3: {
                return this.tx;
            }
        }
        return 0.0;
    }

    public double getUpperLimit(int k) {
        double max = 0.0;
        switch (k) {
            case 0: {
                max = 1.0E50;
                break;
            }
            case 1: {
                max = 1000.0;
                break;
            }
            case 2: {
                if (this.isN1Parameterized()) {
                    max = 1.0E50;
                    break;
                }
                max = 1.0;
                break;
            }
            case 3: {
                max = 1.0E50;
                break;
            }
        }
        return max;
    }

    public double getLowerLimit(int k) {
        double min = 0.0;
        switch (k) {
            case 0: {
                min = 1.0E-12;
                break;
            }
            case 1: {
                min = 0.0;
                break;
            }
            case 2: {
                min = 0.0;
                break;
            }
            case 3: {
                min = 0.0;
                break;
            }
        }
        return min;
    }

    public double getDefaultValue(int k) {
        if (k == 0) {
            if (this.getUnits() == 1) {
                return 1000.0;
            }
            return 0.2;
        }
        if (k == 1) {
            return 0.0;
        }
        if (k == 2) {
            if (this.isN1Parameterized()) {
                return this.getDefaultValue(0);
            }
            return 0.5;
        }
        return 0.0;
    }

    public void setParameter(double value, int k) {
        switch (k) {
            case 0: {
                this.N0 = value;
                break;
            }
            case 1: {
                this.r = value;
                break;
            }
            case 2: {
                if (this.isN1Parameterized()) {
                    this.N1 = value;
                    break;
                }
                this.alpha = value;
                break;
            }
            case 3: {
                this.tx = value;
                break;
            }
        }
    }

    public void setParameterSE(double value, int k) {
        switch (k) {
            case 0: {
                this.N0SE = value;
                break;
            }
            case 1: {
                this.rSE = value;
                break;
            }
            case 2: {
                if (this.isN1Parameterized()) {
                    this.N1SE = value;
                    break;
                }
                this.alphaSE = value;
                break;
            }
            case 3: {
                this.txSE = value;
                break;
            }
        }
    }

    public String toString() {
        OutputTarget out = OutputTarget.openString();
        this.report(out);
        out.close();
        return out.getString();
    }

    public void report(PrintWriter out) {
        out.println("Demographic model: const-exp-const");
        if (this.isN1Parameterized()) {
            out.println("Demographic function: N(t) = N0           for t < x");
            out.println("                             N0 exp(-r*(t-x)) for x < t < x - ln(N1/N0)/r");
            out.println("                             N1           otherwise");
        } else {
            out.println("Demographic function: N(t) = N0           for t < x");
            out.println("                             N0 exp(-r*(t-x)) for x < t < x - ln(alpha)/r");
            out.println("                             N0 alpha     otherwise");
        }
        out.print("Unit of time: ");
        if (this.getUnits() == 1) {
            out.print("generations");
        } else {
            out.print("expected substitutions");
        }
        out.println();
        out.println();
        out.println("Parameters of demographic function:");
        out.print(" present-day population size N0: ");
        this.fo.displayDecimal(out, this.N0, 6);
        if (this.N0SE != 0.0) {
            out.print(" (S.E. ");
            this.fo.displayDecimal(out, this.N0SE, 6);
            out.print(")");
        }
        out.println();
        out.print(" growth rate r: ");
        this.fo.displayDecimal(out, this.r, 6);
        if (this.rSE != 0.0) {
            out.print(" (S.E. ");
            this.fo.displayDecimal(out, this.rSE, 6);
            out.print(")");
        }
        out.println();
        if (this.isN1Parameterized()) {
            out.print(" pre-growth population size N1: ");
            this.fo.displayDecimal(out, this.N1, 6);
            if (this.N1SE != 0.0) {
                out.print(" (S.E. ");
                this.fo.displayDecimal(out, this.N1SE, 6);
                out.print(")");
            }
            out.println();
            out.print(" Ratio of poulation sizes alpha: ");
            this.fo.displayDecimal(out, this.N1 / this.N0, 6);
            out.println();
        } else {
            out.print(" ratio of population sizes alpha: ");
            this.fo.displayDecimal(out, this.alpha, 6);
            if (this.alphaSE != 0.0) {
                out.print(" (S.E. ");
                this.fo.displayDecimal(out, this.alphaSE, 6);
                out.print(")");
            }
            out.println();
            out.print(" initial population size alpha N0: ");
            this.fo.displayDecimal(out, this.alpha * this.N0, 6);
            out.println();
        }
        out.println();
        out.print(" time of end of expansion phase x: ");
        this.fo.displayDecimal(out, this.tx, 6);
        if (this.txSE != 0.0) {
            out.print(" (S.E. ");
            this.fo.displayDecimal(out, this.txSE, 6);
            out.print(")");
        }
        out.println();
        if (this.getLogL() != 0.0) {
            out.println();
            out.print("log L: ");
            this.fo.displayDecimal(out, this.getLogL(), 6);
            out.println();
        }
    }

    public static void main(String[] args) {
        double size = 100.0;
        double growth = 0.02;
        double ancestral = 0.2;
        double timeX = 25.0;
        int units = 1;
        int param = 0;
        ConstExpConst model = new ConstExpConst(size, growth, ancestral, timeX, units, param);
        ConstExpGrowth model2 = new ConstExpGrowth(size, growth, ancestral, units, param);
        ConstExpConst model3 = new ConstExpConst(size, growth, ancestral, 0.0, units, param);
        model.testConsistency(5000, 200.0);
        model2.testConsistency(5000, 200.0);
        model3.testConsistency(5000, 200.0);
    }
}

