/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import java.io.PrintWriter;
import pal.alignment.Alignment;
import pal.alignment.AlignmentUtils;
import pal.alignment.AnnotationAlignment;
import pal.alignment.SimpleAlignment;
import pal.datatype.DataType;
import pal.misc.IdGroup;
import pal.misc.Identifier;

public class SimpleAnnotatedAlignment
extends SimpleAlignment
implements AnnotationAlignment {
    public float chromosomePosition;
    public int chromosome;
    public float[] weightedPosition;
    public char[] positionType;
    public String locusName;

    public SimpleAnnotatedAlignment(Alignment a) {
        super(a);
        this.initWhenNoAnnotation();
        this.weightedPosition = new float[this.numSites];
        this.positionType = new char[this.numSites];
    }

    public SimpleAnnotatedAlignment(AnnotationAlignment a) {
        super(a);
        this.chromosomePosition = a.getChromosomePosition(0);
        this.chromosome = a.getChromosome(0);
        this.locusName = a.getLocusName(0);
        this.weightedPosition = new float[this.numSites];
        this.positionType = new char[this.numSites];
        int i = 0;
        while (i < this.getSiteCount()) {
            this.weightedPosition[i] = a.getWeightedLocusPosition(i);
            this.positionType[i] = a.getPositionType(i);
            ++i;
        }
    }

    public SimpleAnnotatedAlignment(AnnotationAlignment a, IdGroup newGroup) {
        int intersectionCount = 0;
        int i = 0;
        while (i < newGroup.getIdCount()) {
            int oldI = a.whichIdNumber(newGroup.getIdentifier(i).getName());
            if (oldI >= 0) {
                ++intersectionCount;
            }
            ++i;
        }
        this.sequences = new String[intersectionCount];
        intersectionCount = 0;
        int i2 = 0;
        while (i2 < newGroup.getIdCount()) {
            int oldI = a.whichIdNumber(newGroup.getIdentifier(i2).getName());
            if (oldI >= 0) {
                this.sequences[intersectionCount] = a.getAlignedSequenceString(oldI);
                ++intersectionCount;
            }
            ++i2;
        }
        this.init(newGroup, this.sequences);
        this.chromosomePosition = a.getChromosomePosition(0);
        this.chromosome = a.getChromosome(0);
        this.locusName = a.getLocusName(0);
        this.weightedPosition = new float[this.numSites];
        this.positionType = new char[this.numSites];
        int i3 = 0;
        while (i3 < this.numSites) {
            this.weightedPosition[i3] = a.getWeightedLocusPosition(i3);
            this.positionType[i3] = a.getPositionType(i3);
            ++i3;
        }
    }

    public SimpleAnnotatedAlignment(Identifier[] ids, String[] sequences, String gaps, DataType dt) {
        super(ids, sequences, gaps, dt);
        this.initWhenNoAnnotation();
        this.weightedPosition = new float[this.numSites];
        this.positionType = new char[this.numSites];
    }

    public SimpleAnnotatedAlignment(IdGroup group, String[] sequences, DataType dt) {
        super(group, sequences, dt);
        this.initWhenNoAnnotation();
        this.weightedPosition = new float[this.numSites];
        this.positionType = new char[this.numSites];
    }

    public SimpleAnnotatedAlignment(IdGroup group, String[] sequences, String gaps, DataType dt) {
        super(group, sequences, gaps, dt);
        this.initWhenNoAnnotation();
        this.weightedPosition = new float[this.numSites];
        this.positionType = new char[this.numSites];
    }

    private void init(IdGroup group, String[] sequences) {
        this.numSeqs = sequences.length;
        this.numSites = sequences[0].length();
        this.sequences = sequences;
        this.idGroup = group;
        AlignmentUtils.estimateFrequencies(this);
    }

    private void initWhenNoAnnotation() {
        this.locusName = "Unknown";
        this.chromosome = -9;
        this.chromosomePosition = -9.0f;
    }

    public float getChromosomePosition(int site) {
        return this.chromosomePosition;
    }

    public void setChromosomePosition(float position) {
        this.chromosomePosition = position;
    }

    public int getChromosome(int site) {
        return this.chromosome;
    }

    public void setChromosome(int chromosome) {
        this.chromosome = chromosome;
    }

    public float getWeightedLocusPosition(int site) {
        return this.weightedPosition[site];
    }

    public void setWeightedLocusPosition(int site, float weightedPos) {
        this.weightedPosition[site] = weightedPos;
    }

    public int getLocusPosition(int site) {
        return site;
    }

    public char getPositionType(int site) {
        return this.positionType[site];
    }

    public void setPositionType(int site, char posType) {
        this.positionType[site] = posType;
    }

    public String getLocusName(int site) {
        return this.locusName;
    }

    public void setLocusName(String locusName) {
        this.locusName = locusName;
    }

    public DataType getDataType(int site) {
        return this.getDataType();
    }

    public void report(PrintWriter out) {
        AlignmentUtils.report(this, out);
        out.println("Locus: " + this.locusName);
        out.println("Chromsome: " + this.chromosome + " Position:" + this.chromosomePosition);
    }
}

