/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import java.io.IOException;
import java.io.PushbackReader;
import java.util.Vector;
import pal.alignment.AbstractAlignment;
import pal.alignment.AlignmentParseException;
import pal.io.FormattedInput;
import pal.io.InputSource;
import pal.io.NexusParseException;
import pal.io.NexusTokenizer;
import pal.misc.Identifier;
import pal.misc.SimpleIdGroup;

public class ReadAlignment
extends AbstractAlignment {
    private int lineLength;
    private Vector names;
    private Vector seqs;
    private Vector sites;
    private FormattedInput fi = FormattedInput.getInstance();
    private char[][] data = null;

    public ReadAlignment(PushbackReader input) throws AlignmentParseException, IOException {
        this.readFile(input);
    }

    public ReadAlignment(String file) throws AlignmentParseException, IOException {
        InputSource input = InputSource.openFile(file);
        this.readFile(input);
        input.close();
    }

    public char getData(int seq, int site) {
        return this.data[seq][site];
    }

    private final boolean isType(PushbackReader in, String id) throws IOException {
        int i = 0;
        while (i < id.length()) {
            int c = this.fi.readNextChar(in);
            if (c != id.charAt(i)) {
                in.unread(c);
                return false;
            }
            ++i;
        }
        return true;
    }

    private void readFile(PushbackReader in) throws AlignmentParseException, IOException {
        if (this.isType(in, "CLUSTAL")) {
            this.fi.nextLine(in);
            this.readCLUSTALW(in);
        } else if (this.isType(in, "#NEXUS") || this.isType(in, "#nexus")) {
            this.readNEXUS(in);
        } else {
            this.readPHYLIP(in);
        }
        int i = 0;
        while (i < this.numSeqs) {
            int j = 0;
            while (j < this.numSites) {
                this.data[i][j] = Character.toUpperCase(this.data[i][j]);
                ++j;
            }
            ++i;
        }
        this.guessDataType();
    }

    private void readNEXUS(PushbackReader in) throws AlignmentParseException {
        NexusTokenizer ntp = null;
        try {
            ntp = new NexusTokenizer(in);
            ntp.setReadWhiteSpace(false);
            ntp.setWordModification(0);
            ntp.setIgnoreComments(true);
            boolean seqsOK = false;
            boolean sitesOK = false;
            boolean isInterleaved = false;
            String nToken = ntp.readToken();
            while (!seqsOK || !sitesOK) {
                if (nToken.equals("NCHAR")) {
                    ntp.readToken();
                    this.numSites = Integer.parseInt(ntp.readToken());
                    sitesOK = true;
                } else if (nToken.equals("NTAX")) {
                    ntp.readToken();
                    this.numSeqs = Integer.parseInt(ntp.readToken());
                    seqsOK = true;
                }
                nToken = ntp.readToken();
            }
            while (!nToken.equals("MATRIX")) {
                if (nToken.equals("INTERLEAVE")) {
                    ntp.readToken();
                    nToken = ntp.readToken();
                    if (nToken.equals("YES")) {
                        isInterleaved = true;
                    }
                }
                nToken = ntp.readToken();
            }
            String[][] d = new String[this.numSeqs][2];
            int i = 0;
            while (i < d.length) {
                d[i][1] = new String();
                ++i;
            }
            nToken = ntp.seek(11);
            int taxaNumber = 0;
            while (!nToken.equals(";")) {
                d[taxaNumber][0] = nToken;
                System.out.println("Read id: " + nToken);
                nToken = ntp.readToken();
                while (ntp.getLastTokenType() != 13) {
                    String[] stringArray = d[taxaNumber];
                    stringArray[1] = stringArray[1] + nToken;
                    nToken = ntp.readToken();
                }
                if (++taxaNumber == this.numSeqs & isInterleaved) {
                    taxaNumber = 0;
                    nToken = ntp.readToken();
                    if (ntp.getLastTokenType() != 13) continue;
                    nToken = ntp.readToken();
                    continue;
                }
                nToken = ntp.readToken();
            }
            this.idGroup = new SimpleIdGroup(this.numSeqs);
            this.data = new char[this.numSeqs][this.numSites];
            int i2 = 0;
            while (i2 < d.length) {
                this.idGroup.setIdentifier(i2, new Identifier(d[i2][0]));
                int j = 0;
                while (j < d[i2][1].length()) {
                    if (d[i2][1].length() != this.numSites) {
                        throw new AlignmentParseException("Taxa " + d[i2][0] + " sequence length not equal to " + this.numSites);
                    }
                    this.data[i2][j] = d[i2][1].charAt(j);
                    if (i2 == 0 & this.data[i2][j] == '.') {
                        throw new AlignmentParseException("Copy character (.) in first sequence not allowed @ pos " + j);
                    }
                    ++j;
                }
                ++i2;
            }
        }
        catch (IOException e) {
            throw new AlignmentParseException("I/O error after row:" + ntp.getRow() + ", col:" + ntp.getCol());
        }
        catch (NumberFormatException e) {
            throw new AlignmentParseException("Number parse error - row:" + ntp.getRow() + ", col:" + ntp.getCol());
        }
        catch (NexusParseException e) {
            throw new AlignmentParseException("Parse error row:" + ntp.getRow() + ", col:" + ntp.getCol());
        }
    }

    private void readCLUSTALW(PushbackReader in) throws AlignmentParseException {
        int EOF = -1;
        int seq = 0;
        int pos = 0;
        try {
            int c = this.fi.readNextChar(in);
            in.unread(c);
            this.names = new Vector();
            this.seqs = new Vector();
            c = in.read();
            while (!Character.isWhitespace((char)c)) {
                in.unread(c);
                this.names.addElement(this.fi.readLabel(in, 10));
                this.readSeqLineC(in, seq, pos);
                ++seq;
                c = in.read();
            }
            in.unread(c);
            this.fi.nextLine(in);
            pos += this.lineLength;
            this.numSeqs = seq;
            c = this.fi.readNextChar(in);
            in.unread(c);
            while (c != EOF) {
                seq = 0;
                while (seq < this.numSeqs) {
                    do {
                        if ((c = in.read()) >= 0) continue;
                        throw new AlignmentParseException("Unexpected end of file exception!");
                    } while (Character.isWhitespace((char)c));
                    this.readSeqLineC(in, seq, pos);
                    ++seq;
                }
                this.fi.nextLine(in);
                pos += this.lineLength;
                c = this.fi.readNextChar(in);
                in.unread(c);
            }
            this.numSites = pos;
            this.idGroup = new SimpleIdGroup(this.numSeqs);
            this.data = new char[this.numSeqs][this.numSites];
            int i = 0;
            while (i < this.numSeqs) {
                this.idGroup.setIdentifier(i, new Identifier((String)this.names.elementAt(i)));
                ++i;
            }
            int i2 = 0;
            while (i2 < this.numSeqs) {
                int j = 0;
                while (j < this.numSites) {
                    this.data[i2][j] = ((Character)((Vector)this.seqs.elementAt(i2)).elementAt(j)).charValue();
                    ++j;
                }
                ++i2;
            }
            this.names = null;
            int i3 = 0;
            while (i3 < this.numSeqs) {
                ((Vector)this.seqs.elementAt(i3)).removeAllElements();
                ++i3;
            }
            this.seqs = null;
        }
        catch (IOException e) {
            throw new AlignmentParseException("IO error after pos. " + (pos + 1) + ", seq. " + (seq + 1));
        }
    }

    private void readSeqLineC(PushbackReader in, int s, int pos) throws IOException, AlignmentParseException {
        if (pos == 0) {
            this.sites = new Vector();
            this.seqs.addElement(this.sites);
        } else {
            this.sites = (Vector)this.seqs.elementAt(s);
        }
        if (s == 0) {
            String thisLine = this.fi.readLine(in, false);
            this.lineLength = thisLine.length();
            int i = 0;
            while (i < this.lineLength) {
                char c = thisLine.charAt(i);
                if (c == '.') {
                    throw new AlignmentParseException("Copy character (.) in first sequence not allowed (pos. " + (i + pos + 1) + ")");
                }
                this.sites.addElement(new Character(c));
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.lineLength) {
                int c = this.fi.readNextChar(in);
                if (c == 46) {
                    c = ((Character)((Vector)this.seqs.elementAt(0)).elementAt(pos + i)).charValue();
                }
                this.sites.addElement(new Character((char)c));
                ++i;
            }
            this.fi.nextLine(in);
        }
    }

    private void readPHYLIP(PushbackReader in) throws AlignmentParseException {
        int pos = 0;
        int seq = 0;
        try {
            this.numSeqs = this.fi.readInt(in);
            this.numSites = this.fi.readInt(in);
            this.idGroup = new SimpleIdGroup(this.numSeqs);
            this.data = new char[this.numSeqs][this.numSites];
            String header = this.fi.readLine(in, false);
            boolean interleaved = true;
            if (header.length() > 0 && header.charAt(0) == 'S') {
                interleaved = false;
            }
            if (interleaved) {
                while (pos < this.numSites) {
                    int c = this.fi.readNextChar(in);
                    in.unread(c);
                    seq = 0;
                    while (seq < this.numSeqs) {
                        this.readSeqLineP(in, seq, pos, this.numSites);
                        ++seq;
                    }
                    pos += this.lineLength;
                }
            } else {
                seq = 0;
                while (seq < this.numSeqs) {
                    int c = this.fi.readNextChar(in);
                    in.unread(c);
                    this.idGroup.setIdentifier(seq, new Identifier(this.fi.readLabel(in, 10)));
                    pos = 0;
                    while (pos < this.numSites) {
                        this.data[seq][pos] = (char)this.fi.readNextChar(in);
                        if (this.data[0][pos] == '.') {
                            if (seq == 0) {
                                throw new AlignmentParseException("Copy character (.) in first sequence not allowed (pos. " + (pos + 1) + ")");
                            }
                            this.data[seq][pos] = this.data[0][pos];
                        }
                        ++pos;
                    }
                    ++seq;
                }
            }
        }
        catch (IOException e) {
            throw new AlignmentParseException("IO error after pos. " + (pos + 1) + ", seq. " + (seq + 1));
        }
    }

    private void readSeqLineP(PushbackReader in, int s, int pos, int maxPos) throws IOException, AlignmentParseException {
        if (pos == 0) {
            this.idGroup.setIdentifier(s, new Identifier(this.fi.readLabel(in, 10)));
        }
        if (s == 0) {
            String thisLine = this.fi.readLine(in, false);
            this.lineLength = thisLine.length() > maxPos - pos ? maxPos - pos : thisLine.length();
            int i = 0;
            while (i < this.lineLength) {
                this.data[0][pos + i] = thisLine.charAt(i);
                if (this.data[0][pos + i] == '.') {
                    throw new AlignmentParseException("Copy character (.) in first sequence not allowed (pos. " + (i + pos + 1) + ")");
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.lineLength) {
                this.data[s][pos + i] = (char)this.fi.readNextChar(in);
                if (this.data[s][pos + i] == '.') {
                    this.data[s][pos + i] = this.data[0][pos + i];
                }
                ++i;
            }
            this.fi.nextLine(in);
        }
    }
}

