/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import pal.alignment.Alignment;
import pal.alignment.AlignmentUtils;
import pal.alignment.AnnotationAlignment;
import pal.alignment.SimpleAlignment;
import pal.datatype.DataType;
import pal.misc.IdGroup;
import pal.misc.Identifier;

public class MultiLocusAnnotatedAlignment
extends SimpleAlignment
implements AnnotationAlignment {
    public float[] chromosomePosition;
    public int[] chromosome;
    public float[] weightedPosition;
    public int[] locusPosition;
    public char[] positionType;
    public String[] locusName;
    public DataType[] siteDataType = null;

    public MultiLocusAnnotatedAlignment(Alignment a) {
        super(a);
        this.initMatrices();
    }

    public MultiLocusAnnotatedAlignment() {
    }

    public MultiLocusAnnotatedAlignment(AnnotationAlignment a) {
        super(a);
        this.initMatrices();
        int i = 0;
        while (i < this.getSiteCount()) {
            this.chromosomePosition[i] = a.getChromosomePosition(i);
            this.chromosome[i] = a.getChromosome(i);
            this.locusName[i] = a.getLocusName(i);
            this.weightedPosition[i] = a.getWeightedLocusPosition(i);
            this.positionType[i] = a.getPositionType(i);
            ++i;
        }
    }

    public MultiLocusAnnotatedAlignment(Identifier[] ids, String[] sequences, String gaps, DataType dt) {
        super(ids, sequences, gaps, dt);
        this.initMatrices();
    }

    public MultiLocusAnnotatedAlignment(IdGroup group, String[] sequences, DataType dt) {
        super(group, sequences, dt);
        this.initMatrices();
    }

    public MultiLocusAnnotatedAlignment(IdGroup group, String[] sequences, String gaps, DataType dt) {
        super(group, sequences, gaps, dt);
        this.initMatrices();
    }

    public MultiLocusAnnotatedAlignment(AnnotationAlignment a, IdGroup newGroup) {
        this.sequences = new String[newGroup.getIdCount()];
        int i = 0;
        while (i < newGroup.getIdCount()) {
            int oldI = a.whichIdNumber(newGroup.getIdentifier(i).getName());
            this.sequences[i] = a.getAlignedSequenceString(oldI);
            ++i;
        }
        this.init(newGroup, this.sequences);
        this.initMatrices();
        this.weightedPosition = new float[this.numSites];
        this.positionType = new char[this.numSites];
        int i2 = 0;
        while (i2 < this.numSites) {
            this.chromosomePosition[i2] = a.getChromosomePosition(i2);
            this.chromosome[i2] = a.getChromosome(i2);
            this.locusName[i2] = a.getLocusName(i2);
            this.weightedPosition[i2] = a.getWeightedLocusPosition(i2);
            this.positionType[i2] = a.getPositionType(i2);
            ++i2;
        }
    }

    protected void initMatrices() {
        this.chromosomePosition = new float[this.getSiteCount()];
        this.chromosome = new int[this.getSiteCount()];
        this.locusName = new String[this.getSiteCount()];
        this.locusPosition = new int[this.getSiteCount()];
        this.weightedPosition = new float[this.getSiteCount()];
        this.positionType = new char[this.getSiteCount()];
    }

    protected void init(IdGroup group, String[] sequences) {
        this.numSeqs = sequences.length;
        this.numSites = sequences[0].length();
        this.sequences = sequences;
        this.idGroup = group;
        AlignmentUtils.estimateFrequencies(this);
    }

    public float getChromosomePosition(int site) {
        return this.chromosomePosition[site];
    }

    public void setChromosomePosition(float position, int site) {
        this.chromosomePosition[site] = position;
    }

    public int getChromosome(int site) {
        return this.chromosome[site];
    }

    public void setChromosome(int chromosome, int site) {
        this.chromosome[site] = chromosome;
    }

    public float getWeightedLocusPosition(int site) {
        return this.weightedPosition[site];
    }

    public void setWeightedLocusPosition(int site, float weightedPos) {
        this.weightedPosition[site] = weightedPos;
    }

    public int getLocusPosition(int site) {
        return this.locusPosition[site];
    }

    public void setLocusPosition(int position, int site) {
        this.locusPosition[site] = position;
    }

    public char getPositionType(int site) {
        return this.positionType[site];
    }

    public void setPositionType(int site, char posType) {
        this.positionType[site] = posType;
    }

    public String getLocusName(int site) {
        return this.locusName[site];
    }

    public void setLocusName(String locusName, int site) {
        this.locusName[site] = locusName;
    }

    public DataType getDataType(int site) {
        if (this.siteDataType == null) {
            return this.getDataType();
        }
        return this.siteDataType[site];
    }
}

