/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import pal.alignment.AnnotationAlignment;
import pal.alignment.IndelAlignment;
import pal.alignment.IndelPosition;
import pal.datatype.DataType;
import pal.datatype.NumericDataType;

public class IndelAnnotatedAlignment
extends IndelAlignment
implements AnnotationAlignment {
    public float chromosomePosition;
    public int chromosome;
    public float[] weightedLocusPosition;
    public int[] locusPosition;
    public char[] positionType;
    public String locusName;

    public IndelAnnotatedAlignment(AnnotationAlignment a, boolean anchored) {
        super(a, anchored);
        this.setDataType(new NumericDataType());
        this.chromosomePosition = a.getChromosomePosition(0);
        this.chromosome = a.getChromosome(0);
        this.locusName = a.getLocusName(0);
        this.locusPosition = new int[this.numSites];
        this.weightedLocusPosition = new float[this.numSites];
        this.positionType = new char[this.numSites];
        int i = 0;
        while (i < this.numSites) {
            IndelPosition ip = this.getIndelPosition(i);
            this.locusPosition[i] = ip.start;
            this.weightedLocusPosition[i] = a.getWeightedLocusPosition(ip.start);
            this.positionType[i] = a.getPositionType(ip.start);
            ++i;
        }
    }

    public float getChromosomePosition(int site) {
        return this.chromosomePosition;
    }

    public void setChromosomePosition(float position) {
        this.chromosomePosition = position;
    }

    public int getChromosome(int site) {
        return this.chromosome;
    }

    public void setChromosome(int chromosome) {
        this.chromosome = chromosome;
    }

    public float getWeightedLocusPosition(int site) {
        return this.weightedLocusPosition[site];
    }

    public int getLocusPosition(int site) {
        return this.locusPosition[site];
    }

    public char getPositionType(int site) {
        return this.positionType[site];
    }

    public String getLocusName(int site) {
        return this.locusName;
    }

    public void setLocusName(String locusName) {
        this.locusName = locusName;
    }

    public DataType getDataType(int site) {
        return this.getDataType();
    }
}

