/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import pal.alignment.AbstractAlignment;
import pal.alignment.Alignment;
import pal.alignment.GapIterator;
import pal.misc.SimpleIdGroup;

public class GapBalancedAlignment
extends AbstractAlignment
implements Serializable {
    static final int DEFAULT_CODON_LENGTH = 3;
    private char[][] data_;
    private static final long serialVersionUID = -1042105658996999207L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.data_);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.data_ = (char[][])in.readObject();
    }

    public GapBalancedAlignment(Alignment base, int startingCodonPosition, boolean alignGap) {
        this.calculateData(base, startingCodonPosition, alignGap, 3);
    }

    public GapBalancedAlignment(Alignment base, int startingCodonPosition, int codonLength) {
        this.calculateData(base, startingCodonPosition, true, codonLength);
    }

    public GapBalancedAlignment(Alignment base, int startingCodonPosition, boolean alignGap, int codonLength) {
        this.calculateData(base, startingCodonPosition, alignGap, codonLength);
    }

    private void calculateData(Alignment base, int startingCodonPosition, boolean alignGap, int codonLength) {
        GapIterator gi = new GapIterator(base, startingCodonPosition, alignGap, codonLength);
        gi.processAllSites();
        this.data_ = gi.getData();
        this.numSeqs = gi.getNumberOfSequences();
        this.numSites = gi.getNumberOfAcceptedSites();
        this.idGroup = new SimpleIdGroup(base);
        this.setDataType(base.getDataType());
    }

    public char getData(int seq, int site) {
        return this.data_[seq][site];
    }
}

