/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import pal.alignment.Alignment;
import pal.alignment.SimpleAlignment;
import pal.datatype.AminoAcids;
import pal.datatype.DataType;
import pal.datatype.IUPACNucleotides;
import pal.datatype.MolecularDataType;
import pal.datatype.Nucleotides;
import pal.datatype.SpecificAminoAcids;
import pal.misc.IdGroup;
import pal.misc.SimpleIdGroup;

public class DataTranslator {
    int[][] nucleotideStateData_;
    MolecularDataType dataType_;
    IdGroup ids_;

    public DataTranslator(Alignment base) {
        DataType baseDataType = base.getDataType();
        if (baseDataType instanceof AminoAcids) {
            baseDataType = new SpecificAminoAcids(0);
        }
        if (!(baseDataType instanceof MolecularDataType)) {
            throw new IllegalArgumentException("Alignment does not have a molecular based data type");
        }
        this.dataType_ = (MolecularDataType)baseDataType;
        this.nucleotideStateData_ = DataTranslator.toNucleotides(DataTranslator.toStates(base), this.dataType_);
        this.ids_ = new SimpleIdGroup(base);
    }

    public DataTranslator(int[][] stateData) {
        this(stateData, IUPACNucleotides.DEFAULT_INSTANCE);
    }

    public DataTranslator(int[][] stateData, MolecularDataType dt) {
        this(stateData, dt, null);
    }

    public DataTranslator(int[][] stateData, MolecularDataType dt, IdGroup ids) {
        this.dataType_ = dt;
        this.ids_ = ids;
        this.nucleotideStateData_ = DataTranslator.toNucleotides(stateData, dt);
    }

    public DataTranslator(MolecularDataType dt, char[][] charData) {
        this.dataType_ = dt;
        this.nucleotideStateData_ = DataTranslator.toNucleotides(DataTranslator.toStates(charData, dt), dt);
    }

    public int[][] toStates(MolecularDataType dt, int startingIndex) {
        int[][] newStates = new int[this.nucleotideStateData_.length][];
        int i = 0;
        while (i < newStates.length) {
            newStates[i] = dt.getMolecularStatesFromIUPACNucleotides(this.nucleotideStateData_[i], startingIndex);
            ++i;
        }
        return newStates;
    }

    public double[] getFrequencies(MolecularDataType dt, int startingIndex) {
        int[][] states = this.toStates(dt, startingIndex);
        int[] counts = new int[dt.getNumStates()];
        int i = 0;
        while (i < counts.length) {
            counts[i] = 0;
            ++i;
        }
        int total = 0;
        int i2 = 0;
        while (i2 < states.length) {
            int j = 0;
            while (j < states[i2].length) {
                int state = states[i2][j];
                if (!dt.isUnknownState(state)) {
                    ++total;
                    int n = state;
                    counts[n] = counts[n] + 1;
                }
                ++j;
            }
            ++i2;
        }
        double[] frequencies = new double[counts.length];
        double dTotal = total;
        int i3 = 0;
        while (i3 < frequencies.length) {
            frequencies[i3] = (double)counts[i3] / dTotal;
            ++i3;
        }
        return frequencies;
    }

    public void ensureUnknownState(int[] states, int unknownState) {
        DataTranslator.ensureUnknownState(this.dataType_, states, unknownState);
    }

    public char[][] toChars(MolecularDataType dt, int startingIndex) {
        return DataTranslator.toChars(this.toStates(dt, startingIndex), dt);
    }

    private final IdGroup generateIdGroup() {
        String[] ids = new String[this.nucleotideStateData_.length];
        int i = 0;
        while (i < ids.length) {
            ids[i] = "Sequence:" + i;
            ++i;
        }
        return new SimpleIdGroup(ids);
    }

    public Alignment toAlignment(MolecularDataType dt, int startingIndex) {
        IdGroup idGroup = this.ids_ == null ? this.generateIdGroup() : this.ids_;
        return new SimpleAlignment(idGroup, this.toChars(dt, startingIndex), (DataType)dt);
    }

    public Alignment toReverseComplementNucleotides(int startingIndex) {
        IdGroup idGroup = this.ids_ == null ? this.generateIdGroup() : this.ids_;
        int[][] baseSequences = this.toStates(Nucleotides.DEFAULT_INSTANCE, startingIndex);
        int i = 0;
        while (i < baseSequences.length) {
            Nucleotides.complementSequence(baseSequences[i]);
            DataType.Utils.reverseSequence(baseSequences[i]);
            ++i;
        }
        return new SimpleAlignment(idGroup, Nucleotides.DEFAULT_INSTANCE, baseSequences);
    }

    public Alignment toLeftAlignedReverseComplementNucleotides(int startingIndex) {
        IdGroup idGroup = this.ids_ == null ? this.generateIdGroup() : this.ids_;
        int[][] baseSequences = this.toStates(Nucleotides.DEFAULT_INSTANCE, startingIndex);
        int i = 0;
        while (i < baseSequences.length) {
            Nucleotides.complementSequence(baseSequences[i]);
            DataType.Utils.reverseSequence(baseSequences[i]);
            DataType.Utils.leftAlignSequence(baseSequences[i], Nucleotides.DEFAULT_INSTANCE);
            ++i;
        }
        return new SimpleAlignment(idGroup, Nucleotides.DEFAULT_INSTANCE, baseSequences);
    }

    public static final int[][] toStates(Alignment a) {
        return DataTranslator.toStates(a, -1);
    }

    public static final int[][] toStates(Alignment a, int gapUnknownState) {
        DataType dt = a.getDataType();
        int sequenceCount = a.getSequenceCount();
        int siteCount = a.getSiteCount();
        int[][] states = new int[sequenceCount][siteCount];
        int sequence = 0;
        while (sequence < sequenceCount) {
            int site = 0;
            while (site < siteCount) {
                char c = a.getData(sequence, site);
                states[sequence][site] = dt.isUnknownChar(c) ? gapUnknownState : dt.getState(c);
                ++site;
            }
            ++sequence;
        }
        return states;
    }

    public static final int[][] toNucleotides(int[][] dtStates, MolecularDataType dt) {
        int[][] states = new int[dtStates.length][];
        int sequence = 0;
        while (sequence < states.length) {
            states[sequence] = dt.getNucleotideStates(dtStates[sequence]);
            ++sequence;
        }
        return states;
    }

    public static final int[][] toStates(char[][] dtChars, DataType dt) {
        int[][] states = new int[dtChars.length][];
        int sequence = 0;
        while (sequence < states.length) {
            states[sequence] = new int[dtChars[sequence].length];
            int i = 0;
            while (i < states[sequence].length) {
                states[sequence][i] = dt.getState(dtChars[sequence][i]);
                ++i;
            }
            ++sequence;
        }
        return states;
    }

    public static final char[][] toChars(int[][] dtStates, DataType dt) {
        char[][] chars = new char[dtStates.length][];
        int sequence = 0;
        while (sequence < chars.length) {
            chars[sequence] = new char[dtStates[sequence].length];
            int i = 0;
            while (i < chars[sequence].length) {
                chars[sequence][i] = dt.getChar(dtStates[sequence][i]);
                ++i;
            }
            ++sequence;
        }
        return chars;
    }

    public static final void ensureUnknownState(DataType dt, int[] states, int unknownState) {
        int i = 0;
        while (i < states.length) {
            if (dt.isUnknownState(states[i])) {
                states[i] = unknownState;
            }
            ++i;
        }
    }
}

