/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import java.io.PrintWriter;
import pal.alignment.Alignment;
import pal.alignment.ConsistencyBag;
import pal.alignment.CostBag;
import pal.alignment.DataTranslator;
import pal.alignment.SimpleAlignment;
import pal.datatype.AminoAcids;
import pal.datatype.CodonTable;
import pal.datatype.Codons;
import pal.datatype.DataType;
import pal.datatype.Nucleotides;
import pal.datatype.TransitionPenaltyTable;
import pal.datatype.TwoStates;
import pal.io.FormattedOutput;
import pal.misc.IdGroup;
import pal.misc.SimpleIdGroup;

public class AlignmentUtils {
    static FormattedOutput format = FormattedOutput.getInstance();

    public static void report(Alignment a, PrintWriter out) {
        DataType dt = a.getDataType();
        if (dt == null) {
            dt = AlignmentUtils.getSuitableInstance(a);
        }
        out.println("Number of sequences: " + a.getSequenceCount());
        out.println("Number of sites: " + a.getSiteCount());
        out.println("Data type: " + dt.getDescription() + " data");
    }

    public static void print(Alignment a, PrintWriter out) {
        AlignmentUtils.printInterleaved(a, out);
    }

    public static void printPlain(Alignment a, PrintWriter out) {
        AlignmentUtils.printPlain(a, out, false);
    }

    public static void printPlain(Alignment a, PrintWriter out, boolean relaxed) {
        out.println("  " + a.getSequenceCount() + " " + a.getSiteCount());
        int s = 0;
        while (s < a.getSequenceCount()) {
            format.displayLabel(out, a.getIdentifier(s).getName(), relaxed ? 20 : 10);
            out.print("     ");
            AlignmentUtils.printNextSites(a, out, false, s, 0, a.getSiteCount());
            out.println();
            ++s;
        }
    }

    public static void printSequential(Alignment a, PrintWriter out) {
        out.println("  " + a.getSequenceCount() + " " + a.getSiteCount() + "  S");
        int s = 0;
        while (s < a.getSequenceCount()) {
            int n = 0;
            while (n < a.getSiteCount()) {
                if (n == 0) {
                    format.displayLabel(out, a.getIdentifier(s).getName(), 10);
                    out.print("     ");
                } else {
                    out.print("               ");
                }
                AlignmentUtils.printNextSites(a, out, false, s, n, 50);
                out.println();
                n += 50;
            }
            ++s;
        }
    }

    public static void printInterleaved(Alignment a, PrintWriter out) {
        int n = 0;
        out.println("  " + a.getSequenceCount() + " " + a.getSiteCount());
        while (n < a.getSiteCount()) {
            int s = 0;
            while (s < a.getSequenceCount()) {
                if (n == 0) {
                    format.displayLabel(out, a.getIdentifier(s).getName(), 10);
                    out.print("     ");
                } else {
                    out.print("               ");
                }
                AlignmentUtils.printNextSites(a, out, true, s, n, 50);
                out.println();
                ++s;
            }
            out.println();
            n += 50;
        }
    }

    public static void printCLUSTALW(Alignment a, PrintWriter out) {
        int n = 0;
        out.println("CLUSTAL W multiple sequence alignment");
        out.println();
        while (n < a.getSiteCount()) {
            out.println();
            int s = 0;
            while (s < a.getSequenceCount()) {
                format.displayLabel(out, a.getIdentifier(s).getName(), 10);
                out.print("     ");
                AlignmentUtils.printNextSites(a, out, false, s, n, 50);
                out.println();
                ++s;
            }
            out.println("               ");
            n += 50;
        }
    }

    public static final void getAlignedSequenceIndices(Alignment a, int i, int[] indices, DataType dataType, int unknownState) {
        String sequence = a.getAlignedSequenceString(i);
        int j = 0;
        while (j < a.getSiteCount()) {
            char c = sequence.charAt(j);
            indices[j] = dataType.isUnknownChar(c) ? unknownState : dataType.getState(c);
            ++j;
        }
    }

    public static final int[][] getAlignedStates(Alignment base) {
        return AlignmentUtils.getAlignedStates(base, -1);
    }

    public static final int[][] getAlignedStates(Alignment base, int unknownState) {
        int numberOfSites = base.getSiteCount();
        DataType dt = base.getDataType();
        int[][] sequences = new int[base.getSequenceCount()][base.getSiteCount()];
        int i = 0;
        while (i < sequences.length) {
            int j = 0;
            while (j < sequences[i].length) {
                char c = base.getData(i, j);
                sequences[i][j] = dt.isUnknownChar(c) ? unknownState : dt.getState(c);
                ++j;
            }
            ++i;
        }
        return sequences;
    }

    public static double getAlignmentPenalty(Alignment a, TransitionPenaltyTable penalties, double gapCreation, double gapExtension) {
        return AlignmentUtils.getAlignmentPenalty(a, a.getDataType(), penalties, gapCreation, gapExtension, false);
    }

    public static double getAlignmentPenalty(Alignment a, DataType dataType, TransitionPenaltyTable penalties, double gapCreation, double gapExtension, boolean local) {
        int[][] indices = new int[a.getSequenceCount()][a.getSiteCount()];
        int i = 0;
        while (i < a.getSequenceCount()) {
            AlignmentUtils.getAlignedSequenceIndices(a, i, indices[i], dataType, dataType.getNumStates());
            ++i;
        }
        CostBag totalBag = new CostBag();
        int numberOfSites = indices[0].length;
        int i2 = 0;
        while (i2 < a.getSequenceCount()) {
            int j = i2 + 1;
            while (j < a.getSequenceCount()) {
                totalBag.add(AlignmentUtils.getAlignmentPenalty(dataType, penalties, indices[i2], indices[j], local, numberOfSites));
                ++j;
            }
            ++i2;
        }
        return totalBag.score(gapCreation, gapExtension);
    }

    public static DataType getSuitableInstance(Alignment alignment) {
        return AlignmentUtils.getSuitableInstance(new AlignmentCM(alignment));
    }

    public static DataType getSuitableInstance(String[] sequences) {
        return AlignmentUtils.getSuitableInstance(new StringCM(sequences));
    }

    public static DataType getSuitableInstance(char[][] sequences) {
        return AlignmentUtils.getSuitableInstance(new CharacterCM(sequences));
    }

    private static DataType getSuitableInstance(CharacterMatrix cm) {
        long numNucs = 0L;
        long numChars = 0L;
        long numBins = 0L;
        int i = 0;
        while (i < cm.getSequenceCount()) {
            int j = 0;
            while (j < cm.getSiteCount()) {
                char c = cm.getData(i, j);
                if (c == 'A' || c == 'C' || c == 'G' || c == 'T' || c == 'U' || c == 'N') {
                    ++numNucs;
                }
                if (c != '-' && c != '?') {
                    ++numChars;
                }
                if (c == '0' || c == '1') {
                    ++numBins;
                }
                ++j;
            }
            ++i;
        }
        if (numChars == 0L) {
            numChars = 1L;
        }
        if ((double)numNucs / (double)numChars > 0.85) {
            return new Nucleotides();
        }
        if ((double)numBins / (double)numChars > 0.2) {
            return new TwoStates();
        }
        return new AminoAcids();
    }

    public static double[] estimateCodonFrequenciesF1X4(Alignment a) {
        Alignment na = new DataTranslator(a).toAlignment(Nucleotides.DEFAULT_INSTANCE, 0);
        return Codons.getF1X4CodonFrequencies(AlignmentUtils.estimateFrequencies(na));
    }

    public static double[] estimateCodonFrequenciesF3X4(Alignment a) {
        Alignment na = new DataTranslator(a).toAlignment(Nucleotides.DEFAULT_INSTANCE, 0);
        return Codons.getF3X4CodonFrequencies(AlignmentUtils.estimateTupletFrequencies(na, 3));
    }

    public static double[] estimateFrequencies(Alignment a) {
        DataType dt = a.getDataType();
        if (dt == null) {
            dt = AlignmentUtils.getSuitableInstance(a);
        }
        int numStates = dt.getNumStates();
        double[] frequency = new double[numStates];
        long[] stateCount = new long[numStates + 1];
        int i = 0;
        while (i < numStates + 1) {
            stateCount[i] = 0L;
            ++i;
        }
        int i2 = 0;
        while (i2 < a.getSequenceCount()) {
            int j = 0;
            while (j < a.getSiteCount()) {
                int state = dt.getState(a.getData(i2, j));
                if (dt.isUnknownState(state)) {
                    state = stateCount.length - 1;
                }
                int n = state;
                stateCount[n] = stateCount[n] + 1L;
                ++j;
            }
            ++i2;
        }
        long sumStates = (long)(a.getSiteCount() * a.getSequenceCount()) - stateCount[numStates];
        int i3 = 0;
        while (i3 < numStates) {
            frequency[i3] = (double)stateCount[i3] / (double)sumStates;
            ++i3;
        }
        return frequency;
    }

    public static double[][] estimateTupletFrequencies(Alignment a, int tupletSize) {
        DataType dt = a.getDataType();
        if (dt == null) {
            dt = AlignmentUtils.getSuitableInstance(a);
        }
        int numberOfStates = dt.getNumStates();
        double[][] frequencies = new double[tupletSize][numberOfStates];
        long[][] stateCounts = new long[tupletSize][numberOfStates + 1];
        long[] tupleStateCounts = new long[tupletSize];
        int j = 0;
        while (j < tupletSize) {
            tupleStateCounts[j] = 0L;
            int i = 0;
            while (i < numberOfStates + 1) {
                stateCounts[j][i] = 0L;
                ++i;
            }
            ++j;
        }
        int sequenceCount = a.getSequenceCount();
        int siteCount = a.getSiteCount();
        int j2 = 0;
        while (j2 < siteCount) {
            int tupleIndex = j2 % tupletSize;
            int i = 0;
            while (i < sequenceCount) {
                int state = dt.getState(a.getData(i, j2));
                if (dt.isUnknownState(state)) {
                    state = numberOfStates;
                } else {
                    int n = tupleIndex;
                    tupleStateCounts[n] = tupleStateCounts[n] + 1L;
                }
                long[] lArray = stateCounts[tupleIndex];
                int n = state;
                lArray[n] = lArray[n] + 1L;
                ++i;
            }
            ++j2;
        }
        int j3 = 0;
        while (j3 < tupletSize) {
            long sumStates = tupleStateCounts[j3];
            int i = 0;
            while (i < numberOfStates) {
                frequencies[j3][i] = (double)stateCounts[j3][i] / (double)sumStates;
                ++i;
            }
            ++j3;
        }
        return frequencies;
    }

    public static final boolean isSiteRedundant(Alignment a, int site) {
        int numSeq = a.getSequenceCount();
        DataType dt = a.getDataType();
        int i = 0;
        while (i < numSeq) {
            if (!dt.isUnknownChar(a.getData(i, site))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final Alignment removeRedundantSites(Alignment a) {
        boolean[] keep = new boolean[a.getSiteCount()];
        int toKeep = 0;
        int i = 0;
        while (i < keep.length) {
            boolean bl = keep[i] = !AlignmentUtils.isSiteRedundant(a, i);
            if (keep[i]) {
                ++toKeep;
            }
            ++i;
        }
        String[] newSeqs = new String[a.getSequenceCount()];
        int numberOfSites = a.getSiteCount();
        int i2 = 0;
        while (i2 < newSeqs.length) {
            StringBuffer sb = new StringBuffer(toKeep);
            int j = 0;
            while (j < numberOfSites) {
                if (keep[j]) {
                    sb.append(a.getData(i2, j));
                }
                ++j;
            }
            newSeqs[i2] = sb.toString();
            ++i2;
        }
        return new SimpleAlignment((IdGroup)a, newSeqs, a.getDataType());
    }

    public static final boolean isGap(Alignment a, int seq, int site) {
        return a.getDataType().isGapChar(a.getData(seq, site));
    }

    public static void getPositionMisalignmentInfo(Alignment a, PrintWriter out, int startingCodonPosition, CodonTable translator, boolean removeIncompleteCodons) {
        DataType dt = a.getDataType();
        int i = 0;
        while (i < a.getSequenceCount()) {
            int codonPosition = startingCodonPosition;
            String codon = "";
            boolean first = true;
            out.print(a.getIdentifier(i) + ":");
            int leftGaps = 0;
            int rightGaps = 0;
            int j = 0;
            while (j < a.getSiteCount()) {
                char c = a.getData(i, j);
                if (dt.isUnknownChar(c)) {
                    switch (codonPosition) {
                        case 1: {
                            ++leftGaps;
                            break;
                        }
                        case 2: {
                            ++rightGaps;
                            break;
                        }
                        default: {
                            out.print(c);
                            break;
                        }
                    }
                } else {
                    codon = codon + c;
                    if (codonPosition == 2) {
                        if (!(first && first && codon.length() != 3 && removeIncompleteCodons)) {
                            if (!first || first && startingCodonPosition == 0) {
                                out.print('[');
                            }
                            AlignmentUtils.outputChar(out, '-', leftGaps);
                            out.print(translator.getAminoAcidChar(codon.toCharArray()));
                            AlignmentUtils.outputChar(out, '-', rightGaps);
                            out.print(']');
                        }
                        first = false;
                        codon = "";
                        leftGaps = 0;
                        rightGaps = 0;
                    }
                    codonPosition = (codonPosition + 1) % 3;
                }
                ++j;
            }
            if (!removeIncompleteCodons && codonPosition != 0) {
                out.print('[');
                AlignmentUtils.outputChar(out, '-', leftGaps);
                out.print('?');
                AlignmentUtils.outputChar(out, '-', rightGaps);
            }
            out.print("\n");
            ++i;
        }
    }

    public static void getPositionMisalignmentInfo(Alignment a, PrintWriter out, int startingCodonPosition) {
        DataType dt = a.getDataType();
        int i = 0;
        while (i < a.getSequenceCount()) {
            int codonPosition = startingCodonPosition;
            out.print(a.getIdentifier(i) + ":");
            int j = 0;
            while (j < a.getSiteCount()) {
                char c = a.getData(i, j);
                if (dt.isUnknownChar(c)) {
                    out.print(c);
                } else {
                    switch (codonPosition) {
                        case 0: {
                            out.print('[');
                            break;
                        }
                        case 1: {
                            out.print(c);
                            break;
                        }
                        case 2: {
                            out.print(']');
                        }
                    }
                    codonPosition = (codonPosition + 1) % 3;
                }
                ++j;
            }
            out.print("\n");
            ++i;
        }
    }

    public static final Alignment concatAlignments(Alignment[] alignments, DataType dt) {
        int maxSequence = -1;
        Alignment maxAlignment = null;
        int length = 0;
        int i = 0;
        while (i < alignments.length) {
            if (alignments[i].getSequenceCount() > maxSequence) {
                maxAlignment = alignments[i];
                maxSequence = alignments[i].getSequenceCount();
            }
            length += alignments[i].getSiteCount();
            ++i;
        }
        char[][] sequences = new char[maxSequence][length];
        int j = 0;
        while (j < sequences.length) {
            int base = 0;
            int i2 = 0;
            while (i2 < alignments.length) {
                int k;
                if (alignments[i2].getSequenceCount() <= j) {
                    k = 0;
                    while (k < alignments[i2].getSiteCount()) {
                        sequences[j][base + k] = 45;
                        ++k;
                    }
                } else {
                    k = 0;
                    while (k < alignments[i2].getSiteCount()) {
                        sequences[j][base + k] = alignments[i2].getData(j, k);
                        ++k;
                    }
                }
                base += alignments[i2].getSiteCount();
                ++i2;
            }
            ++j;
        }
        SimpleAlignment sa = new SimpleAlignment((IdGroup)maxAlignment, sequences, dt);
        return sa;
    }

    public static final char[] getSequenceCharArray(Alignment a, int sequence) {
        char[] cs = new char[a.getSiteCount()];
        int i = 0;
        while (i < cs.length) {
            cs[i] = a.getData(sequence, i);
            ++i;
        }
        return cs;
    }

    public static final String getSequenceString(Alignment a, int sequence) {
        return new String(AlignmentUtils.getSequenceCharArray(a, sequence));
    }

    public static final Alignment getChangedDataType(Alignment a, DataType dt) {
        int numberOfSites = a.getSiteCount();
        boolean[] include = new boolean[numberOfSites];
        int goodSiteCount = 0;
        int i = 0;
        while (i < numberOfSites) {
            include[i] = AlignmentUtils.isGoodSite(a, dt, i);
            if (include[i]) {
                ++goodSiteCount;
            }
            ++i;
        }
        String[] sequences = new String[a.getSequenceCount()];
        int i2 = 0;
        while (i2 < sequences.length) {
            char[] seq = new char[goodSiteCount];
            int count = 0;
            int j = 0;
            while (j < numberOfSites) {
                if (include[j]) {
                    seq[count] = a.getData(i2, j);
                    ++count;
                }
                ++j;
            }
            sequences[i2] = new String(seq);
            ++i2;
        }
        return new SimpleAlignment((IdGroup)new SimpleIdGroup(a), sequences, dt);
    }

    public static final int countUnknowns(Alignment a, DataType dt) {
        int count = 0;
        int i = 0;
        while (i < a.getSequenceCount()) {
            int j = 0;
            while (j < a.getSiteCount()) {
                if (dt.isUnknownState(dt.getState(a.getData(i, j)))) {
                    ++count;
                }
                ++j;
            }
            ++i;
        }
        return count;
    }

    private static final void stripLeadingIncompleteCodon(int[] states, int unknownState) {
        int numberOfCodons = states.length / 3;
        Nucleotides n = Nucleotides.DEFAULT_INSTANCE;
        int codon = 0;
        while (codon < numberOfCodons) {
            int unknownCount = 0;
            int index = codon * 3;
            int i = 0;
            while (i < 3) {
                if (n.isUnknownState(states[index + i])) {
                    ++unknownCount;
                }
                ++i;
            }
            if (unknownCount == 0) {
                return;
            }
            if (unknownCount != 3) {
                int i2 = 0;
                while (i2 < 3) {
                    states[index + i2] = unknownState;
                    ++i2;
                }
            }
            ++codon;
        }
    }

    public static final Alignment getLeadingIncompleteCodonsStripped(Alignment base) {
        DataTranslator dt = new DataTranslator(base);
        Nucleotides n = Nucleotides.DEFAULT_INSTANCE;
        int[][] states = dt.toStates(n, 0);
        int unknownState = n.getRecommendedUnknownState();
        int i = 0;
        while (i < states.length) {
            AlignmentUtils.stripLeadingIncompleteCodon(states[i], unknownState);
            ++i;
        }
        return new SimpleAlignment((IdGroup)base, Nucleotides.DEFAULT_INSTANCE, states);
    }

    private static final void outputChar(PrintWriter out, char c, int number) {
        int i = 0;
        while (i < number) {
            out.print(c);
            ++i;
        }
    }

    private static void printNextSites(Alignment a, PrintWriter out, boolean chunked, int seq, int start, int num) {
        int i = 0;
        while (i < num && start + i < a.getSiteCount()) {
            if (i % 10 == 0 && i != 0 && chunked) {
                out.print(' ');
            }
            out.print(a.getData(seq, start + i));
            ++i;
        }
    }

    private static int getNaturalGapCost(Alignment a, int x, int y, int start, int finish) {
        DataType dt = a.getDataType();
        int totalCost = 0;
        boolean inGap = false;
        int i = start;
        while (i <= finish) {
            if (!dt.isUnknownChar(a.getData(y, i)) || !dt.isUnknownChar(a.getData(x, i))) {
                if (AlignmentUtils.isGap(a, x, i)) {
                    if (!inGap) {
                        ++totalCost;
                        inGap = true;
                    }
                } else {
                    inGap = false;
                }
            }
            ++i;
        }
        return totalCost;
    }

    private static final boolean isGoodSite(Alignment a, DataType dt, int site) {
        int numberOfSequences = a.getSequenceCount();
        int i = 0;
        while (i < numberOfSequences) {
            char c = a.getData(i, site);
            if (c != '-' && dt.isUnknownState(dt.getState(c))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static CostBag getAlignmentPenalty(DataType dt, TransitionPenaltyTable penalties, int[] xindices, int[] yindices, boolean local, int numberOfSites) {
        int start = 0;
        int finish = numberOfSites - 1;
        if (local) {
            while (dt.isUnknownState(yindices[start]) || dt.isUnknownState(xindices[start])) {
                ++start;
            }
            while (dt.isUnknownState(yindices[finish]) || dt.isUnknownState(xindices[finish])) {
                --finish;
            }
        }
        int gapCost = 0;
        int gapExCost = 0;
        double subCosts = 0.0;
        boolean inGap = false;
        int i = start;
        while (i <= finish) {
            boolean xIsGap = dt.isUnknownState(xindices[i]);
            boolean yIsGap = dt.isUnknownState(yindices[i]);
            if (xIsGap) {
                if (!yIsGap) {
                    if (inGap) {
                        ++gapExCost;
                    } else {
                        inGap = true;
                        ++gapCost;
                    }
                }
            } else if (yIsGap) {
                if (inGap) {
                    ++gapExCost;
                } else {
                    inGap = true;
                    ++gapCost;
                }
            } else {
                inGap = false;
                subCosts += penalties.penalty(xindices[i], yindices[i]);
            }
            ++i;
        }
        return new CostBag(gapCost, gapExCost, subCosts);
    }

    public static double getConsistency(Alignment a, Alignment b) {
        ConsistencyBag totalBag = new ConsistencyBag();
        totalBag.matches = 0;
        totalBag.overlap = 0;
        int i = 0;
        while (i < a.getIdCount()) {
            ConsistencyBag curBag = AlignmentUtils.getConsistency(a, b, a.getIdentifier(i).getName());
            totalBag.matches += curBag.matches;
            totalBag.overlap += curBag.overlap;
            ++i;
        }
        return totalBag.consistency();
    }

    private static ConsistencyBag getConsistency(Alignment a, Alignment b, String name) {
        int[][] indices1 = AlignmentUtils.getAlignmentIndices(a);
        int[][] indices2 = AlignmentUtils.getAlignmentIndices(b);
        int homeIndex = a.whichIdNumber(name);
        int awayIndex = b.whichIdNumber(name);
        int totalMatches = 0;
        int totalHomeMatchesPossible = 0;
        int i = 0;
        while (i < a.getIdCount()) {
            if (i != homeIndex) {
                int awayIndex2 = b.whichIdNumber(a.getIdentifier(i).getName());
                if (awayIndex2 != -1) {
                    totalMatches += AlignmentUtils.getAlignmentMatches(indices1, indices2, homeIndex, i, awayIndex, awayIndex2);
                    totalHomeMatchesPossible += AlignmentUtils.getAlignmentMatches(indices1, homeIndex, i);
                } else {
                    throw new RuntimeException("Alignments do not have same taxa!");
                }
            }
            ++i;
        }
        ConsistencyBag bag = new ConsistencyBag(totalMatches, totalHomeMatchesPossible);
        return bag;
    }

    private static int[][] getAlignmentIndices(Alignment a) {
        int[][] indices = new int[a.getIdCount()][a.getSiteCount()];
        DataType dataType = a.getDataType();
        int i = 0;
        while (i < a.getIdCount()) {
            int seqcounter = 0;
            int j = 0;
            while (j < a.getSiteCount()) {
                int index = dataType.getState(a.getData(i, j));
                indices[i][j] = index != dataType.getNumStates() ? seqcounter++ : -1;
                ++j;
            }
            ++i;
        }
        return indices;
    }

    private static int getAlignmentMatches(int[][] indices, int seqa, int seqb) {
        int matches = 0;
        int i = 0;
        while (i < indices[seqa].length) {
            if (indices[seqa][i] != -1 && indices[seqb][i] != -1) {
                ++matches;
            }
            ++i;
        }
        return matches;
    }

    /*
     * Unable to fully structure code
     */
    private static int getAlignmentMatches(int[][] indices1, int[][] indices2, int seqa1, int seqb1, int seqa2, int seqb2) {
        matches = 0;
        counter2 = 0;
        i = 0;
        while (i < indices1[0].length) {
            if (indices1[seqa1][i] != -1 && indices1[seqb1][i] != -1) {
                block8: {
                    try {
                        while (indices2[seqa2][counter2] != indices1[seqa1][i]) {
                            ++counter2;
                        }
                        break block8;
                    }
                    catch (ArrayIndexOutOfBoundsException ae) {
                        j = 0;
                        ** while (j < indices1[0].length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        System.out.println("indice1[" + j + "]" + indices1[seqa1][j]);
                        ++j;
                        continue;
                    }
lbl17:
                    // 1 sources

                    j = 0;
                    while (j < indices2[0].length) {
                        System.out.println("indice2[" + j + "]" + indices2[seqa2][j]);
                        ++j;
                    }
                    System.out.println("indices1[" + seqa1 + "][" + i + "] = " + indices1[seqa1][i] + "\tindices2[" + seqa2 + "][" + (counter2 - 1) + "] = " + indices2[seqa2][counter2 - 1]);
                    System.out.println("counter2 = " + counter2);
                }
                if (indices1[seqb1][i] == indices2[seqb2][counter2]) {
                    ++matches;
                }
            }
            ++i;
        }
        return matches;
    }

    private static class CharacterCM
    implements CharacterMatrix {
        char[][] sequences_;

        public CharacterCM(char[][] sequences) {
            this.sequences_ = sequences;
        }

        public int getSequenceCount() {
            return this.sequences_.length;
        }

        public int getSiteCount() {
            return this.sequences_[0].length;
        }

        public char getData(int sequence, int site) {
            return this.sequences_[sequence][site];
        }
    }

    private static class StringCM
    implements CharacterMatrix {
        String[] sequences_;

        public StringCM(String[] sequences) {
            this.sequences_ = sequences;
        }

        public int getSequenceCount() {
            return this.sequences_.length;
        }

        public int getSiteCount() {
            return this.sequences_[0].length();
        }

        public char getData(int sequence, int site) {
            return this.sequences_[sequence].charAt(site);
        }
    }

    private static class AlignmentCM
    implements CharacterMatrix {
        Alignment a_;

        public AlignmentCM(Alignment a) {
            this.a_ = a;
        }

        public int getSequenceCount() {
            return this.a_.getSequenceCount();
        }

        public int getSiteCount() {
            return this.a_.getSiteCount();
        }

        public char getData(int sequence, int site) {
            return this.a_.getData(sequence, site);
        }
    }

    private static interface CharacterMatrix {
        public int getSequenceCount();

        public int getSiteCount();

        public char getData(int var1, int var2);
    }
}

