/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import pal.alignment.Alignment;
import pal.alignment.SimpleAlignment;
import pal.datatype.DataType;
import pal.misc.IdGroup;
import pal.misc.Identifier;
import pal.misc.SimpleIdGroup;

public class AlignmentBuilder {
    private Sequence[] store_;
    private int numberOfSequencesInStore_;

    public AlignmentBuilder(int initialCapacity) {
        this.store_ = new Sequence[initialCapacity];
        this.numberOfSequencesInStore_ = 0;
    }

    public void clearAll() {
        int i = 0;
        while (i < this.numberOfSequencesInStore_) {
            this.store_[i] = null;
            ++i;
        }
        this.numberOfSequencesInStore_ = 0;
    }

    private final Identifier[] generateIdentifiers() {
        Identifier[] ids = new Identifier[this.numberOfSequencesInStore_];
        int i = 0;
        while (i < this.numberOfSequencesInStore_) {
            ids[i] = this.store_[i].generateIdentifier();
            ++i;
        }
        return ids;
    }

    private final int[][] generateStateData() {
        int[][] data = new int[this.numberOfSequencesInStore_][];
        int i = 0;
        while (i < this.numberOfSequencesInStore_) {
            data[i] = this.store_[i].getStates();
            ++i;
        }
        return data;
    }

    public Alignment generateAlignment(DataType dt) {
        Identifier[] ids = this.generateIdentifiers();
        int[][] stateData = this.generateStateData();
        return new SimpleAlignment((IdGroup)new SimpleIdGroup(ids), dt, stateData);
    }

    private final void ensureSpace(int requiredSize) {
        if (requiredSize >= this.store_.length) {
            Sequence[] newStore = new Sequence[requiredSize + 5];
            System.arraycopy(this.store_, 0, newStore, 0, this.numberOfSequencesInStore_);
            this.store_ = newStore;
        }
    }

    public void addSequence(int[] states, String name) {
        this.ensureSpace(this.numberOfSequencesInStore_ + 1);
        this.store_[this.numberOfSequencesInStore_++] = new Sequence(states, name);
    }

    private static final class Sequence {
        private final int[] states_;
        private final String name_;

        public Sequence(int[] states, String name) {
            this.states_ = states;
            this.name_ = name;
        }

        public Identifier generateIdentifier() {
            return new Identifier(this.name_);
        }

        public int[] getStates() {
            return this.states_;
        }
    }
}

