/*
 * Decompiled with CFR 0.152.
 */
package pal.algorithmics;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import pal.util.AlgorithmCallback;

public interface StoppingCriteria
extends Serializable {
    public boolean isTimeToStop();

    public double getRelativeStoppingRatio();

    public void newIteration(double var1, double var3, boolean var5, boolean var6, AlgorithmCallback var7);

    public void reset();

    public static class Utils {
        public static final Factory getIterationCount(int maxIterationCount) {
            return new IterationCountSC.SCFactory(maxIterationCount);
        }

        public static final Factory getUnchangedScore(int maxIterationCountAtCurrentScore, boolean matchBestScore) {
            return new UnchangedScoreSC.SCFactory(maxIterationCountAtCurrentScore, matchBestScore);
        }

        public static final Factory getNonExactUnchangedScore(int maxIterationCountAtCurrentScore, boolean matchBestScore, double tolerance) {
            return new NonExactUnchangedScoreSC.SCFactory(maxIterationCountAtCurrentScore, matchBestScore, tolerance);
        }

        public static final Factory getCombined(Factory[] subCriteria) {
            return new CombinedSC.SCFactory(subCriteria);
        }

        private static class NonExactUnchangedScoreSC
        implements StoppingCriteria {
            private int count_ = 0;
            private int maxIterationCountAtCurrentScore_;
            private double lastScore_;
            private boolean matchBestScore_;
            private double tolerance_;
            private static final long serialVersionUID = -56982234429L;

            private void writeObject(ObjectOutputStream out) throws IOException {
                out.writeByte(1);
                out.writeInt(this.count_);
                out.writeInt(this.maxIterationCountAtCurrentScore_);
                out.writeDouble(this.lastScore_);
                out.writeBoolean(this.matchBestScore_);
                out.writeDouble(this.tolerance_);
            }

            private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
                byte version = in.readByte();
                switch (version) {
                    default: 
                }
                this.count_ = in.readInt();
                this.maxIterationCountAtCurrentScore_ = in.readInt();
                this.lastScore_ = in.readDouble();
                this.matchBestScore_ = in.readBoolean();
                this.tolerance_ = in.readDouble();
            }

            public NonExactUnchangedScoreSC(int maxIterationCountAtCurrentScore, boolean matchBestScore, double tolerance) {
                this.maxIterationCountAtCurrentScore_ = maxIterationCountAtCurrentScore;
                this.tolerance_ = tolerance;
                this.matchBestScore_ = matchBestScore;
            }

            public void reset() {
                this.count_ = 0;
            }

            public boolean isTimeToStop() {
                return this.count_ >= this.maxIterationCountAtCurrentScore_;
            }

            public double getRelativeStoppingRatio() {
                return (double)this.count_ / (double)this.maxIterationCountAtCurrentScore_;
            }

            public void newIteration(double currentScore, double bestScore, boolean maximising, boolean externalStablized, AlgorithmCallback callback) {
                if (!externalStablized) {
                    return;
                }
                if (this.count_ == 0) {
                    this.lastScore_ = this.matchBestScore_ ? bestScore : currentScore;
                } else if (this.matchBestScore_) {
                    if (!maximising && bestScore < this.lastScore_ - this.tolerance_ || maximising && bestScore > this.lastScore_ + this.tolerance_) {
                        this.lastScore_ = bestScore;
                        this.count_ = 0;
                    }
                } else if (Math.abs(this.lastScore_ - currentScore) > this.tolerance_) {
                    this.lastScore_ = currentScore;
                    this.count_ = 0;
                }
                ++this.count_;
            }

            static class SCFactory
            implements Factory {
                private int maxIterationCountAtCurrentScore_;
                private boolean matchBestScore_;
                private double tolerance_;
                private static final long serialVersionUID = -4523982234429L;

                private void writeObject(ObjectOutputStream out) throws IOException {
                    out.writeByte(1);
                    out.writeInt(this.maxIterationCountAtCurrentScore_);
                    out.writeBoolean(this.matchBestScore_);
                    out.writeDouble(this.tolerance_);
                }

                private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
                    byte version = in.readByte();
                    switch (version) {
                        default: 
                    }
                    this.maxIterationCountAtCurrentScore_ = in.readInt();
                    this.matchBestScore_ = in.readBoolean();
                    this.tolerance_ = in.readDouble();
                }

                public SCFactory(int maxIterationCountAtCurrentScore, boolean matchBestScore, double tolerance) {
                    this.maxIterationCountAtCurrentScore_ = maxIterationCountAtCurrentScore;
                    this.matchBestScore_ = matchBestScore;
                    this.tolerance_ = tolerance;
                }

                public StoppingCriteria newInstance() {
                    return new NonExactUnchangedScoreSC(this.maxIterationCountAtCurrentScore_, this.matchBestScore_, this.tolerance_);
                }
            }
        }

        private static class UnchangedScoreSC
        implements StoppingCriteria {
            private int count_ = 0;
            private int maxIterationCountAtCurrentScore_;
            private double lastScore_;
            private boolean matchBestScore_;
            private static final long serialVersionUID = -3242345529L;

            private void writeObject(ObjectOutputStream out) throws IOException {
                out.writeByte(1);
                out.writeInt(this.count_);
                out.writeInt(this.maxIterationCountAtCurrentScore_);
                out.writeDouble(this.lastScore_);
                out.writeBoolean(this.matchBestScore_);
            }

            private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
                byte version = in.readByte();
                switch (version) {
                    default: 
                }
                this.count_ = in.readInt();
                this.maxIterationCountAtCurrentScore_ = in.readInt();
                this.lastScore_ = in.readDouble();
                this.matchBestScore_ = in.readBoolean();
            }

            public UnchangedScoreSC(int maxIterationCountAtCurrentScore, boolean matchBestScore) {
                this.maxIterationCountAtCurrentScore_ = maxIterationCountAtCurrentScore;
                this.matchBestScore_ = matchBestScore;
            }

            public void reset() {
                this.count_ = 0;
            }

            public double getRelativeStoppingRatio() {
                return (double)this.count_ / (double)this.maxIterationCountAtCurrentScore_;
            }

            public boolean isTimeToStop() {
                return this.count_ >= this.maxIterationCountAtCurrentScore_;
            }

            public void newIteration(double currentScore, double bestScore, boolean maximising, boolean externalStablized, AlgorithmCallback callback) {
                if (!externalStablized) {
                    return;
                }
                if (this.count_ == 0) {
                    this.lastScore_ = this.matchBestScore_ ? bestScore : currentScore;
                } else if (this.matchBestScore_) {
                    if (!maximising && bestScore < this.lastScore_ || maximising && bestScore > this.lastScore_) {
                        this.lastScore_ = bestScore;
                        this.count_ = 0;
                    }
                } else if (this.lastScore_ != currentScore) {
                    this.lastScore_ = currentScore;
                    this.count_ = 0;
                    callback.updateStatus("Restarting count...");
                }
                ++this.count_;
            }

            static class SCFactory
            implements Factory {
                private int maxIterationCountAtCurrentScore_;
                private boolean matchBestScore_;
                private static final long serialVersionUID = -1234567785529L;

                private void writeObject(ObjectOutputStream out) throws IOException {
                    out.writeByte(1);
                    out.writeInt(this.maxIterationCountAtCurrentScore_);
                    out.writeBoolean(this.matchBestScore_);
                }

                private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
                    byte version = in.readByte();
                    switch (version) {
                        default: 
                    }
                    this.maxIterationCountAtCurrentScore_ = in.readInt();
                    this.matchBestScore_ = in.readBoolean();
                }

                public SCFactory(int maxIterationCountAtCurrentScore, boolean matchBestScore) {
                    this.maxIterationCountAtCurrentScore_ = maxIterationCountAtCurrentScore;
                    this.matchBestScore_ = matchBestScore;
                }

                public StoppingCriteria newInstance() {
                    return new UnchangedScoreSC(this.maxIterationCountAtCurrentScore_, this.matchBestScore_);
                }
            }
        }

        private static class CombinedSC
        implements StoppingCriteria {
            private StoppingCriteria[] subCriteria_;
            private static final long serialVersionUID = -847823472529L;

            private void writeObject(ObjectOutputStream out) throws IOException {
                out.writeByte(1);
                out.writeObject(this.subCriteria_);
            }

            private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
                byte version = in.readByte();
                switch (version) {
                    default: 
                }
                this.subCriteria_ = (StoppingCriteria[])in.readObject();
            }

            public CombinedSC(StoppingCriteria[] subCriteria) {
                this.subCriteria_ = subCriteria;
            }

            public void reset() {
                int i = 0;
                while (i < this.subCriteria_.length) {
                    this.subCriteria_[i].reset();
                    ++i;
                }
            }

            public double getRelativeStoppingRatio() {
                double max = 0.0;
                int i = 0;
                while (i < this.subCriteria_.length) {
                    max = Math.max(max, this.subCriteria_[i].getRelativeStoppingRatio());
                    ++i;
                }
                return max;
            }

            public boolean isTimeToStop() {
                int i = 0;
                while (i < this.subCriteria_.length) {
                    if (this.subCriteria_[i].isTimeToStop()) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            public void newIteration(double currentScore, double bestScore, boolean maximising, boolean externalStablized, AlgorithmCallback callback) {
                int i = 0;
                while (i < this.subCriteria_.length) {
                    this.subCriteria_[i].newIteration(currentScore, bestScore, maximising, externalStablized, callback);
                    ++i;
                }
            }

            static class SCFactory
            implements Factory {
                Factory[] subCriteria_;
                private static final long serialVersionUID = -525566345529L;

                private void writeObject(ObjectOutputStream out) throws IOException {
                    out.writeByte(1);
                    out.writeObject(this.subCriteria_);
                }

                private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
                    byte version = in.readByte();
                    switch (version) {
                        default: 
                    }
                    this.subCriteria_ = (Factory[])in.readObject();
                }

                public SCFactory(Factory[] subCriteria) {
                    this.subCriteria_ = subCriteria;
                }

                public StoppingCriteria newInstance() {
                    StoppingCriteria[] subs = new StoppingCriteria[this.subCriteria_.length];
                    int i = 0;
                    while (i < subs.length) {
                        subs[i] = this.subCriteria_[i].newInstance();
                        ++i;
                    }
                    return new CombinedSC(subs);
                }
            }
        }

        private static class IterationCountSC
        implements StoppingCriteria {
            int count_ = 0;
            int maxIterationCount_;
            private static final long serialVersionUID = -883722345529L;

            private void writeObject(ObjectOutputStream out) throws IOException {
                out.writeByte(1);
                out.writeInt(this.count_);
                out.writeInt(this.maxIterationCount_);
            }

            private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
                byte version = in.readByte();
                switch (version) {
                    default: 
                }
                this.count_ = in.readInt();
                this.maxIterationCount_ = in.readInt();
            }

            public IterationCountSC(int maxIterationCount) {
                this.maxIterationCount_ = maxIterationCount;
            }

            public void reset() {
                this.count_ = 0;
            }

            public double getRelativeStoppingRatio() {
                return (double)this.count_ / (double)this.maxIterationCount_;
            }

            public boolean isTimeToStop() {
                return this.count_ >= this.maxIterationCount_;
            }

            public void newIteration(double currentScore, double bestScore, boolean maximising, boolean externalStablized, AlgorithmCallback callback) {
                ++this.count_;
                callback.updateProgress((double)this.count_ / (double)this.maxIterationCount_);
            }

            private static class SCFactory
            implements Factory {
                private int maxIterationCount_;
                private static final long serialVersionUID = -552478345529L;

                private void writeObject(ObjectOutputStream out) throws IOException {
                    out.writeByte(1);
                    out.writeInt(this.maxIterationCount_);
                }

                private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
                    byte version = in.readByte();
                    switch (version) {
                        default: 
                    }
                    this.maxIterationCount_ = in.readInt();
                }

                public SCFactory(int maxIterationCount) {
                    this.maxIterationCount_ = maxIterationCount;
                }

                public StoppingCriteria newInstance() {
                    return new IterationCountSC(this.maxIterationCount_);
                }
            }
        }
    }

    public static interface Factory
    extends Serializable {
        public StoppingCriteria newInstance();
    }
}

