/*
 * Decompiled with CFR 0.152.
 */
package pal.algorithmics;

public interface ProbabilityIterator {
    public double getNextProbability(double var1, double var3, boolean var5);

    public boolean isStablised();

    public static class Utils {
        public static final Factory getConstant(double value) {
            return new Constant.PIFactory(value);
        }

        public static final Factory getHillClimb() {
            return new HillClimb.PIFactory();
        }

        public static final Factory getBoltzman(double initialTemperature, double temperatureDecay, int chainLength) {
            return new Boltzman.PIFactory(initialTemperature, temperatureDecay, chainLength);
        }

        private static class Boltzman
        implements ProbabilityIterator {
            double initialTemperature_;
            double temperatureDecay_;
            int chainLength_;
            double k_ = 1.0;
            double currentTemperature_;
            int chainPosition_;

            public Boltzman(double initialTemperature, double temperatureDecay, int chainLength) {
                this.initialTemperature_ = initialTemperature;
                this.temperatureDecay_ = temperatureDecay;
                this.chainLength_ = chainLength;
                this.currentTemperature_ = this.initialTemperature_;
                this.chainPosition_ = 0;
            }

            public boolean isStablised() {
                return this.currentTemperature_ < 0.005;
            }

            public double getNextProbability(double currentValue, double newValue, boolean maximising) {
                double toReturn = maximising ? (newValue > currentValue ? 1.0 : Math.exp(-(currentValue - newValue) / (this.k_ * this.currentTemperature_))) : (newValue < currentValue ? 1.0 : Math.exp(-(newValue - currentValue) / (this.k_ * this.currentTemperature_)));
                ++this.chainPosition_;
                if (this.chainPosition_ == this.chainLength_) {
                    this.chainPosition_ = 0;
                    this.currentTemperature_ *= this.temperatureDecay_;
                    System.out.println("****:" + this.currentTemperature_);
                }
                return toReturn;
            }

            static class PIFactory
            implements Factory {
                double initialTemperature_;
                double temperatureDecay_;
                int chainLength_;

                public PIFactory(double initialTemperature, double temperatureDecay, int chainLength) {
                    this.initialTemperature_ = initialTemperature;
                    this.temperatureDecay_ = temperatureDecay;
                    this.chainLength_ = chainLength;
                }

                public ProbabilityIterator newInstance() {
                    return new Boltzman(this.initialTemperature_, this.temperatureDecay_, this.chainLength_);
                }
            }
        }

        private static class HillClimb
        implements ProbabilityIterator {
            private HillClimb() {
            }

            public double getNextProbability(double currentBest, double testValue, boolean maximising) {
                if (maximising) {
                    return testValue >= currentBest ? 1 : 0;
                }
                return testValue <= currentBest ? 1 : 0;
            }

            public boolean isStablised() {
                return true;
            }

            static class PIFactory
            implements Factory {
                private static final HillClimb INSTANCE = new HillClimb();

                PIFactory() {
                }

                public ProbabilityIterator newInstance() {
                    return INSTANCE;
                }
            }
        }

        private static class Constant
        implements ProbabilityIterator {
            double value_;

            public Constant(double value) {
                this.value_ = value;
            }

            public double getNextProbability(double currentBest, double testValue, boolean maximising) {
                return this.value_;
            }

            public boolean isStablised() {
                return true;
            }

            static class PIFactory
            implements Factory {
                Constant intstance_;

                public PIFactory(double value) {
                    this.intstance_ = new Constant(value);
                }

                public ProbabilityIterator newInstance() {
                    return this.intstance_;
                }
            }
        }
    }

    public static interface Factory {
        public ProbabilityIterator newInstance();
    }
}

