/*
 * Decompiled with CFR 0.152.
 */
package xdev.niodev;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public class ConfigReader {
    private BufferedReader bufferedReader = null;
    URL aURL = null;
    InputStream in = null;
    private String delimiter = null;
    private int numberOfHosts = 0;
    int count = 1;
    String fileName = null;

    public ConfigReader(String fileName) throws IOException, FileNotFoundException, MalformedURLException {
        this.fileName = fileName;
        if (fileName.startsWith("http://")) {
            try {
                this.aURL = new URL(new String(fileName));
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
                System.exit(0);
            }
            try {
                this.in = this.aURL.openStream();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(0);
            }
            this.bufferedReader = new BufferedReader(new InputStreamReader(this.in));
        } else {
            try {
                this.bufferedReader = new BufferedReader(new FileReader(this.fileName));
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("File Not Found Exception" + this.fileName);
                System.out.println("Please locate and Make sure that the appropriate configuration file is lying in the appropriate directory .....");
                System.exit(0);
            }
        }
    }

    public String readNoOfProc() throws IOException {
        String temp = null;
        boolean loop = true;
        while (loop) {
            try {
                temp = this.bufferedReader.readLine();
            }
            catch (IOException ioe) {
                System.out.println("Problem reading the config file" + this.fileName);
                System.exit(0);
            }
            if (temp == null || temp.equals("") || temp.startsWith("#")) continue;
            temp = temp.trim();
            this.numberOfHosts = new Integer(temp);
            loop = false;
        }
        return temp;
    }

    public String readIntAsString() throws IOException {
        String temp = null;
        boolean loop = true;
        while (loop) {
            try {
                temp = this.bufferedReader.readLine();
            }
            catch (IOException ioe) {
                System.out.println("Problem reading the config file" + this.fileName);
                System.exit(0);
            }
            if (temp == null || temp.equals("") || temp.startsWith("#")) continue;
            temp = temp.trim();
            loop = false;
        }
        return temp;
    }

    public String readLine() throws IOException {
        String temp;
        if (this.count > this.numberOfHosts) {
            return null;
        }
        try {
            temp = this.bufferedReader.readLine();
        }
        catch (IOException ioe) {
            System.out.println("IOException");
            ioe.printStackTrace();
            return null;
        }
        if (temp == null || temp.equals("")) {
            System.out.println("empty or whitespace");
            return "empty";
        }
        if (temp.startsWith("#")) {
            return "#";
        }
        temp = temp.trim();
        ++this.count;
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.bufferedReader.close();
            this.in.close();
        }
        catch (Exception exception) {
        }
        finally {
            this.bufferedReader = null;
            this.aURL = null;
            this.in = null;
        }
    }

    public static void main(String[] args) throws Exception {
        String CONFIGURATION_FILE = new String("mpjdev.conf");
        int NUMBER_OF_HOSTS = 0;
        ConfigReader reader = new ConfigReader(CONFIGURATION_FILE);
        NUMBER_OF_HOSTS = new Integer(reader.readNoOfProc());
        System.out.println("NUMBER_OF_HOSTS " + NUMBER_OF_HOSTS);
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.equals("empty") || line.equals("#")) continue;
            line = line.trim();
            StringTokenizer tokenizer = new StringTokenizer(line, "@");
            System.out.println("Node<" + tokenizer.nextToken() + ">");
            System.out.println("Num<" + tokenizer.nextToken() + ">");
        }
        reader.close();
    }
}

