/*
 * Decompiled with CFR 0.152.
 */
package xdev.mxdev;

import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.UUID;
import mpi.ProcTree;
import mpjbuf.Buffer;
import mpjbuf.BufferFactory;
import mpjbuf.Type;
import mpjdev.Request;
import mpjdev.Status;
import xdev.Device;
import xdev.ProcessID;
import xdev.XDevException;
import xdev.mxdev.MXProcessID;
import xdev.mxdev.MXRecvRequest;
import xdev.mxdev.MXRequest;
import xdev.mxdev.MXSendRequest;
import xdev.niodev.ConfigReader;

public class MXDevice
implements Device {
    int rank;
    int nprocs = 0;
    int SEND_OVERHEAD;
    int RECV_OVERHEAD;
    String[] processNames = null;
    int[] ranks = null;
    ProcTree procTree;
    int index;
    int root;
    int extent;
    int places;
    MXProcessID[] pids;
    Device nioDevice;
    static HashMap<Long, MXRequest> requestMap = new HashMap();

    @Override
    public ProcessID[] init(String[] args) throws XDevException {
        this.rank = Integer.parseInt(args[0]);
        this.SEND_OVERHEAD = this.getSendOverhead();
        this.RECV_OVERHEAD = this.getRecvOverhead();
        ConfigReader reader = null;
        try {
            reader = new ConfigReader(args[1]);
            this.nprocs = new Integer(reader.readNoOfProc());
            int psl = new Integer(reader.readIntAsString());
        }
        catch (Exception config_error) {
            throw new XDevException(config_error);
        }
        int count = 0;
        this.processNames = new String[this.nprocs];
        this.ranks = new int[this.nprocs];
        this.pids = new MXProcessID[this.nprocs];
        while (count < this.nprocs) {
            String line = null;
            try {
                line = reader.readLine();
            }
            catch (IOException ioe) {
                throw new XDevException(ioe);
            }
            if (line == null || line.equals("") || line.equals("#")) continue;
            line = line.trim();
            StringTokenizer tokenizer = new StringTokenizer(line, "@");
            this.processNames[count] = tokenizer.nextToken();
            this.processNames[count] = this.processNames[count] + ":" + tokenizer.nextToken();
            this.ranks[count] = new Integer(tokenizer.nextToken());
            ++count;
        }
        reader.close();
        this.index = this.rank;
        this.root = 0;
        this.procTree = new ProcTree();
        this.extent = this.nprocs;
        this.places = 4 * this.index;
        for (int i = 1; i <= 4; ++i) {
            ++this.places;
            int ch = 4 * this.index + i + this.root;
            ch %= this.extent;
            if (this.places >= this.extent) continue;
            this.procTree.child[i - 1] = ch;
            ++this.procTree.numChildren;
        }
        if (this.index == this.root) {
            this.procTree.isRoot = true;
        } else {
            int pr;
            this.procTree.isRoot = false;
            this.procTree.parent = pr = (this.index - 1) / 4;
        }
        this.procTree.root = this.root;
        System.loadLibrary("mxdev");
        this.pids[this.rank] = new MXProcessID(UUID.randomUUID());
        UUID myUUID = this.pids[this.rank].uuid();
        long msb = myUUID.getMostSignificantBits();
        long lsb = myUUID.getLeastSignificantBits();
        this.nativeInit(args, this.rank, this.processNames, this.ranks, this.nprocs, this.pids, msb, lsb);
        this.barrier();
        return this.pids;
    }

    @Override
    public int getSendOverhead() {
        return 8;
    }

    @Override
    public int getRecvOverhead() {
        return 8;
    }

    @Override
    public ProcessID id() {
        return this.pids[this.rank];
    }

    private void barrier() {
        int offset = 0;
        int[] data = new int[1];
        int count = 1;
        int btag = 34000;
        int context = 50;
        Buffer sbuf = new Buffer(BufferFactory.create(23 + this.SEND_OVERHEAD), this.SEND_OVERHEAD, 23 + this.SEND_OVERHEAD);
        Buffer rbuf = new Buffer(BufferFactory.create(16 + this.RECV_OVERHEAD), this.RECV_OVERHEAD, this.RECV_OVERHEAD + 16);
        if (this.procTree.numChildren == -1 || !this.procTree.isRoot) {
            try {
                sbuf.putSectionHeader(Type.INT);
                sbuf.write(data, offset, count);
                sbuf.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.procTree.isRoot) {
            for (int i = 0; i < this.procTree.child.length; ++i) {
                if (this.procTree.child[i] == -1) continue;
                this.recv(rbuf, this.pids[this.procTree.child[i]], btag, context);
                try {
                    rbuf.clear();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        } else {
            if (this.procTree.parent == -1) {
                System.out.println("non root's node parent doesn't exist");
            }
            for (int i = 0; i < this.procTree.child.length; ++i) {
                if (this.procTree.child[i] == -1) continue;
                this.recv(rbuf, this.pids[this.procTree.child[i]], btag, context);
                try {
                    rbuf.clear();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.send(sbuf, this.pids[this.procTree.parent], btag, context);
        }
        if (this.procTree.isRoot) {
            // empty if block
        }
        BufferFactory.destroy(sbuf.getStaticBuffer());
        BufferFactory.destroy(rbuf.getStaticBuffer());
    }

    @Override
    public void finish() throws XDevException {
        this.barrier();
        this.nativeFinish();
    }

    @Override
    public Request isend(Buffer buf, ProcessID dstID, int tag, int context) throws XDevException {
        MXSendRequest sendRequest = new MXSendRequest();
        int staticBufferLength = buf.getSize();
        int offset = buf.offset();
        int dynamicBufferLength = buf.getDynamicBuffer() != null ? buf.getDynamicBuffer().length : 0;
        this.nativeIsend(buf, dstID, tag, context, staticBufferLength, dynamicBufferLength, sendRequest, offset);
        requestMap.put(new Long(sendRequest.handle), sendRequest);
        return sendRequest;
    }

    @Override
    public void send(Buffer buf, ProcessID dstID, int tag, int context) throws XDevException {
        int staticBufferLength = buf.getSize();
        int offset = buf.offset();
        int dynamicBufferLength = buf.getDynamicBuffer() != null ? buf.getDynamicBuffer().length : 0;
        this.nativeSend(buf, dstID, tag, context, staticBufferLength, dynamicBufferLength);
    }

    @Override
    public Request issend(Buffer buf, ProcessID dstID, int tag, int context) throws XDevException {
        MXSendRequest sendRequest = new MXSendRequest();
        int staticBufferLength = buf.getSize();
        int dynamicBufferLength = buf.getDynamicBuffer() != null ? buf.getDynamicBuffer().length : 0;
        this.nativeIssend(buf, dstID, tag, context, staticBufferLength, dynamicBufferLength, sendRequest);
        requestMap.put(new Long(sendRequest.handle), sendRequest);
        return sendRequest;
    }

    @Override
    public void ssend(Buffer buf, ProcessID dstID, int tag, int context) throws XDevException {
        int staticBufferLength = buf.getSize();
        int dynamicBufferLength = buf.getDynamicBuffer() != null ? buf.getDynamicBuffer().length : 0;
        this.nativeSsend(buf, dstID, tag, context, staticBufferLength, dynamicBufferLength);
    }

    @Override
    public Status recv(Buffer buf, ProcessID srcID, int tag, int context) throws XDevException {
        Status status = new Status();
        int ANY_SRC = 0;
        if (srcID.uuid().equals(Device.ANY_SRC.uuid())) {
            ANY_SRC = 1;
        }
        this.nativeRecv(buf, srcID, tag, context, status, ANY_SRC);
        status.srcID = this.pids[status.source].uuid();
        try {
            buf.commit();
            status.type = buf.getSectionHeader();
            status.numEls = buf.getSectionSize();
        }
        catch (Exception e) {
            throw new XDevException(e);
        }
        return status;
    }

    @Override
    public Request irecv(Buffer buf, ProcessID srcID, int tag, int context, Status status) throws XDevException {
        MXRecvRequest recvRequest = new MXRecvRequest(this);
        int ANY_SRC = 0;
        if (srcID.uuid().equals(Device.ANY_SRC.uuid())) {
            ANY_SRC = 1;
        }
        recvRequest.status = new Status();
        this.nativeIrecv(buf, srcID, tag, context, status, recvRequest, ANY_SRC);
        requestMap.put(new Long(recvRequest.handle), recvRequest);
        return recvRequest;
    }

    @Override
    public Status probe(ProcessID srcID, int tag, int context) throws XDevException {
        Status status = new Status();
        int ANY_SRC = 0;
        if (srcID.uuid().equals(Device.ANY_SRC.uuid())) {
            ANY_SRC = 1;
        }
        this.nativeProbe(srcID, tag, context, status, ANY_SRC);
        status.srcID = this.pids[status.source].uuid();
        return status;
    }

    @Override
    public Status iprobe(ProcessID srcID, int tag, int context) throws XDevException {
        Status status = new Status();
        int ANY_SRC = 0;
        if (srcID.uuid().equals(Device.ANY_SRC.uuid())) {
            ANY_SRC = 1;
        }
        int isCompleted = 0;
        if ((isCompleted = this.nativeIprobe(srcID, tag, context, status, ANY_SRC, isCompleted)) == 1) {
            status.srcID = this.pids[status.source].uuid();
        }
        return isCompleted == 1 ? status : null;
    }

    @Override
    public Request peek() throws XDevException {
        Status completedStatus = new Status();
        long natPeekedReqHandle = this.nativePeek(completedStatus);
        MXRequest peekedRequest = requestMap.get(new Long(natPeekedReqHandle));
        return peekedRequest;
    }

    native void nativeInit(String[] var1, int var2, String[] var3, int[] var4, int var5, MXProcessID[] var6, long var7, long var9);

    native void nativeIsend(Buffer var1, ProcessID var2, int var3, int var4, int var5, int var6, MXSendRequest var7, int var8);

    native void nativeSend(Buffer var1, ProcessID var2, int var3, int var4, int var5, int var6);

    native void nativeIssend(Buffer var1, ProcessID var2, int var3, int var4, int var5, int var6, MXSendRequest var7);

    native void nativeSsend(Buffer var1, ProcessID var2, int var3, int var4, int var5, int var6);

    native void nativeIrecv(Buffer var1, ProcessID var2, int var3, int var4, Status var5, MXRecvRequest var6, int var7);

    native void nativeRecv(Buffer var1, ProcessID var2, int var3, int var4, Status var5, int var6);

    native void nativeProbe(ProcessID var1, int var2, int var3, Status var4, int var5);

    native int nativeIprobe(ProcessID var1, int var2, int var3, Status var4, int var5, int var6);

    native long nativePeek(Status var1);

    static native void deletePeekedRequest(MXRequest var0, long var1);

    native void nativeFinish();
}

