/*
 * Decompiled with CFR 0.152.
 */
package mpjbuf;

import mpi.MPIException;
import mpjbuf.Buddy1BufferFactory;
import mpjbuf.Buddy2BufferFactory;
import mpjbuf.RawBuffer;

public abstract class BufferFactory {
    static BufferFactory factory;

    public static void init(String str) {
        if (str.equals("Buddy1")) {
            if (factory == null) {
                factory = new Buddy1BufferFactory();
                factory.init();
            } else {
                System.out.println(" attempt to initialize bufferFactory again with strategy represented by string <" + str + ">");
            }
        } else if (str.equals("Buddy2")) {
            if (factory == null) {
                factory = new Buddy2BufferFactory();
                factory.init();
            } else {
                System.out.println(" attempt to initialize bufferFactory again with strategy represented by string <" + str + ">");
            }
        } else {
            throw new MPIException(" No matching buffering strategy for <" + str + ">");
        }
    }

    public static RawBuffer create(int size) {
        if (factory != null) {
            return factory.createBuffer(size);
        }
        throw new MPIException("BufferFactory has not been initialized");
    }

    public static void destroy(RawBuffer buffer) {
        if (factory == null) {
            throw new MPIException("BufferFactory has not been initialized");
        }
        factory.destroyBuffer(buffer);
    }

    public static boolean initialized() {
        return factory != null;
    }

    public static void shut() {
        if (factory != null) {
            factory.finalixe();
        }
        factory = null;
    }

    public abstract void init();

    public abstract void finalixe();

    public abstract void destroyBuffer(RawBuffer var1);

    public abstract RawBuffer createBuffer(int var1);

    static {
        BufferFactory.init("Buddy1");
    }
}

