/*
 * Decompiled with CFR 0.152.
 */
package mpjbuf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import mpjbuf.BufferException;
import mpjbuf.BufferOverflowException;
import mpjbuf.BufferUnderflowException;
import mpjbuf.CustomObjectInputStream;
import mpjbuf.DynamicBufferException;
import mpjbuf.IllegalArgumentException;
import mpjbuf.NIOBuffer;
import mpjbuf.RawBuffer;
import mpjbuf.SectionSizeMismatchException;
import mpjbuf.Type;
import mpjbuf.TypeMismatchException;
import mpjbuf.WrongStateException;

public class Buffer {
    public static final int SECTION_OVERHEAD = 8;
    public static final int ALIGNMENT_UNIT = 8;
    private static final ByteOrder localEncoding = ByteOrder.nativeOrder();
    private int capacity;
    private ByteOrder encoding;
    private boolean freed;
    private boolean writeable;
    private Type currentSectionType;
    private int size;
    private int bufoffset;
    private int sectionHeader;
    private int sectionSize;
    private int readPtr;
    private int elementsRemaining;
    private ByteArrayOutputStream byteOut;
    private ObjectOutputStream out;
    private ObjectInputStream in;
    private byte[] dynamicBuffer;
    private RawBuffer staticBuffer;
    private CustomObjectInputStream inn;

    protected Buffer() {
    }

    public Buffer(int capacity) {
        this.encoding = localEncoding;
        this.currentSectionType = null;
        this.writeable = true;
        this.staticBuffer = new NIOBuffer(capacity);
        this.freed = false;
    }

    public int offset() {
        return this.bufoffset;
    }

    public Buffer(RawBuffer buffer, int bufoffset, int capacity) {
        this.encoding = localEncoding;
        this.currentSectionType = null;
        this.writeable = true;
        this.staticBuffer = buffer;
        this.freed = false;
        this.bufoffset = bufoffset;
        this.capacity = capacity;
    }

    public void copy(ByteBuffer srcStaticBuffer, int srcOffset, int staticBufferLength, int dstOffset, byte[] srcDynamicBuffer, int dynamicBufferLength) {
        this.staticBuffer.copy(srcStaticBuffer, srcOffset, staticBufferLength, dstOffset);
        this.setSize(staticBufferLength);
        if (dynamicBufferLength > 0) {
            this.setDynamicBuffer(srcDynamicBuffer);
        }
    }

    public void free() {
        if (!this.freed) {
            this.closeObjectStreams();
            this.dynamicBuffer = null;
            this.staticBuffer.free();
            this.freed = true;
        }
    }

    public void commit() throws BufferException {
        if (this.freed) {
            throw new WrongStateException("Buffer has already been freed.");
        }
        if (this.currentSectionType != null) {
            this.staticBuffer.putInt(this.sectionSize, this.sectionHeader + 4 + this.bufoffset);
        }
        if (this.out != null) {
            try {
                this.out.flush();
                this.dynamicBuffer = this.byteOut.toByteArray();
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        }
        this.closeObjectStreams();
        this.currentSectionType = null;
        this.readPtr = 0;
        this.elementsRemaining = 0;
        this.writeable = false;
    }

    public void clear() throws BufferException {
        if (this.freed) {
            throw new WrongStateException("Buffer has already been freed.");
        }
        this.closeObjectStreams();
        this.encoding = localEncoding;
        this.currentSectionType = null;
        this.size = 0;
        this.sectionHeader = 0;
        this.dynamicBuffer = null;
        this.writeable = true;
    }

    private void closeObjectStreams() {
        if (this.in != null) {
            try {
                this.in.close();
                this.in = null;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
                this.out = null;
                this.byteOut = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void putSectionHeader(Type type) throws BufferException {
        int newSectionHeader;
        int newSize;
        if (this.freed) {
            throw new WrongStateException("Buffer has already been freed.");
        }
        if (!this.writeable) {
            throw new WrongStateException("Buffer is not in a writeable state.");
        }
        if (this.currentSectionType != null) {
            this.staticBuffer.putInt(this.sectionSize, this.bufoffset + this.sectionHeader + 4);
        }
        if ((newSize = (newSectionHeader = 8 * ((this.size + 8 - 1) / 8)) + 8) > this.staticBuffer.getCapacity()) {
            throw new BufferOverflowException("Buffer capacity too small for new section header.");
        }
        this.staticBuffer.putByte(type.getCode(), newSectionHeader + this.bufoffset);
        this.size = newSize;
        this.sectionHeader = newSectionHeader;
        this.currentSectionType = type;
        this.sectionSize = 0;
    }

    public Type getSectionHeader() throws BufferException {
        if (this.freed) {
            throw new WrongStateException("Buffer has already been freed.");
        }
        if (this.writeable) {
            throw new WrongStateException("Buffer is not in a readable state.");
        }
        if (this.elementsRemaining != 0) {
            throw new SectionSizeMismatchException("Previous section was not completely read.");
        }
        int headerStart = 8 * ((this.readPtr + 7) / 8);
        int newReadPtr = headerStart + 8;
        if (newReadPtr > this.size) {
            throw new BufferUnderflowException("Trying to read past end of buffer.");
        }
        int typeCode = this.staticBuffer.getByte(headerStart + this.bufoffset);
        this.sectionSize = this.staticBuffer.getInt(headerStart + 4 + this.bufoffset, this.encoding != localEncoding);
        this.readPtr = newReadPtr;
        this.currentSectionType = Type.getType(typeCode);
        this.elementsRemaining = this.sectionSize;
        return this.currentSectionType;
    }

    public int getSectionSize() throws BufferException {
        if (this.freed) {
            throw new WrongStateException("Buffer has already been freed.");
        }
        if (this.currentSectionType == null) {
            throw new WrongStateException("Missing call to 'getSectionHeader' or 'putSectionHeader'");
        }
        return this.sectionSize;
    }

    public int getRemaining() throws BufferException {
        if (this.freed) {
            throw new WrongStateException("Buffer has already been freed.");
        }
        if (this.writeable) {
            throw new WrongStateException("Buffer is not in a readable state.");
        }
        return this.elementsRemaining;
    }

    public void write(byte[] source, int srcOff, int numEls) throws BufferException {
        this.writeCheckArgs(source.length, srcOff, numEls);
        if (this.currentSectionType == Type.BYTE) {
            int newSize = this.size + 1 * numEls;
            if (newSize > this.staticBuffer.getCapacity()) {
                throw new BufferOverflowException("Buffer capacity too small for attempted write.");
            }
            this.staticBuffer.write(source, srcOff, numEls, this.size + this.bufoffset);
            this.sectionSize += numEls;
            this.size = newSize;
        } else if (this.currentSectionType == Type.BYTE_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                for (int i = 0; i < numEls; ++i) {
                    this.out.writeByte(source[srcOff + i]);
                    ++this.sectionSize;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void write(short[] source, int srcOff, int numEls) throws BufferException {
        this.writeCheckArgs(source.length, srcOff, numEls);
        if (this.currentSectionType == Type.SHORT) {
            int newSize = this.size + 2 * numEls;
            if (newSize > this.staticBuffer.getCapacity()) {
                throw new BufferOverflowException("Buffer capacity too small for attempted write.");
            }
            this.staticBuffer.write(source, srcOff, numEls, this.size + this.bufoffset);
            this.sectionSize += numEls;
            this.size = newSize;
        } else if (this.currentSectionType == Type.SHORT_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                for (int i = 0; i < numEls; ++i) {
                    this.out.writeShort(source[srcOff + i]);
                    ++this.sectionSize;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void write(int[] source, int srcOff, int numEls) throws BufferException {
        this.writeCheckArgs(source.length, srcOff, numEls);
        if (this.currentSectionType == Type.INT) {
            int newSize = this.size + 4 * numEls;
            if (newSize > this.staticBuffer.getCapacity()) {
                throw new BufferOverflowException("Buffer capacity too small for attempted write.");
            }
            this.staticBuffer.write(source, srcOff, numEls, this.size + this.bufoffset);
            this.sectionSize += numEls;
            this.size = newSize;
        } else if (this.currentSectionType == Type.INT_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                for (int i = 0; i < numEls; ++i) {
                    this.out.writeInt(source[srcOff + i]);
                    ++this.sectionSize;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void write(long[] source, int srcOff, int numEls) throws BufferException {
        this.writeCheckArgs(source.length, srcOff, numEls);
        if (this.currentSectionType == Type.LONG) {
            int newSize = this.size + 8 * numEls;
            if (newSize > this.staticBuffer.getCapacity()) {
                throw new BufferOverflowException("Buffer capacity too small for attempted write.");
            }
            this.staticBuffer.write(source, srcOff, numEls, this.size + this.bufoffset);
            this.sectionSize += numEls;
            this.size = newSize;
        } else if (this.currentSectionType == Type.LONG_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                for (int i = 0; i < numEls; ++i) {
                    this.out.writeLong(source[srcOff + i]);
                    ++this.sectionSize;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void write(char[] source, int srcOff, int numEls) throws BufferException {
        this.writeCheckArgs(source.length, srcOff, numEls);
        if (this.currentSectionType == Type.CHAR) {
            int newSize = this.size + 2 * numEls;
            if (newSize > this.staticBuffer.getCapacity()) {
                throw new BufferOverflowException("Buffer capacity too small for attempted write.");
            }
            this.staticBuffer.write(source, srcOff, numEls, this.size + this.bufoffset);
            this.sectionSize += numEls;
            this.size = newSize;
        } else if (this.currentSectionType == Type.CHAR_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                for (int i = 0; i < numEls; ++i) {
                    this.out.writeChar(source[srcOff + i]);
                    ++this.sectionSize;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void write(float[] source, int srcOff, int numEls) throws BufferException {
        this.writeCheckArgs(source.length, srcOff, numEls);
        if (this.currentSectionType == Type.FLOAT) {
            int newSize = this.size + 4 * numEls;
            if (newSize > this.staticBuffer.getCapacity()) {
                throw new BufferOverflowException("Buffer capacity too small for attempted write.");
            }
            this.staticBuffer.write(source, srcOff, numEls, this.size + this.bufoffset);
            this.sectionSize += numEls;
            this.size = newSize;
        } else if (this.currentSectionType == Type.FLOAT_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                for (int i = 0; i < numEls; ++i) {
                    this.out.writeFloat(source[srcOff + i]);
                    ++this.sectionSize;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void write(double[] source, int srcOff, int numEls) throws BufferException {
        this.writeCheckArgs(source.length, srcOff, numEls);
        if (this.currentSectionType == Type.DOUBLE) {
            int newSize = this.size + 8 * numEls;
            if (newSize > this.staticBuffer.getCapacity()) {
                throw new BufferOverflowException("Buffer capacity too small for attempted write.");
            }
            this.staticBuffer.write(source, srcOff, numEls, this.size + this.bufoffset);
            this.sectionSize += numEls;
            this.size = newSize;
        } else if (this.currentSectionType == Type.DOUBLE_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                for (int i = 0; i < numEls; ++i) {
                    this.out.writeDouble(source[srcOff + i]);
                    ++this.sectionSize;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void write(boolean[] source, int srcOff, int numEls) throws BufferException {
        this.writeCheckArgs(source.length, srcOff, numEls);
        if (this.currentSectionType == Type.BOOLEAN) {
            int newSize = this.size + 1 * numEls;
            if (newSize > this.staticBuffer.getCapacity()) {
                throw new BufferOverflowException("Buffer capacity too small for attempted write.");
            }
            this.staticBuffer.write(source, srcOff, numEls, this.size + this.bufoffset);
            this.sectionSize += numEls;
            this.size = newSize;
        } else if (this.currentSectionType == Type.BOOLEAN_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                for (int i = 0; i < numEls; ++i) {
                    this.out.writeBoolean(source[srcOff + i]);
                    ++this.sectionSize;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void write(Object[] source, int srcOff, int numEls) throws BufferException {
        this.writeCheckArgs(source.length, srcOff, numEls);
        if (this.currentSectionType != Type.OBJECT) {
            throw new TypeMismatchException("Wrong type for current section, or missing call to 'putSectionHeader'");
        }
        try {
            if (this.out == null) {
                this.byteOut = new ByteArrayOutputStream();
                this.out = new ObjectOutputStream(this.byteOut);
            }
            for (int i = 0; i < numEls; ++i) {
                this.out.writeObject(source[srcOff + i]);
                ++this.sectionSize;
            }
        }
        catch (IOException e) {
            throw new DynamicBufferException("Problem writing dynamic buffer", e);
        }
    }

    private void writeCheckArgs(int sourceLen, int srcOff, int numEls) throws BufferException {
        if (this.freed) {
            throw new WrongStateException("Buffer has already been freed.");
        }
        if (!this.writeable) {
            throw new WrongStateException("Buffer is not in a writeable state.");
        }
        if (this.currentSectionType == null) {
            throw new WrongStateException("Missing call to 'putSectionHeader'");
        }
        if (srcOff < 0) {
            throw new ArrayIndexOutOfBoundsException("Out of bounds in source array: " + srcOff);
        }
        if (srcOff + numEls > sourceLen) {
            throw new ArrayIndexOutOfBoundsException("Out of bounds in source array: " + (srcOff + numEls - 1));
        }
    }

    public void gather(byte[] source, int numEls, int idxOff, int[] indexes) throws BufferException {
        this.gatherCheckArgs(numEls, idxOff, indexes.length);
        if (this.currentSectionType == Type.BYTE) {
            if (source == null) {
                throw new NullPointerException("null");
            }
            if (this.size + 1 * numEls > this.staticBuffer.getCapacity()) {
                throw new BufferOverflowException("Buffer capacity too small for attempted write.");
            }
            int transfered = this.staticBuffer.gather(source, numEls, idxOff, indexes, this.size + this.bufoffset);
            this.size += 1 * transfered;
            this.sectionSize += transfered;
            if (transfered < numEls) {
                throw new ArrayIndexOutOfBoundsException("Out of bounds in source array: " + indexes[idxOff + transfered]);
            }
        } else if (this.currentSectionType == Type.BYTE_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                for (int i = 0; i < numEls; ++i) {
                    this.out.writeByte(source[indexes[idxOff + i]]);
                    ++this.sectionSize;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void gather(short[] source, int numEls, int idxOff, int[] indexes) throws BufferException {
        this.gatherCheckArgs(numEls, idxOff, indexes.length);
        if (this.currentSectionType == Type.SHORT) {
            if (source == null) {
                throw new NullPointerException("null");
            }
            if (this.size + 2 * numEls > this.staticBuffer.getCapacity()) {
                throw new BufferOverflowException("Buffer capacity too small for attempted write.");
            }
            int transfered = this.staticBuffer.gather(source, numEls, idxOff, indexes, this.size + this.bufoffset);
            this.size += 2 * transfered;
            this.sectionSize += transfered;
            if (transfered < numEls) {
                throw new ArrayIndexOutOfBoundsException("Out of bounds in source array: " + indexes[idxOff + transfered]);
            }
        } else if (this.currentSectionType == Type.SHORT_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                for (int i = 0; i < numEls; ++i) {
                    this.out.writeShort(source[indexes[idxOff + i]]);
                    ++this.sectionSize;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void gather(int[] source, int numEls, int idxOff, int[] indexes) throws BufferException {
        this.gatherCheckArgs(numEls, idxOff, indexes.length);
        if (this.currentSectionType == Type.INT) {
            if (source == null) {
                throw new NullPointerException("null");
            }
            if (this.size + 4 * numEls > this.staticBuffer.getCapacity()) {
                throw new BufferOverflowException("Buffer capacity too small for attempted write.");
            }
            int transfered = this.staticBuffer.gather(source, numEls, idxOff, indexes, this.size + this.bufoffset);
            this.size += 4 * transfered;
            this.sectionSize += transfered;
            if (transfered < numEls) {
                throw new ArrayIndexOutOfBoundsException("Out of bounds in source array: " + indexes[idxOff + transfered]);
            }
        } else if (this.currentSectionType == Type.INT_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                for (int i = 0; i < numEls; ++i) {
                    this.out.writeInt(source[indexes[idxOff + i]]);
                    ++this.sectionSize;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void gather(long[] source, int numEls, int idxOff, int[] indexes) throws BufferException {
        this.gatherCheckArgs(numEls, idxOff, indexes.length);
        if (this.currentSectionType == Type.LONG) {
            if (source == null) {
                throw new NullPointerException("null");
            }
            if (this.size + 8 * numEls > this.staticBuffer.getCapacity()) {
                throw new BufferOverflowException("Buffer capacity too small for attempted write.");
            }
            int transfered = this.staticBuffer.gather(source, numEls, idxOff, indexes, this.size + this.bufoffset);
            this.size += 8 * transfered;
            this.sectionSize += transfered;
            if (transfered < numEls) {
                throw new ArrayIndexOutOfBoundsException("Out of bounds in source array: " + indexes[idxOff + transfered]);
            }
        } else if (this.currentSectionType == Type.LONG_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                for (int i = 0; i < numEls; ++i) {
                    this.out.writeLong(source[indexes[idxOff + i]]);
                    ++this.sectionSize;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void gather(char[] source, int numEls, int idxOff, int[] indexes) throws BufferException {
        this.gatherCheckArgs(numEls, idxOff, indexes.length);
        if (this.currentSectionType == Type.CHAR) {
            if (source == null) {
                throw new NullPointerException("null");
            }
            if (this.size + 2 * numEls > this.staticBuffer.getCapacity()) {
                throw new BufferOverflowException("Buffer capacity too small for attempted write.");
            }
            int transfered = this.staticBuffer.gather(source, numEls, idxOff, indexes, this.size + this.bufoffset);
            this.size += 2 * transfered;
            this.sectionSize += transfered;
            if (transfered < numEls) {
                throw new ArrayIndexOutOfBoundsException("Out of bounds in source array: " + indexes[idxOff + transfered]);
            }
        } else if (this.currentSectionType == Type.CHAR_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                for (int i = 0; i < numEls; ++i) {
                    this.out.writeChar(source[indexes[idxOff + i]]);
                    ++this.sectionSize;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void gather(float[] source, int numEls, int idxOff, int[] indexes) throws BufferException {
        this.gatherCheckArgs(numEls, idxOff, indexes.length);
        if (this.currentSectionType == Type.FLOAT) {
            if (source == null) {
                throw new NullPointerException("null");
            }
            if (this.size + 4 * numEls > this.staticBuffer.getCapacity()) {
                throw new BufferOverflowException("Buffer capacity too small for attempted write.");
            }
            int transfered = this.staticBuffer.gather(source, numEls, idxOff, indexes, this.size + this.bufoffset);
            this.size += 4 * transfered;
            this.sectionSize += transfered;
            if (transfered < numEls) {
                throw new ArrayIndexOutOfBoundsException("Out of bounds in source array: " + indexes[idxOff + transfered]);
            }
        } else if (this.currentSectionType == Type.FLOAT_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                for (int i = 0; i < numEls; ++i) {
                    this.out.writeFloat(source[indexes[idxOff + i]]);
                    ++this.sectionSize;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void gather(double[] source, int numEls, int idxOff, int[] indexes) throws BufferException {
        this.gatherCheckArgs(numEls, idxOff, indexes.length);
        if (this.currentSectionType == Type.DOUBLE) {
            if (source == null) {
                throw new NullPointerException("null");
            }
            if (this.size + 8 * numEls > this.staticBuffer.getCapacity()) {
                throw new BufferOverflowException("Buffer capacity too small for attempted write.");
            }
            int transfered = this.staticBuffer.gather(source, numEls, idxOff, indexes, this.size + this.bufoffset);
            this.size += 8 * transfered;
            this.sectionSize += transfered;
            if (transfered < numEls) {
                throw new ArrayIndexOutOfBoundsException("Out of bounds in source array: " + indexes[idxOff + transfered]);
            }
        } else if (this.currentSectionType == Type.DOUBLE_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                for (int i = 0; i < numEls; ++i) {
                    this.out.writeDouble(source[indexes[idxOff + i]]);
                    ++this.sectionSize;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void gather(boolean[] source, int numEls, int idxOff, int[] indexes) throws BufferException {
        this.gatherCheckArgs(numEls, idxOff, indexes.length);
        if (this.currentSectionType == Type.BOOLEAN) {
            if (source == null) {
                throw new NullPointerException("null");
            }
            if (this.size + 1 * numEls > this.staticBuffer.getCapacity()) {
                throw new BufferOverflowException("Buffer capacity too small for attempted write.");
            }
            int transfered = this.staticBuffer.gather(source, numEls, idxOff, indexes, this.size + this.bufoffset);
            this.size += 1 * transfered;
            this.sectionSize += transfered;
            if (transfered < numEls) {
                throw new ArrayIndexOutOfBoundsException("Out of bounds in source array: " + indexes[idxOff + transfered]);
            }
        } else if (this.currentSectionType == Type.BOOLEAN_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                for (int i = 0; i < numEls; ++i) {
                    this.out.writeBoolean(source[indexes[idxOff + i]]);
                    ++this.sectionSize;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void gather(Object[] source, int numEls, int idxOff, int[] indexes) throws BufferException {
        this.gatherCheckArgs(numEls, idxOff, indexes.length);
        if (this.currentSectionType != Type.OBJECT) {
            throw new TypeMismatchException("Wrong type for current section");
        }
        try {
            if (this.out == null) {
                this.byteOut = new ByteArrayOutputStream();
                this.out = new ObjectOutputStream(this.byteOut);
            }
            for (int i = 0; i < numEls; ++i) {
                this.out.writeObject(source[indexes[idxOff + i]]);
                ++this.sectionSize;
            }
        }
        catch (IOException e) {
            throw new DynamicBufferException("Problem writing dynamic buffer", e);
        }
    }

    private void gatherCheckArgs(int numEls, int idxOff, int indexesLen) throws BufferException {
        if (this.freed) {
            throw new WrongStateException("Buffer has already been freed.");
        }
        if (!this.writeable) {
            throw new WrongStateException("Buffer is not in a writeable state.");
        }
        if (this.currentSectionType == null) {
            throw new WrongStateException("Missing call to 'putSectionHeader'");
        }
        if (idxOff < 0) {
            throw new ArrayIndexOutOfBoundsException("Out of bounds in indexes array: " + idxOff);
        }
        if (idxOff + numEls > indexesLen) {
            throw new ArrayIndexOutOfBoundsException("Out of bounds in indexes array: " + (idxOff + numEls - 1));
        }
    }

    public void strGather(byte[] source, int srcOff, int rank, int exts, int strs, int[] shape) throws BufferException {
        int volume = this.strGatherCheckArgs(source.length, srcOff, rank, exts, strs, shape);
        if (this.currentSectionType == Type.BYTE) {
            if (volume != 0) {
                int newSize = this.size + 1 * volume;
                if (newSize > this.staticBuffer.getCapacity()) {
                    throw new BufferOverflowException("Buffer capacity too small for attempted write.");
                }
                this.staticBuffer.strGather(source, srcOff, rank, exts, strs, shape, this.size + this.bufoffset);
                this.sectionSize += volume;
                this.size = newSize;
            }
        } else if (this.currentSectionType == Type.BYTE_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                this.doStrGather(source, srcOff, rank, exts, strs, shape);
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    private void doStrGather(byte[] source, int srcOff, int rank, int exts, int strs, int[] shape) throws IOException {
        if (rank == 0) {
            this.out.writeByte(source[srcOff]);
            ++this.sectionSize;
        } else {
            int str = shape[strs];
            for (int i = 0; i < shape[exts]; ++i) {
                this.doStrGather(source, srcOff + str * i, rank - 1, exts + 1, strs + 1, shape);
            }
        }
    }

    public void strGather(short[] source, int srcOff, int rank, int exts, int strs, int[] shape) throws BufferException {
        int volume = this.strGatherCheckArgs(source.length, srcOff, rank, exts, strs, shape);
        if (this.currentSectionType == Type.SHORT) {
            if (volume != 0) {
                int newSize = this.size + 2 * volume;
                if (newSize > this.staticBuffer.getCapacity()) {
                    throw new BufferOverflowException("Buffer capacity too small for attempted write.");
                }
                this.staticBuffer.strGather(source, srcOff, rank, exts, strs, shape, this.size + this.bufoffset);
                this.sectionSize += volume;
                this.size = newSize;
            }
        } else if (this.currentSectionType == Type.SHORT_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                this.doStrGather(source, srcOff, rank, exts, strs, shape);
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    private void doStrGather(short[] source, int srcOff, int rank, int exts, int strs, int[] shape) throws IOException {
        if (rank == 0) {
            this.out.writeShort(source[srcOff]);
            ++this.sectionSize;
        } else {
            int str = shape[strs];
            for (int i = 0; i < shape[exts]; ++i) {
                this.doStrGather(source, srcOff + str * i, rank - 1, exts + 1, strs + 1, shape);
            }
        }
    }

    public void strGather(int[] source, int srcOff, int rank, int exts, int strs, int[] shape) throws BufferException {
        int volume = this.strGatherCheckArgs(source.length, srcOff, rank, exts, strs, shape);
        if (this.currentSectionType == Type.INT) {
            if (volume != 0) {
                int newSize = this.size + 4 * volume;
                if (newSize > this.staticBuffer.getCapacity()) {
                    throw new BufferOverflowException("Buffer capacity too small for attempted write.");
                }
                this.staticBuffer.strGather(source, srcOff, rank, exts, strs, shape, this.size + this.bufoffset);
                this.sectionSize += volume;
                this.size = newSize;
            }
        } else if (this.currentSectionType == Type.INT_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                this.doStrGather(source, srcOff, rank, exts, strs, shape);
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    private void doStrGather(int[] source, int srcOff, int rank, int exts, int strs, int[] shape) throws IOException {
        if (rank == 0) {
            this.out.writeInt(source[srcOff]);
            ++this.sectionSize;
        } else {
            int str = shape[strs];
            for (int i = 0; i < shape[exts]; ++i) {
                this.doStrGather(source, srcOff + str * i, rank - 1, exts + 1, strs + 1, shape);
            }
        }
    }

    public void strGather(long[] source, int srcOff, int rank, int exts, int strs, int[] shape) throws BufferException {
        int volume = this.strGatherCheckArgs(source.length, srcOff, rank, exts, strs, shape);
        if (this.currentSectionType == Type.LONG) {
            if (volume != 0) {
                int newSize = this.size + 8 * volume;
                if (newSize > this.staticBuffer.getCapacity()) {
                    throw new BufferOverflowException("Buffer capacity too small for attempted write.");
                }
                this.staticBuffer.strGather(source, srcOff, rank, exts, strs, shape, this.size + this.bufoffset);
                this.sectionSize += volume;
                this.size = newSize;
            }
        } else if (this.currentSectionType == Type.LONG_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                this.doStrGather(source, srcOff, rank, exts, strs, shape);
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    private void doStrGather(long[] source, int srcOff, int rank, int exts, int strs, int[] shape) throws IOException {
        if (rank == 0) {
            this.out.writeLong(source[srcOff]);
            ++this.sectionSize;
        } else {
            int str = shape[strs];
            for (int i = 0; i < shape[exts]; ++i) {
                this.doStrGather(source, srcOff + str * i, rank - 1, exts + 1, strs + 1, shape);
            }
        }
    }

    public void strGather(char[] source, int srcOff, int rank, int exts, int strs, int[] shape) throws BufferException {
        int volume = this.strGatherCheckArgs(source.length, srcOff, rank, exts, strs, shape);
        if (this.currentSectionType == Type.CHAR) {
            if (volume != 0) {
                int newSize = this.size + 2 * volume;
                if (newSize > this.staticBuffer.getCapacity()) {
                    throw new BufferOverflowException("Buffer capacity too small for attempted write.");
                }
                this.staticBuffer.strGather(source, srcOff, rank, exts, strs, shape, this.size + this.bufoffset);
                this.sectionSize += volume;
                this.size = newSize;
            }
        } else if (this.currentSectionType == Type.CHAR_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                this.doStrGather(source, srcOff, rank, exts, strs, shape);
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    private void doStrGather(char[] source, int srcOff, int rank, int exts, int strs, int[] shape) throws IOException {
        if (rank == 0) {
            this.out.writeChar(source[srcOff]);
            ++this.sectionSize;
        } else {
            int str = shape[strs];
            for (int i = 0; i < shape[exts]; ++i) {
                this.doStrGather(source, srcOff + str * i, rank - 1, exts + 1, strs + 1, shape);
            }
        }
    }

    public void strGather(float[] source, int srcOff, int rank, int exts, int strs, int[] shape) throws BufferException {
        int volume = this.strGatherCheckArgs(source.length, srcOff, rank, exts, strs, shape);
        if (this.currentSectionType == Type.FLOAT) {
            if (volume != 0) {
                int newSize = this.size + 4 * volume;
                if (newSize > this.staticBuffer.getCapacity()) {
                    throw new BufferOverflowException("Buffer capacity too small for attempted write.");
                }
                this.staticBuffer.strGather(source, srcOff, rank, exts, strs, shape, this.size + this.bufoffset);
                this.sectionSize += volume;
                this.size = newSize;
            }
        } else if (this.currentSectionType == Type.FLOAT_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                this.doStrGather(source, srcOff, rank, exts, strs, shape);
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    private void doStrGather(float[] source, int srcOff, int rank, int exts, int strs, int[] shape) throws IOException {
        if (rank == 0) {
            this.out.writeFloat(source[srcOff]);
            ++this.sectionSize;
        } else {
            int str = shape[strs];
            for (int i = 0; i < shape[exts]; ++i) {
                this.doStrGather(source, srcOff + str * i, rank - 1, exts + 1, strs + 1, shape);
            }
        }
    }

    public void strGather(double[] source, int srcOff, int rank, int exts, int strs, int[] shape) throws BufferException {
        int volume = this.strGatherCheckArgs(source.length, srcOff, rank, exts, strs, shape);
        if (this.currentSectionType == Type.DOUBLE) {
            if (volume != 0) {
                int newSize = this.size + 8 * volume;
                if (newSize > this.staticBuffer.getCapacity()) {
                    throw new BufferOverflowException("Buffer capacity too small for attempted write.");
                }
                this.staticBuffer.strGather(source, srcOff, rank, exts, strs, shape, this.size + this.bufoffset);
                this.sectionSize += volume;
                this.size = newSize;
            }
        } else if (this.currentSectionType == Type.DOUBLE_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                this.doStrGather(source, srcOff, rank, exts, strs, shape);
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    private void doStrGather(double[] source, int srcOff, int rank, int exts, int strs, int[] shape) throws IOException {
        if (rank == 0) {
            this.out.writeDouble(source[srcOff]);
            ++this.sectionSize;
        } else {
            int str = shape[strs];
            for (int i = 0; i < shape[exts]; ++i) {
                this.doStrGather(source, srcOff + str * i, rank - 1, exts + 1, strs + 1, shape);
            }
        }
    }

    public void strGather(boolean[] source, int srcOff, int rank, int exts, int strs, int[] shape) throws BufferException {
        int volume = this.strGatherCheckArgs(source.length, srcOff, rank, exts, strs, shape);
        if (this.currentSectionType == Type.BOOLEAN) {
            if (volume != 0) {
                int newSize = this.size + 1 * volume;
                if (newSize > this.staticBuffer.getCapacity()) {
                    throw new BufferOverflowException("Buffer capacity too small for attempted write.");
                }
                this.staticBuffer.strGather(source, srcOff, rank, exts, strs, shape, this.size + this.bufoffset);
                this.sectionSize += volume;
                this.size = newSize;
            }
        } else if (this.currentSectionType == Type.BOOLEAN_DYNAMIC) {
            try {
                if (this.out == null) {
                    this.byteOut = new ByteArrayOutputStream();
                    this.out = new ObjectOutputStream(this.byteOut);
                }
                this.doStrGather(source, srcOff, rank, exts, strs, shape);
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem writing dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    private void doStrGather(boolean[] source, int srcOff, int rank, int exts, int strs, int[] shape) throws IOException {
        if (rank == 0) {
            this.out.writeBoolean(source[srcOff]);
            ++this.sectionSize;
        } else {
            int str = shape[strs];
            for (int i = 0; i < shape[exts]; ++i) {
                this.doStrGather(source, srcOff + str * i, rank - 1, exts + 1, strs + 1, shape);
            }
        }
    }

    public void strGather(Object[] source, int srcOff, int rank, int exts, int strs, int[] shape) throws BufferException {
        int volume = this.strGatherCheckArgs(source.length, srcOff, rank, exts, strs, shape);
        if (this.currentSectionType != Type.OBJECT) {
            throw new TypeMismatchException("Wrong type for current section");
        }
        try {
            if (this.out == null) {
                this.byteOut = new ByteArrayOutputStream();
                this.out = new ObjectOutputStream(this.byteOut);
            }
            this.doStrGather(source, srcOff, rank, exts, strs, shape);
        }
        catch (IOException e) {
            throw new DynamicBufferException("Problem writing dynamic buffer", e);
        }
    }

    private void doStrGather(Object[] source, int srcOff, int rank, int exts, int strs, int[] shape) throws IOException {
        if (rank == 0) {
            this.out.writeObject(source[srcOff]);
            ++this.sectionSize;
        } else {
            int str = shape[strs];
            for (int i = 0; i < shape[exts]; ++i) {
                this.doStrGather(source, srcOff + str * i, rank - 1, exts + 1, strs + 1, shape);
            }
        }
    }

    private int strGatherCheckArgs(int sourceLen, int srcOff, int rank, int exts, int strs, int[] shape) throws BufferException {
        if (this.freed) {
            throw new WrongStateException("Buffer has already been freed.");
        }
        if (!this.writeable) {
            throw new WrongStateException("Buffer is not in a writeable state.");
        }
        if (this.currentSectionType == null) {
            throw new WrongStateException("Missing call to 'putSectionHeader'");
        }
        if (rank < 0) {
            throw new IllegalArgumentException("Negative rank specified");
        }
        int minIndex = srcOff;
        int maxIndex = srcOff;
        int volume = 1;
        for (int i = 0; i < rank; ++i) {
            int ext = shape[exts + i];
            int str = shape[strs + i];
            if (ext < 0) {
                throw new ArrayIndexOutOfBoundsException("Patch has negative extent.");
            }
            if (ext == 0) {
                return 0;
            }
            if (str < 0) {
                minIndex += str * (ext - 1);
            } else {
                maxIndex += str * (ext - 1);
            }
            volume *= ext;
        }
        if (minIndex < 0) {
            throw new ArrayIndexOutOfBoundsException("Out of bounds in source array: " + minIndex);
        }
        if (maxIndex >= sourceLen) {
            throw new ArrayIndexOutOfBoundsException("Out of bounds in source array: " + maxIndex);
        }
        return volume;
    }

    public void read(byte[] dest, int dstOff, int numEls) throws BufferException {
        this.readCheckArgs(dest.length, dstOff, numEls);
        if (this.currentSectionType == Type.BYTE) {
            this.staticBuffer.read(dest, dstOff, numEls, this.readPtr + this.bufoffset, this.encoding != localEncoding);
            this.readPtr += 1 * numEls;
            this.elementsRemaining -= numEls;
        } else if (this.currentSectionType == Type.BYTE_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                for (int i = 0; i < numEls; ++i) {
                    dest[dstOff + i] = this.in.readByte();
                    --this.elementsRemaining;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void read(short[] dest, int dstOff, int numEls) throws BufferException {
        this.readCheckArgs(dest.length, dstOff, numEls);
        if (this.currentSectionType == Type.SHORT) {
            this.staticBuffer.read(dest, dstOff, numEls, this.readPtr + this.bufoffset, this.encoding != localEncoding);
            this.readPtr += 2 * numEls;
            this.elementsRemaining -= numEls;
        } else if (this.currentSectionType == Type.SHORT_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                for (int i = 0; i < numEls; ++i) {
                    dest[dstOff + i] = this.in.readShort();
                    --this.elementsRemaining;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void read(int[] dest, int dstOff, int numEls) throws BufferException {
        this.readCheckArgs(dest.length, dstOff, numEls);
        if (this.currentSectionType == Type.INT) {
            this.staticBuffer.read(dest, dstOff, numEls, this.readPtr + this.bufoffset, this.encoding != localEncoding);
            this.readPtr += 4 * numEls;
            this.elementsRemaining -= numEls;
        } else if (this.currentSectionType == Type.INT_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                for (int i = 0; i < numEls; ++i) {
                    dest[dstOff + i] = this.in.readInt();
                    --this.elementsRemaining;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void read(long[] dest, int dstOff, int numEls) throws BufferException {
        this.readCheckArgs(dest.length, dstOff, numEls);
        if (this.currentSectionType == Type.LONG) {
            this.staticBuffer.read(dest, dstOff, numEls, this.readPtr + this.bufoffset, this.encoding != localEncoding);
            this.readPtr += 8 * numEls;
            this.elementsRemaining -= numEls;
        } else if (this.currentSectionType == Type.LONG_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                for (int i = 0; i < numEls; ++i) {
                    dest[dstOff + i] = this.in.readLong();
                    --this.elementsRemaining;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void read(char[] dest, int dstOff, int numEls) throws BufferException {
        this.readCheckArgs(dest.length, dstOff, numEls);
        if (this.currentSectionType == Type.CHAR) {
            this.staticBuffer.read(dest, dstOff, numEls, this.readPtr + this.bufoffset, this.encoding != localEncoding);
            this.readPtr += 2 * numEls;
            this.elementsRemaining -= numEls;
        } else if (this.currentSectionType == Type.CHAR_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                for (int i = 0; i < numEls; ++i) {
                    dest[dstOff + i] = this.in.readChar();
                    --this.elementsRemaining;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void read(float[] dest, int dstOff, int numEls) throws BufferException {
        this.readCheckArgs(dest.length, dstOff, numEls);
        if (this.currentSectionType == Type.FLOAT) {
            this.staticBuffer.read(dest, dstOff, numEls, this.readPtr + this.bufoffset, this.encoding != localEncoding);
            this.readPtr += 4 * numEls;
            this.elementsRemaining -= numEls;
        } else if (this.currentSectionType == Type.FLOAT_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                for (int i = 0; i < numEls; ++i) {
                    dest[dstOff + i] = this.in.readFloat();
                    --this.elementsRemaining;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void read(double[] dest, int dstOff, int numEls) throws BufferException {
        this.readCheckArgs(dest.length, dstOff, numEls);
        if (this.currentSectionType == Type.DOUBLE) {
            this.staticBuffer.read(dest, dstOff, numEls, this.readPtr + this.bufoffset, this.encoding != localEncoding);
            this.readPtr += 8 * numEls;
            this.elementsRemaining -= numEls;
        } else if (this.currentSectionType == Type.DOUBLE_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                for (int i = 0; i < numEls; ++i) {
                    dest[dstOff + i] = this.in.readDouble();
                    --this.elementsRemaining;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void read(boolean[] dest, int dstOff, int numEls) throws BufferException {
        this.readCheckArgs(dest.length, dstOff, numEls);
        if (this.currentSectionType == Type.BOOLEAN) {
            this.staticBuffer.read(dest, dstOff, numEls, this.readPtr + this.bufoffset, this.encoding != localEncoding);
            this.readPtr += 1 * numEls;
            this.elementsRemaining -= numEls;
        } else if (this.currentSectionType == Type.BOOLEAN_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                for (int i = 0; i < numEls; ++i) {
                    dest[dstOff + i] = this.in.readBoolean();
                    --this.elementsRemaining;
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section.");
        }
    }

    public void read(Object[] dest, int dstOff, int numEls) throws BufferException {
        this.readCheckArgs(dest.length, dstOff, numEls);
        if (this.currentSectionType != Type.OBJECT) {
            throw new TypeMismatchException("Wrong type for current section, or missing call to 'getSectionHeader'");
        }
        try {
            if (this.inn == null) {
                ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                this.in = new ObjectInputStream(o);
            }
            for (int i = 0; i < numEls; ++i) {
                Object obj;
                dest[dstOff + i] = obj = this.in.readObject();
                --this.elementsRemaining;
            }
        }
        catch (ClassNotFoundException ce) {
            try {
                ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                this.inn = new CustomObjectInputStream(o);
                for (int i = 0; i < numEls; ++i) {
                    Object obj;
                    dest[dstOff + i] = obj = this.inn.readObject();
                    --this.elementsRemaining;
                }
            }
            catch (Exception ioe) {
                throw new DynamicBufferException("Problem reading dynamic buffer", ioe);
            }
        }
        catch (Exception e) {
            throw new DynamicBufferException("Problem reading dynamic buffer", e);
        }
    }

    private void readCheckArgs(int destLen, int dstOff, int numEls) throws BufferException {
        if (this.freed) {
            throw new WrongStateException("Buffer has already been freed.");
        }
        if (this.writeable) {
            throw new WrongStateException("Buffer is not in a readable state.");
        }
        if (this.currentSectionType == null) {
            throw new WrongStateException("Missing call to 'getSectionHeader'");
        }
        if (dstOff < 0) {
            throw new ArrayIndexOutOfBoundsException("Out of bounds in dest array: " + dstOff);
        }
        if (dstOff + numEls > destLen) {
            throw new ArrayIndexOutOfBoundsException("Out of bounds in dest array: " + (dstOff + numEls - 1));
        }
        if (numEls > this.elementsRemaining) {
            throw new SectionSizeMismatchException("Trying to read past end of current section.");
        }
    }

    public void scatter(byte[] dest, int numEls, int idxOff, int[] indexes) throws BufferException {
        this.scatterCheckArgs(numEls, idxOff, indexes.length);
        if (this.currentSectionType == Type.BYTE) {
            if (dest == null) {
                throw new NullPointerException("null");
            }
            int transfered = this.staticBuffer.scatter(dest, numEls, idxOff, indexes, this.readPtr + this.bufoffset, this.encoding != localEncoding);
            this.readPtr += 1 * transfered;
            this.elementsRemaining -= transfered;
            if (transfered < numEls) {
                throw new ArrayIndexOutOfBoundsException("Out of bounds in dest array: " + indexes[idxOff + transfered]);
            }
        } else if (this.currentSectionType == Type.BYTE_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                for (int i = 0; i < numEls; ++i) {
                    int idx = indexes[idxOff + i];
                    if (idx >= 0 && idx < dest.length) {
                        dest[idx] = this.in.readByte();
                        --this.elementsRemaining;
                        continue;
                    }
                    throw new ArrayIndexOutOfBoundsException("Out of bounds in dest array: " + idx);
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    public void scatter(short[] dest, int numEls, int idxOff, int[] indexes) throws BufferException {
        this.scatterCheckArgs(numEls, idxOff, indexes.length);
        if (this.currentSectionType == Type.SHORT) {
            if (dest == null) {
                throw new NullPointerException("null");
            }
            int transfered = this.staticBuffer.scatter(dest, numEls, idxOff, indexes, this.readPtr + this.bufoffset, this.encoding != localEncoding);
            this.readPtr += 2 * transfered;
            this.elementsRemaining -= transfered;
            if (transfered < numEls) {
                throw new ArrayIndexOutOfBoundsException("Out of bounds in dest array: " + indexes[idxOff + transfered]);
            }
        } else if (this.currentSectionType == Type.SHORT_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                for (int i = 0; i < numEls; ++i) {
                    int idx = indexes[idxOff + i];
                    if (idx >= 0 && idx < dest.length) {
                        dest[idx] = this.in.readShort();
                        --this.elementsRemaining;
                        continue;
                    }
                    throw new ArrayIndexOutOfBoundsException("Out of bounds in dest array: " + idx);
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    public void scatter(int[] dest, int numEls, int idxOff, int[] indexes) throws BufferException {
        this.scatterCheckArgs(numEls, idxOff, indexes.length);
        if (this.currentSectionType == Type.INT) {
            if (dest == null) {
                throw new NullPointerException("null");
            }
            int transfered = this.staticBuffer.scatter(dest, numEls, idxOff, indexes, this.readPtr + this.bufoffset, this.encoding != localEncoding);
            this.readPtr += 4 * transfered;
            this.elementsRemaining -= transfered;
            if (transfered < numEls) {
                throw new ArrayIndexOutOfBoundsException("Out of bounds in dest array: " + indexes[idxOff + transfered]);
            }
        } else if (this.currentSectionType == Type.INT_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                for (int i = 0; i < numEls; ++i) {
                    int idx = indexes[idxOff + i];
                    if (idx >= 0 && idx < dest.length) {
                        dest[idx] = this.in.readInt();
                        --this.elementsRemaining;
                        continue;
                    }
                    throw new ArrayIndexOutOfBoundsException("Out of bounds in dest array: " + idx);
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    public void scatter(long[] dest, int numEls, int idxOff, int[] indexes) throws BufferException {
        this.scatterCheckArgs(numEls, idxOff, indexes.length);
        if (this.currentSectionType == Type.LONG) {
            if (dest == null) {
                throw new NullPointerException("null");
            }
            int transfered = this.staticBuffer.scatter(dest, numEls, idxOff, indexes, this.readPtr + this.bufoffset, this.encoding != localEncoding);
            this.readPtr += 8 * transfered;
            this.elementsRemaining -= transfered;
            if (transfered < numEls) {
                throw new ArrayIndexOutOfBoundsException("Out of bounds in dest array: " + indexes[idxOff + transfered]);
            }
        } else if (this.currentSectionType == Type.LONG_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                for (int i = 0; i < numEls; ++i) {
                    int idx = indexes[idxOff + i];
                    if (idx >= 0 && idx < dest.length) {
                        dest[idx] = this.in.readLong();
                        --this.elementsRemaining;
                        continue;
                    }
                    throw new ArrayIndexOutOfBoundsException("Out of bounds in dest array: " + idx);
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    public void scatter(char[] dest, int numEls, int idxOff, int[] indexes) throws BufferException {
        this.scatterCheckArgs(numEls, idxOff, indexes.length);
        if (this.currentSectionType == Type.CHAR) {
            if (dest == null) {
                throw new NullPointerException("null");
            }
            int transfered = this.staticBuffer.scatter(dest, numEls, idxOff, indexes, this.readPtr + this.bufoffset, this.encoding != localEncoding);
            this.readPtr += 2 * transfered;
            this.elementsRemaining -= transfered;
            if (transfered < numEls) {
                throw new ArrayIndexOutOfBoundsException("Out of bounds in dest array: " + indexes[idxOff + transfered]);
            }
        } else if (this.currentSectionType == Type.CHAR_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                for (int i = 0; i < numEls; ++i) {
                    int idx = indexes[idxOff + i];
                    if (idx >= 0 && idx < dest.length) {
                        dest[idx] = this.in.readChar();
                        --this.elementsRemaining;
                        continue;
                    }
                    throw new ArrayIndexOutOfBoundsException("Out of bounds in dest array: " + idx);
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    public void scatter(float[] dest, int numEls, int idxOff, int[] indexes) throws BufferException {
        this.scatterCheckArgs(numEls, idxOff, indexes.length);
        if (this.currentSectionType == Type.FLOAT) {
            if (dest == null) {
                throw new NullPointerException("null");
            }
            int transfered = this.staticBuffer.scatter(dest, numEls, idxOff, indexes, this.readPtr + this.bufoffset, this.encoding != localEncoding);
            this.readPtr += 4 * transfered;
            this.elementsRemaining -= transfered;
            if (transfered < numEls) {
                throw new ArrayIndexOutOfBoundsException("Out of bounds in dest array: " + indexes[idxOff + transfered]);
            }
        } else if (this.currentSectionType == Type.FLOAT_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                for (int i = 0; i < numEls; ++i) {
                    int idx = indexes[idxOff + i];
                    if (idx >= 0 && idx < dest.length) {
                        dest[idx] = this.in.readFloat();
                        --this.elementsRemaining;
                        continue;
                    }
                    throw new ArrayIndexOutOfBoundsException("Out of bounds in dest array: " + idx);
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    public void scatter(double[] dest, int numEls, int idxOff, int[] indexes) throws BufferException {
        this.scatterCheckArgs(numEls, idxOff, indexes.length);
        if (this.currentSectionType == Type.DOUBLE) {
            if (dest == null) {
                throw new NullPointerException("null");
            }
            int transfered = this.staticBuffer.scatter(dest, numEls, idxOff, indexes, this.readPtr + this.bufoffset, this.encoding != localEncoding);
            this.readPtr += 8 * transfered;
            this.elementsRemaining -= transfered;
            if (transfered < numEls) {
                throw new ArrayIndexOutOfBoundsException("Out of bounds in dest array: " + indexes[idxOff + transfered]);
            }
        } else if (this.currentSectionType == Type.DOUBLE_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                for (int i = 0; i < numEls; ++i) {
                    int idx = indexes[idxOff + i];
                    if (idx >= 0 && idx < dest.length) {
                        dest[idx] = this.in.readDouble();
                        --this.elementsRemaining;
                        continue;
                    }
                    throw new ArrayIndexOutOfBoundsException("Out of bounds in dest array: " + idx);
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    public void scatter(boolean[] dest, int numEls, int idxOff, int[] indexes) throws BufferException {
        this.scatterCheckArgs(numEls, idxOff, indexes.length);
        if (this.currentSectionType == Type.BOOLEAN) {
            if (dest == null) {
                throw new NullPointerException("null");
            }
            int transfered = this.staticBuffer.scatter(dest, numEls, idxOff, indexes, this.readPtr + this.bufoffset, this.encoding != localEncoding);
            this.readPtr += 1 * transfered;
            this.elementsRemaining -= transfered;
            if (transfered < numEls) {
                throw new ArrayIndexOutOfBoundsException("Out of bounds in dest array: " + indexes[idxOff + transfered]);
            }
        } else if (this.currentSectionType == Type.BOOLEAN_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                for (int i = 0; i < numEls; ++i) {
                    int idx = indexes[idxOff + i];
                    if (idx >= 0 && idx < dest.length) {
                        dest[idx] = this.in.readBoolean();
                        --this.elementsRemaining;
                        continue;
                    }
                    throw new ArrayIndexOutOfBoundsException("Out of bounds in dest array: " + idx);
                }
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    public void scatter(Object[] dest, int numEls, int idxOff, int[] indexes) throws BufferException {
        this.scatterCheckArgs(numEls, idxOff, indexes.length);
        if (this.currentSectionType != Type.OBJECT) {
            throw new TypeMismatchException("Wrong type for current section");
        }
        try {
            if (this.in == null) {
                ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                this.in = new ObjectInputStream(o);
            }
            for (int i = 0; i < numEls; ++i) {
                int idx = indexes[idxOff + i];
                if (idx >= 0 && idx < dest.length) {
                    dest[idx] = this.in.readObject();
                    --this.elementsRemaining;
                    continue;
                }
                throw new ArrayIndexOutOfBoundsException("Out of bounds in dest array: " + idx);
            }
        }
        catch (IOException e) {
            throw new DynamicBufferException("Problem reading dynamic buffer", e);
        }
        catch (ClassNotFoundException e) {
            throw new DynamicBufferException("Problem reading dynamic buffer", e);
        }
    }

    private void scatterCheckArgs(int numEls, int idxOff, int indexesLen) throws BufferException {
        if (this.freed) {
            throw new WrongStateException("Buffer has already been freed.");
        }
        if (this.writeable) {
            throw new WrongStateException("Buffer is not in a readable state.");
        }
        if (this.currentSectionType == null) {
            throw new WrongStateException("Missing call to 'getSectionHeader'");
        }
        if (numEls > this.elementsRemaining) {
            throw new SectionSizeMismatchException("Trying to read past end of current section.");
        }
        if (idxOff < 0) {
            throw new ArrayIndexOutOfBoundsException("Out of bounds in indexes array: " + idxOff);
        }
        if (idxOff + numEls > indexesLen) {
            throw new ArrayIndexOutOfBoundsException("Out of bounds in indexes array: " + (idxOff + numEls - 1));
        }
    }

    public void strScatter(byte[] dest, int dstOff, int rank, int exts, int strs, int[] shape) throws BufferException {
        int volume = this.strScatterCheckArgs(dest.length, dstOff, rank, exts, strs, shape);
        if (this.currentSectionType == Type.BYTE) {
            if (volume != 0) {
                this.staticBuffer.strScatter(dest, dstOff, rank, exts, strs, shape, this.readPtr + this.bufoffset, this.encoding != localEncoding);
                this.readPtr += 1 * volume;
                this.elementsRemaining -= volume;
            }
        } else if (this.currentSectionType == Type.BYTE_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                this.doStrScatter(dest, dstOff, rank, exts, strs, shape);
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    private void doStrScatter(byte[] dest, int dstOff, int rank, int exts, int strs, int[] shape) throws IOException {
        if (rank == 0) {
            dest[dstOff] = this.in.readByte();
            --this.elementsRemaining;
        } else {
            for (int i = 0; i < shape[exts]; ++i) {
                this.doStrScatter(dest, dstOff + shape[strs] * i, rank - 1, exts + 1, strs + 1, shape);
            }
        }
    }

    public void strScatter(short[] dest, int dstOff, int rank, int exts, int strs, int[] shape) throws BufferException {
        int volume = this.strScatterCheckArgs(dest.length, dstOff, rank, exts, strs, shape);
        if (this.currentSectionType == Type.SHORT) {
            if (volume != 0) {
                this.staticBuffer.strScatter(dest, dstOff, rank, exts, strs, shape, this.readPtr + this.bufoffset, this.encoding != localEncoding);
                this.readPtr += 2 * volume;
                this.elementsRemaining -= volume;
            }
        } else if (this.currentSectionType == Type.SHORT_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                this.doStrScatter(dest, dstOff, rank, exts, strs, shape);
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    private void doStrScatter(short[] dest, int dstOff, int rank, int exts, int strs, int[] shape) throws IOException {
        if (rank == 0) {
            dest[dstOff] = this.in.readShort();
            --this.elementsRemaining;
        } else {
            for (int i = 0; i < shape[exts]; ++i) {
                this.doStrScatter(dest, dstOff + shape[strs] * i, rank - 1, exts + 1, strs + 1, shape);
            }
        }
    }

    public void strScatter(int[] dest, int dstOff, int rank, int exts, int strs, int[] shape) throws BufferException {
        int volume = this.strScatterCheckArgs(dest.length, dstOff, rank, exts, strs, shape);
        if (this.currentSectionType == Type.INT) {
            if (volume != 0) {
                this.staticBuffer.strScatter(dest, dstOff, rank, exts, strs, shape, this.readPtr + this.bufoffset, this.encoding != localEncoding);
                this.readPtr += 4 * volume;
                this.elementsRemaining -= volume;
            }
        } else if (this.currentSectionType == Type.INT_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                this.doStrScatter(dest, dstOff, rank, exts, strs, shape);
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    private void doStrScatter(int[] dest, int dstOff, int rank, int exts, int strs, int[] shape) throws IOException {
        if (rank == 0) {
            dest[dstOff] = this.in.readInt();
            --this.elementsRemaining;
        } else {
            for (int i = 0; i < shape[exts]; ++i) {
                this.doStrScatter(dest, dstOff + shape[strs] * i, rank - 1, exts + 1, strs + 1, shape);
            }
        }
    }

    public void strScatter(long[] dest, int dstOff, int rank, int exts, int strs, int[] shape) throws BufferException {
        int volume = this.strScatterCheckArgs(dest.length, dstOff, rank, exts, strs, shape);
        if (this.currentSectionType == Type.LONG) {
            if (volume != 0) {
                this.staticBuffer.strScatter(dest, dstOff, rank, exts, strs, shape, this.readPtr + this.bufoffset, this.encoding != localEncoding);
                this.readPtr += 8 * volume;
                this.elementsRemaining -= volume;
            }
        } else if (this.currentSectionType == Type.LONG_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                this.doStrScatter(dest, dstOff, rank, exts, strs, shape);
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    private void doStrScatter(long[] dest, int dstOff, int rank, int exts, int strs, int[] shape) throws IOException {
        if (rank == 0) {
            dest[dstOff] = this.in.readLong();
            --this.elementsRemaining;
        } else {
            for (int i = 0; i < shape[exts]; ++i) {
                this.doStrScatter(dest, dstOff + shape[strs] * i, rank - 1, exts + 1, strs + 1, shape);
            }
        }
    }

    public void strScatter(char[] dest, int dstOff, int rank, int exts, int strs, int[] shape) throws BufferException {
        int volume = this.strScatterCheckArgs(dest.length, dstOff, rank, exts, strs, shape);
        if (this.currentSectionType == Type.CHAR) {
            if (volume != 0) {
                this.staticBuffer.strScatter(dest, dstOff, rank, exts, strs, shape, this.readPtr + this.bufoffset, this.encoding != localEncoding);
                this.readPtr += 2 * volume;
                this.elementsRemaining -= volume;
            }
        } else if (this.currentSectionType == Type.CHAR_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                this.doStrScatter(dest, dstOff, rank, exts, strs, shape);
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    private void doStrScatter(char[] dest, int dstOff, int rank, int exts, int strs, int[] shape) throws IOException {
        if (rank == 0) {
            dest[dstOff] = this.in.readChar();
            --this.elementsRemaining;
        } else {
            for (int i = 0; i < shape[exts]; ++i) {
                this.doStrScatter(dest, dstOff + shape[strs] * i, rank - 1, exts + 1, strs + 1, shape);
            }
        }
    }

    public void strScatter(float[] dest, int dstOff, int rank, int exts, int strs, int[] shape) throws BufferException {
        int volume = this.strScatterCheckArgs(dest.length, dstOff, rank, exts, strs, shape);
        if (this.currentSectionType == Type.FLOAT) {
            if (volume != 0) {
                this.staticBuffer.strScatter(dest, dstOff, rank, exts, strs, shape, this.readPtr + this.bufoffset, this.encoding != localEncoding);
                this.readPtr += 4 * volume;
                this.elementsRemaining -= volume;
            }
        } else if (this.currentSectionType == Type.FLOAT_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                this.doStrScatter(dest, dstOff, rank, exts, strs, shape);
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    private void doStrScatter(float[] dest, int dstOff, int rank, int exts, int strs, int[] shape) throws IOException {
        if (rank == 0) {
            dest[dstOff] = this.in.readFloat();
            --this.elementsRemaining;
        } else {
            for (int i = 0; i < shape[exts]; ++i) {
                this.doStrScatter(dest, dstOff + shape[strs] * i, rank - 1, exts + 1, strs + 1, shape);
            }
        }
    }

    public void strScatter(double[] dest, int dstOff, int rank, int exts, int strs, int[] shape) throws BufferException {
        int volume = this.strScatterCheckArgs(dest.length, dstOff, rank, exts, strs, shape);
        if (this.currentSectionType == Type.DOUBLE) {
            if (volume != 0) {
                this.staticBuffer.strScatter(dest, dstOff, rank, exts, strs, shape, this.readPtr + this.bufoffset, this.encoding != localEncoding);
                this.readPtr += 8 * volume;
                this.elementsRemaining -= volume;
            }
        } else if (this.currentSectionType == Type.DOUBLE_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                this.doStrScatter(dest, dstOff, rank, exts, strs, shape);
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    private void doStrScatter(double[] dest, int dstOff, int rank, int exts, int strs, int[] shape) throws IOException {
        if (rank == 0) {
            dest[dstOff] = this.in.readDouble();
            --this.elementsRemaining;
        } else {
            for (int i = 0; i < shape[exts]; ++i) {
                this.doStrScatter(dest, dstOff + shape[strs] * i, rank - 1, exts + 1, strs + 1, shape);
            }
        }
    }

    public void strScatter(boolean[] dest, int dstOff, int rank, int exts, int strs, int[] shape) throws BufferException {
        int volume = this.strScatterCheckArgs(dest.length, dstOff, rank, exts, strs, shape);
        if (this.currentSectionType == Type.BOOLEAN) {
            if (volume != 0) {
                this.staticBuffer.strScatter(dest, dstOff, rank, exts, strs, shape, this.readPtr + this.bufoffset, this.encoding != localEncoding);
                this.readPtr += 1 * volume;
                this.elementsRemaining -= volume;
            }
        } else if (this.currentSectionType == Type.BOOLEAN_DYNAMIC) {
            try {
                if (this.in == null) {
                    ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                    this.in = new ObjectInputStream(o);
                }
                this.doStrScatter(dest, dstOff, rank, exts, strs, shape);
            }
            catch (IOException e) {
                throw new DynamicBufferException("Problem reading dynamic buffer", e);
            }
        } else {
            throw new TypeMismatchException("Wrong type for current section");
        }
    }

    private void doStrScatter(boolean[] dest, int dstOff, int rank, int exts, int strs, int[] shape) throws IOException {
        if (rank == 0) {
            dest[dstOff] = this.in.readBoolean();
            --this.elementsRemaining;
        } else {
            for (int i = 0; i < shape[exts]; ++i) {
                this.doStrScatter(dest, dstOff + shape[strs] * i, rank - 1, exts + 1, strs + 1, shape);
            }
        }
    }

    public void strScatter(Object[] dest, int dstOff, int rank, int exts, int strs, int[] shape) throws BufferException {
        this.strScatterCheckArgs(dest.length, dstOff, rank, exts, strs, shape);
        if (this.currentSectionType != Type.OBJECT) {
            throw new TypeMismatchException("Wrong type for current section");
        }
        try {
            if (this.inn == null) {
                ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                this.in = new ObjectInputStream(o);
            }
            this.doStrScatter(dest, dstOff, rank, exts, strs, shape);
        }
        catch (ClassNotFoundException e) {
            try {
                ByteArrayInputStream o = new ByteArrayInputStream(this.dynamicBuffer);
                this.inn = new CustomObjectInputStream(o);
                for (int i = 0; i < strs; ++i) {
                    Object obj;
                    dest[dstOff + i] = obj = this.inn.readObject();
                    --this.elementsRemaining;
                }
            }
            catch (Exception ioe) {
                throw new DynamicBufferException("Problem reading dynamic buffer", ioe);
            }
        }
        catch (Exception e) {
            throw new DynamicBufferException("Problem reading dynamic buffer", e);
        }
    }

    private void doStrScatter(Object[] dest, int dstOff, int rank, int exts, int strs, int[] shape) throws IOException, ClassNotFoundException {
        if (rank == 0) {
            dest[dstOff] = this.in.readObject();
            --this.elementsRemaining;
        } else {
            for (int i = 0; i < shape[exts]; ++i) {
                this.doStrScatter(dest, dstOff + shape[strs] * i, rank - 1, exts + 1, strs + 1, shape);
            }
        }
    }

    private int strScatterCheckArgs(int destLen, int dstOff, int rank, int exts, int strs, int[] shape) throws BufferException {
        if (this.freed) {
            throw new WrongStateException("Buffer has already been freed.");
        }
        if (this.writeable) {
            throw new WrongStateException("Buffer is not in a readable state.");
        }
        if (rank < 0) {
            throw new IllegalArgumentException("Negative rank specified");
        }
        if (this.currentSectionType == null) {
            throw new TypeMismatchException("Missing call to 'getSectionHeader'");
        }
        int minIndex = dstOff;
        int maxIndex = dstOff;
        int volume = 1;
        for (int i = 0; i < rank; ++i) {
            int ext = shape[exts + i];
            int str = shape[strs + i];
            if (ext < 0) {
                throw new ArrayIndexOutOfBoundsException("Patch has negative extent.");
            }
            if (ext == 0) {
                return 0;
            }
            if (str < 0) {
                minIndex += str * (ext - 1);
            } else {
                maxIndex += str * (ext - 1);
            }
            volume *= ext;
        }
        if (minIndex < 0) {
            throw new ArrayIndexOutOfBoundsException("Out of bounds in dest array: " + minIndex);
        }
        if (maxIndex >= destLen) {
            throw new ArrayIndexOutOfBoundsException("Out of bounds in dest array: " + maxIndex);
        }
        if (volume > this.elementsRemaining) {
            throw new SectionSizeMismatchException("Trying to read past end of current section.");
        }
        return volume;
    }

    public RawBuffer getStaticBuffer() {
        return this.staticBuffer;
    }

    public void setStaticBuffer(RawBuffer staticBuffer) {
        this.staticBuffer = staticBuffer;
    }

    public ByteOrder getEncoding() {
        return this.encoding;
    }

    public void setEncoding(ByteOrder encoding) {
        if (this.staticBuffer instanceof NIOBuffer) {
            ((NIOBuffer)this.staticBuffer).setEncoding(encoding);
        }
        this.encoding = encoding;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public byte[] getDynamicBuffer() {
        return this.dynamicBuffer;
    }

    public void setDynamicBuffer(byte[] dynamicBuffer) {
        this.dynamicBuffer = dynamicBuffer;
    }

    public boolean isWritable() {
        return this.writeable;
    }
}

